/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollectionSynchronizerFactory;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollectionSynchronizerOptions;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollectionSynchronizer;
import com.tssap.dtr.client.lib.deltavlib.xcm.IResourceResultSet;
import com.tssap.dtr.client.lib.deltavlib.xcm.ResourceCollector;
import com.tssap.dtr.client.lib.deltavlib.xcm.SelectResourcesOption;
import com.tssap.dtr.client.lib.exceptions.ExceptionCategory;
import com.tssap.dtr.client.lib.exceptions.ExceptionSeverity;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepositoryOptions;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspaceFolder;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntry;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class FolderUtil {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$FolderUtil == null ? (class$com$tssap$dtr$client$lib$vfs$impl$FolderUtil = FolderUtil.class$("com.tssap.dtr.client.lib.vfs.impl.FolderUtil")) : class$com$tssap$dtr$client$lib$vfs$impl$FolderUtil));
    private static final IVfsFolderItem[] NO_FOLDER_ITEMS = new IVfsFolderItem[0];
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$FolderUtil;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem;

    FolderUtil() {
    }

    static IVfsFolderItem[] getRefreshedFolderItems(VfsFolderItem parentFolder, boolean allowFiles) throws VfsException {
        FolderUtil.adjustLocationStateBeforeRefreshingFolderItems(parentFolder);
        IResource[] remoteChildren = FolderUtil.getRemoteChildren(parentFolder.m_dvVcr);
        VirtualFilesByAbsolutePath localChildrenMap = FolderUtil.getLocalChildren(parentFolder);
        Object[] nonLocalOnlyItems = FolderUtil.createFolderItemsForNonLocalOnlyItems(remoteChildren, localChildrenMap, parentFolder, allowFiles);
        Object[] localOnlyItems = FolderUtil.createLocalOnlyItems(localChildrenMap, (VfsWorkspace)parentFolder.getWorkspace(), allowFiles);
        return (IVfsFolderItem[])FolderUtil.joinArrays(class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem = FolderUtil.class$("com.tssap.dtr.client.lib.vfs.IVfsFolderItem")) : class$com$tssap$dtr$client$lib$vfs$IVfsFolderItem, nonLocalOnlyItems, localOnlyItems);
    }

    private static Object[] joinArrays(Class baseType, Object[] firstArray, Object[] secondArray) {
        if (firstArray == null) {
            firstArray = new Object[]{};
        }
        if (secondArray == null) {
            secondArray = new Object[]{};
        }
        Object[] joinedArray = (Object[])Array.newInstance(baseType, firstArray.length + secondArray.length);
        System.arraycopy(firstArray, 0, joinedArray, 0, firstArray.length);
        System.arraycopy(secondArray, 0, joinedArray, firstArray.length, secondArray.length);
        return joinedArray;
    }

    private static void adjustLocationStateBeforeRefreshingFolderItems(VfsFolderItem parentFolder) {
        try {
            IVfsContext context;
            SyncDB syncDB;
            SyncEntry syncEntry;
            if (parentFolder.isMounted() && (syncEntry = (syncDB = (context = parentFolder.getWorkspace().getContext()).getSyncDb(parentFolder.getLocalPath())).getEntry(parentFolder.getLocalPath())) != null) {
                if (parentFolder.m_dvVcr != null && !VfsActivityRecordedFolderItem.isDvResourceDeleted(parentFolder.m_dvVcr)) {
                    Date lastModified = parentFolder.m_dvVcr.lastModified();
                    if (syncEntry.getRemoteSyncTime() < lastModified.getTime()) {
                        parentFolder.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
                    }
                } else if (syncEntry.isSynced()) {
                    parentFolder.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
                }
            }
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
        }
    }

    private static IResource[] getRemoteChildren(IResource resource) throws VfsException {
        IResource[] remoteChildren = new IResource[]{};
        if (resource != null) {
            try {
                ICollection dvCollection = resource.getAsCollection();
                if (dvCollection == null) {
                    LOCATION.infoT("Getting remote child resources failed. {0} is no collection.", new Object[]{resource.getPersistentURL()});
                } else {
                    remoteChildren = dvCollection.listMembers();
                }
            }
            catch (VcmFailure vcmFailure) {
                if (vcmFailure.getStatusCode() == 403) {
                    throw new VfsException(ExceptionSeverity.ERROR, ExceptionCategory.FORBIDDEN, new Object[]{resource.getPersistentURL()}, new Throwable[]{vcmFailure});
                }
                throw new VfsException("Getting remote child resources failed for " + resource.getPersistentURL(), vcmFailure);
            }
        }
        return remoteChildren;
    }

    private static VirtualFilesByAbsolutePath getLocalChildren(VfsFolderItem parentFolder) {
        VirtualFilesByAbsolutePath localChildrenMap;
        block6: {
            block5: {
                localChildrenMap = new VirtualFilesByAbsolutePath();
                if (!parentFolder.isMounted()) break block5;
                IVirtualFile[] localChildren = parentFolder.m_localFile.listFiles();
                if (localChildren == null) break block6;
                int i = 0;
                while (i < localChildren.length) {
                    localChildrenMap.put(localChildren[i]);
                    ++i;
                }
                break block6;
            }
            IVfsContext context = parentFolder.getContext();
            IVfsRemoteLocator[] mountPoints = context.getRemoteLocatorsOfMountPoints();
            IVfsRemoteLocator parentLocator = parentFolder.getRemoteLocator();
            int i = 0;
            while (i < mountPoints.length) {
                IVfsRemoteLocator mountPoint = mountPoints[i];
                if (mountPoint.getConnectionTemplateId() == parentLocator.getConnectionTemplateId()) {
                    String mountpointParent = PathUtilities.getParentPath(mountPoint.getAbsoluteRemotePath(), PathUtilities.REMOTE_FILESERVICE, false);
                    if (parentLocator.getAbsoluteRemotePath().equals(mountpointParent)) {
                        String absoluteLocalPath = context.getAbsoluteLocalPath(mountPoint.getConnectionTemplateId(), mountPoint.getAbsoluteRemotePath());
                        IVirtualFile localChild = parentFolder.getContext().getFileService().constructFile(absoluteLocalPath);
                        if (localChild.exists()) {
                            localChildrenMap.put(localChild);
                        }
                    }
                }
                ++i;
            }
        }
        return localChildrenMap;
    }

    private static IVfsFolderItem[] createFolderItemsForNonLocalOnlyItems(IResource[] remoteChildren, VirtualFilesByAbsolutePath localChildrenMap, VfsFolderItem parentFolder, boolean allowFiles) throws VfsException {
        IVfsFolderItem[] folderItems = new IVfsFolderItem[remoteChildren.length];
        int i = 0;
        while (i < remoteChildren.length) {
            IResource resource = remoteChildren[i];
            String canonicalName = null;
            IVersionControlledResource dvVcr = null;
            boolean isCollection = false;
            try {
                canonicalName = resource.getCanonicalName();
                dvVcr = resource.getAsVersionControlled();
                isCollection = resource.isCollection();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException(vcmFailure.getMessage(), vcmFailure);
            }
            IVirtualFile localChild = Util.getLocalFile(parentFolder.getContext(), parentFolder.m_localFile, canonicalName, resource.getConnectionTemplID(), parentFolder.getAbsoluteRemotePath());
            if (localChild == null) {
                localChild = VfsFolderItem.NULL_LOCAL_FILE;
            } else {
                localChildrenMap.remove(localChild.getAbsolutePath());
            }
            if (allowFiles || isCollection) {
                folderItems[i] = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(parentFolder.getWorkspace(), dvVcr, localChild);
            }
            ++i;
        }
        return folderItems;
    }

    private static IVfsFolderItem[] createLocalOnlyItems(VirtualFilesByAbsolutePath localChildrenMap, VfsWorkspace workspace, boolean allowFiles) throws VfsException {
        ArrayList<VfsActivityRecordedFolderItem> localOnlyItems = new ArrayList<VfsActivityRecordedFolderItem>();
        Iterator localOnlyFiles = localChildrenMap.values();
        while (localOnlyFiles.hasNext()) {
            IVirtualFile localChild = (IVirtualFile)localOnlyFiles.next();
            if (!allowFiles && !localChild.isDirectory()) continue;
            localOnlyItems.add(VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(workspace, VfsFolderItem.NULL_DELTAV_RESOURCE, localChild));
        }
        return localOnlyItems.toArray(new IVfsFolderItem[0]);
    }

    static Collection getMountPointFolderItemsBelow(IVfsGenericFolder folder) throws VfsException {
        VfsFolderItem folderItem = (VfsFolderItem)((Object)folder);
        if (folderItem == null) {
            return Collections.EMPTY_LIST;
        }
        IVfsContext context = folderItem.getContext();
        IVersionedFileSystemManager manager = folderItem.getVersionedFileSystemManager();
        IVfsRemoteLocator[] mountPointLocators = context.getRemoteLocatorsOfMountPoints();
        ArrayList<IVfsFolderItem> mountedFolderList = new ArrayList<IVfsFolderItem>();
        int i = 0;
        while (i < mountPointLocators.length) {
            IVfsRemoteLocator mountPointLocator = mountPointLocators[i];
            if (mountPointLocators[i].getAbsoluteRemotePath().startsWith(folderItem.getPath())) {
                String mountPointLocalPath = context.getAbsoluteLocalPath(mountPointLocator.getConnectionTemplateId(), mountPointLocator.getAbsoluteRemotePath());
                if (mountPointLocalPath != null) {
                    IVfsFolderItem mountPointFolderItem;
                    block9: {
                        mountPointFolderItem = null;
                        try {
                            mountPointFolderItem = manager.getFolderItem(mountPointLocalPath);
                        }
                        catch (VfsException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof VcmFailure && ((VcmFailure)cause).getStatusCode() == 404) break block9;
                            throw e;
                        }
                    }
                    if (mountPointFolderItem != null) {
                        mountedFolderList.add(mountPointFolderItem);
                    } else {
                        Logbook.getWarnChapter().println("Resource for mountpoint was not found on repository: " + mountPointLocator.getAbsoluteRemotePath());
                    }
                } else {
                    LOCATION.warningT("Local path of mountpoint is null: " + mountPointLocator.getAbsoluteRemotePath());
                }
            }
            ++i;
        }
        return mountedFolderList;
    }

    static IVfsFolderItem[] removeFolderItems(IVfsFolderItem[] oldFolderItems, Map folderItemsToRemove) {
        if (oldFolderItems == null || oldFolderItems.length == 0) {
            return oldFolderItems;
        }
        ArrayList<IVfsFolderItem> newFolderItems = new ArrayList<IVfsFolderItem>();
        int i = 0;
        while (i < oldFolderItems.length) {
            IVfsFolderItem folderItem = oldFolderItems[i];
            if (folderItemsToRemove.get(folderItem.getAbsoluteRemotePath()) == null) {
                newFolderItems.add(folderItem);
            }
            ++i;
        }
        return newFolderItems.toArray(NO_FOLDER_ITEMS);
    }

    static WeakReference[] removeFolderItems(WeakReference[] oldFolderItems, Map folderItemsToRemove) {
        if (oldFolderItems == null || oldFolderItems.length == 0) {
            return oldFolderItems;
        }
        ArrayList<IVfsFolderItem> newFolderItems = new ArrayList<IVfsFolderItem>();
        int i = 0;
        while (i < oldFolderItems.length) {
            IVfsFolderItem folderItem = (IVfsFolderItem)oldFolderItems[i].get();
            if (folderItem != null) {
                if (folderItemsToRemove.get(folderItem.getAbsoluteRemotePath()) == null) {
                    newFolderItems.add(folderItem);
                }
            } else {
                newFolderItems.add(null);
            }
            ++i;
        }
        WeakReference[] newFolderItemsWeak = new WeakReference[newFolderItems.size()];
        int i2 = 0;
        while (i2 < newFolderItems.size()) {
            newFolderItemsWeak[i2] = new WeakReference(newFolderItems.get(i2));
            ++i2;
        }
        return newFolderItemsWeak;
    }

    static String[] getPathsOfLocalOnlyFolderItemsBelow(IVfsGenericFolder folder, boolean includeItemsCheckedOutForCreate) throws VfsException {
        Map checkedOutItemsByLocalPath;
        if (folder == null) {
            return new String[0];
        }
        if (folder.asWorkspaceFolder() != null) {
            throw new UnsupportedOperationException("Method is not supported for workspace folders (" + folder.getLocalPath() + ").");
        }
        VfsFolderItem folderItem = (VfsFolderItem)((Object)folder);
        ArrayList localPathsOfMountedFolders = FolderUtil.getLocalMountpointPathsBelow(folderItem);
        if (includeItemsCheckedOutForCreate) {
            checkedOutItemsByLocalPath = Collections.EMPTY_MAP;
        } else {
            IVfsWorkspace workspace = folderItem.asFolder() != null ? folderItem.asFolder().getWorkspace() : folderItem.asWorkspace();
            checkedOutItemsByLocalPath = FolderUtil.constructCheckedOutItemsByLocalPathMap(workspace);
        }
        ArrayList pathsOfLocalOnlyItems = new ArrayList();
        Iterator iterator = ((AbstractList)localPathsOfMountedFolders).iterator();
        while (iterator.hasNext()) {
            String localPathOfMountedFolder = (String)iterator.next();
            SyncDB syncDB = folderItem.getContext().getSyncDb(localPathOfMountedFolder);
            if (syncDB == null) {
                throw new IllegalStateException("No SyncDB for mounted folder " + localPathOfMountedFolder);
            }
            pathsOfLocalOnlyItems.addAll(FolderUtil.getLocalOnlyNotCheckedOutItems(folderItem.getLocalFile().getFileService().constructFile(localPathOfMountedFolder), syncDB, checkedOutItemsByLocalPath));
        }
        return pathsOfLocalOnlyItems.toArray(new String[pathsOfLocalOnlyItems.size()]);
    }

    private static ArrayList getLocalMountpointPathsBelow(VfsFolderItem folderItem) {
        ArrayList<String> localPathsOfMountedFolders = new ArrayList<String>();
        if (folderItem.isMounted()) {
            localPathsOfMountedFolders.add(folderItem.getLocalPath());
        } else {
            IVfsRemoteLocator[] mountPointLocators = folderItem.getContext().getRemoteLocatorsOfMountPoints();
            IVfsRemoteLocator locator = folderItem.getRemoteLocator();
            int i = 0;
            while (i < mountPointLocators.length) {
                IVfsRemoteLocator mountPointLocator = mountPointLocators[i];
                if (mountPointLocator.getConnectionTemplateId() == locator.getConnectionTemplateId() && mountPointLocator.getAbsoluteRemotePath().startsWith(locator.getAbsoluteRemotePath())) {
                    String localPath = folderItem.getContext().getAbsoluteLocalPath(mountPointLocator.getConnectionTemplateId(), mountPointLocator.getAbsoluteRemotePath());
                    localPathsOfMountedFolders.add(localPath);
                }
                ++i;
            }
        }
        return localPathsOfMountedFolders;
    }

    private static Collection getLocalOnlyNotCheckedOutItems(IVirtualFile file, SyncDB syncDB, Map checkedOutItemsByLocalPath) {
        SyncEntry syncEntry;
        ArrayList<String> items = new ArrayList<String>();
        if (file.isDirectory()) {
            IVirtualFile[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                IVirtualFile child = children[i];
                items.addAll(FolderUtil.getLocalOnlyNotCheckedOutItems(child, syncDB, checkedOutItemsByLocalPath));
                ++i;
            }
        }
        if (!((syncEntry = syncDB.getEntry(file.getAbsolutePath())) != null && syncEntry.isSynced() || checkedOutItemsByLocalPath.get(file.getAbsolutePath()) != null)) {
            items.add(file.getAbsolutePath());
        }
        return items;
    }

    static Map constructCheckedOutItemsByLocalPathMap(IVfsWorkspace workspace) throws VfsException {
        IVfsActivity[] openActivities = workspace.getActivities(VfsActivityState.OPEN);
        HashMap<String, IVfsActivityRecordedFolderItem> checkedOutItemsByLocalPath = new HashMap<String, IVfsActivityRecordedFolderItem>();
        int i = 0;
        while (i < openActivities.length) {
            IVfsActivity openActivity = openActivities[i];
            IVfsActivityRecordedFolderItem[] checkedOutItems = openActivity.getElementsFromOpenActivity();
            int j = 0;
            while (j < checkedOutItems.length) {
                IVfsActivityRecordedFolderItem checkedOutItem = checkedOutItems[j];
                if (checkedOutItem.getLocalFile() != null) {
                    checkedOutItemsByLocalPath.put(checkedOutItem.getLocalFile().getAbsolutePath(), checkedOutItem);
                } else {
                    VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.WARN_LOG, checkedOutItem, "Found checked out folder item without mount point.");
                }
                ++j;
            }
            ++i;
        }
        return checkedOutItemsByLocalPath;
    }

    static IVfsGenericFolder getFolderAndInitializeChildren(VfsRepository repository, String decodedAbsoluteRemoteParentPath) throws VfsException {
        if (repository.supportsMget()) {
            return FolderUtil.getFolderAndInitializeChildren_usingMget(repository, decodedAbsoluteRemoteParentPath);
        }
        return FolderUtil.getFolderAndInitializeChildren_usingStandardDeltaV(repository, decodedAbsoluteRemoteParentPath);
    }

    private static IVfsFolder getFolderAndInitializeChildren_usingStandardDeltaV(VfsRepository repository, String decodedAbsoluteRemoteParentPath) throws VfsException {
        String METHOD = "getFolderAndInitializeChildren_usingStandardDeltaV";
        LOCATION.pathT("getFolderAndInitializeChildren_usingStandardDeltaV", "Path: {0}", new Object[]{decodedAbsoluteRemoteParentPath});
        IVfsContext context = repository.getContext();
        String browsePath = context.getBrowsePath(new VfsRemoteLocator(repository.getConnectionTemplateId(), decodedAbsoluteRemoteParentPath, decodedAbsoluteRemoteParentPath));
        if (browsePath == null) {
            return null;
        }
        IVfsFolderItem folderItem = repository.getVersionedFileSystemManager().getFolderItemByBrowsePath(browsePath);
        if (folderItem == null) {
            return null;
        }
        if (folderItem.asFolder() == null) {
            throw new VfsException("Folder item for given path is no folder: " + folderItem.getUrl());
        }
        folderItem.asFolder().refreshFolderItems();
        return folderItem.asFolder();
    }

    private static IVfsGenericFolder getFolderAndInitializeChildren_usingMget(VfsRepository repository, String decodedAbsoluteRemoteParentPath) throws VfsException {
        String METHOD = "getFolderAndInitializeChildren_usingMget";
        LOCATION.pathT("getFolderAndInitializeChildren_usingMget", "Path: {0}", new Object[]{decodedAbsoluteRemoteParentPath});
        IResourceResultSet resultSet = FolderUtil.getDvFolderAndChildrenUsingMget(repository.getConnectionTemplateId(), decodedAbsoluteRemoteParentPath, repository.getSyncOptions());
        if (resultSet.getInvalidCount() > 0) {
            return FolderUtil.logResultSetAndThrow(resultSet, "Invalid resources detected: " + decodedAbsoluteRemoteParentPath);
        }
        if (!resultSet.getCompleted() && repository.getListCollectionReportOptions().containsKey(VfsRepositoryOptions.ListCollectionReportOption.END_OF_RESPONSE_RESOURCE)) {
            return FolderUtil.logResultSetAndThrow(resultSet, "List-collection-report request not completed : " + decodedAbsoluteRemoteParentPath);
        }
        if (resultSet.getCollectionCount() > 0) {
            return FolderUtil.wrapWorkspaceFolderAndChildren(FolderUtil.findParent(resultSet.getCollections(), decodedAbsoluteRemoteParentPath), resultSet.getCollections(), resultSet.getWorkspaces(), repository);
        }
        if (resultSet.getWorkspaceCount() == 1) {
            return FolderUtil.wrapWorkspaceAndChildren(resultSet.getWorkspaces()[0], resultSet.getVcrCollections(), repository);
        }
        if (resultSet.getVcrCollectionCount() > 0) {
            IWorkspace dvWorkspaceProxy = null;
            try {
                dvWorkspaceProxy = resultSet.getVcrCollections()[0].getWorkspace();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException(vcmFailure.getMessage(), vcmFailure);
            }
            String workspaceRemotePath = PathUtilities.assureTrailingSeparator(dvWorkspaceProxy.getDecodedPath(), PathUtilities.REMOTE_FILESERVICE);
            VfsWorkspace workspace = (VfsWorkspace)repository.getWorkspaceByPathFromCache(workspaceRemotePath);
            if (workspace == null) {
                throw new VfsException("Could not get workspace from cache for " + dvWorkspaceProxy.getPersistentURL());
            }
            return FolderUtil.wrapFolderAndChildren(FolderUtil.findParent(resultSet.getVcrCollections(), decodedAbsoluteRemoteParentPath), resultSet.getVcrCollections(), resultSet.getVcrFiles(), workspace);
        }
        if (resultSet.getVcrFileCount() == 1) {
            return FolderUtil.logResultSetAndThrow(resultSet, "File but no folder detected: " + decodedAbsoluteRemoteParentPath);
        }
        if (resultSet.getWorkspaceCount() == 0 && resultSet.getVcrFileCount() == 0) {
            String absoluteLocalPath = repository.getContext().getAbsoluteLocalPath(repository.getConnectionTemplateId(), decodedAbsoluteRemoteParentPath);
            if (absoluteLocalPath != null) {
                VfsFolderItem folderItem = repository.getVersionedFileSystemManager().getFolderItemCache().getFolderItemWithLocalPath(absoluteLocalPath);
                if (folderItem != null) {
                    return folderItem.asGenericFolder();
                }
                IVirtualFile localFile = repository.getContext().getFileService().constructFile(absoluteLocalPath);
                if (localFile.exists()) {
                    IVfsWorkspace[] workspaces = repository.getWorkspaces();
                    int i = 0;
                    while (i < workspaces.length) {
                        IVfsWorkspace workspace = workspaces[i];
                        if (decodedAbsoluteRemoteParentPath.startsWith(workspace.getAbsoluteRemotePath())) {
                            folderItem = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(workspace, VfsFolderItem.NULL_DELTAV_RESOURCE, localFile);
                            IVfsFolder folder = folderItem.asFolder();
                            folder.refreshFolderItems();
                            return folder;
                        }
                        ++i;
                    }
                }
            }
            return null;
        }
        return FolderUtil.logResultSetAndThrow(resultSet, "Unexpected server result for " + decodedAbsoluteRemoteParentPath);
    }

    private static IVfsGenericFolder logResultSetAndThrow(IResourceResultSet resultSet, String exceptionMessage) throws VfsException {
        PrintStream out = Logbook.getErrorChapter(2);
        out.println("IResourceResultSet @" + resultSet.getServerTime() + " (" + resultSet.getTotalCount() + " resources):");
        FolderUtil.logResourceArray(out, "Collections", resultSet.getCollections());
        FolderUtil.logResourceArray(out, "Workspaces", resultSet.getWorkspaces());
        FolderUtil.logResourceArray(out, "VcrCollections", resultSet.getVcrCollections());
        FolderUtil.logResourceArray(out, "VcrFiles", resultSet.getVcrFiles());
        FolderUtil.logResourcePathArray(out, "Invalid Resources", resultSet.getInvalidResourcePaths());
        throw new VfsException(exceptionMessage);
    }

    private static void logResourceArray(PrintStream out, String text, IResource[] resources) {
        if (resources.length > 0) {
            out.println("\t" + resources.length + " " + text);
            int i = 0;
            while (i < resources.length) {
                out.println("\t\t" + resources[i].getPersistentURL());
                ++i;
            }
        }
    }

    private static void logResourcePathArray(PrintStream out, String text, String[] resourcePaths) {
        if (resourcePaths.length > 0) {
            out.println("\t" + resourcePaths.length + " " + text);
            int i = 0;
            while (i < resourcePaths.length) {
                out.println("\t\t" + resourcePaths[i]);
                ++i;
            }
        }
    }

    private static IResource findParent(IResource[] resources, String decodedAbsoluteRemoteParentPath) {
        String remotePathToFind = PathUtilities.preventTrailingSeparator(decodedAbsoluteRemoteParentPath, PathUtilities.REMOTE_FILESERVICE);
        int i = resources.length - 1;
        while (i >= 0) {
            IResource resource = resources[i];
            String remotePath = null;
            try {
                remotePath = PathUtilities.preventTrailingSeparator(resource.getCanonicalPath(), PathUtilities.REMOTE_FILESERVICE);
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsRuntimeException("Internal error: get canonical path failed for " + resource.getPersistentURL());
            }
            if (remotePath.equals(remotePathToFind)) {
                return resource;
            }
            --i;
        }
        return null;
    }

    private static IVfsGenericFolder wrapWorkspaceFolderAndChildren(IResource dvWorkspaceFolder, ICollection[] dvWorkspaceFolders, IWorkspace[] dvChildWorkspaces, VfsRepository repository) throws VfsException {
        VersionedFileSystemManager manager = repository.getVersionedFileSystemManager();
        try {
            IVirtualFile parentFile = FolderUtil.getLocalFile(manager.getCurrentContext(), dvWorkspaceFolder);
            VfsWorkspaceFolder parent = VfsWorkspaceFolder.getVfsWorkspaceFolder(manager, dvWorkspaceFolder, parentFile);
            if (parent == null) {
                throw new VfsException("Could not get VfsWorkspaceFolder for " + dvWorkspaceFolder.getPersistentURL());
            }
            HashSet<ICollection> dvChildren = new HashSet<ICollection>();
            dvChildren.addAll(Arrays.asList(dvWorkspaceFolders));
            dvChildren.addAll(Arrays.asList(dvChildWorkspaces));
            dvChildren.remove(dvWorkspaceFolder);
            ArrayList dvChildList = new ArrayList(dvChildren);
            IResource[] dvChildResources = dvChildList.toArray(new IResource[dvChildList.size()]);
            parent.initializeChildren(dvChildResources, manager);
            return parent;
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException(vcmFailure.getMessage(), vcmFailure);
        }
    }

    private static IVfsGenericFolder wrapWorkspaceAndChildren(IWorkspace dvWorkspace, IVersionControlledResource[] dvChildFolders, VfsRepository repository) throws VfsException {
        ArrayList<VfsActivityRecordedFolderItem> childFolderItemList;
        VfsWorkspace parent;
        VersionedFileSystemManager manager = repository.getVersionedFileSystemManager();
        try {
            VfsActivityRecordedFolderItem childFolder;
            IVirtualFile parentFile = FolderUtil.getLocalFile(manager.getCurrentContext(), dvWorkspace);
            parent = VfsWorkspace.getVfsWorkspace(repository, dvWorkspace, parentFile);
            if (parent == null) {
                throw new VfsException("Could not get VfsWorkspace for " + dvWorkspace.getPersistentURL());
            }
            VirtualFilesByAbsolutePath localChildren = FolderUtil.getLocalChildren(parent);
            childFolderItemList = new ArrayList<VfsActivityRecordedFolderItem>(dvChildFolders.length + localChildren.size());
            int i = 0;
            while (i < dvChildFolders.length) {
                IVersionControlledResource dvChildFolder = dvChildFolders[i];
                IVirtualFile childFile = FolderUtil.getLocalFile(manager.getCurrentContext(), dvChildFolder);
                if (localChildren.get(childFile.getAbsolutePath()) != null) {
                    localChildren.remove(childFile.getAbsolutePath());
                }
                if ((childFolder = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(parent, dvChildFolder, childFile)) != null) {
                    childFolderItemList.add(childFolder);
                } else {
                    LOCATION.errorT("Could not get VfsFolder for " + dvChildFolder.getPersistentURL());
                }
                ++i;
            }
            Iterator iterator = localChildren.values();
            while (iterator.hasNext()) {
                IVirtualFile localOnlyChild = (IVirtualFile)iterator.next();
                if (!localOnlyChild.isDirectory() || (childFolder = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(parent, VfsFolderItem.KEEP_DELTAV_RESOURCE, localOnlyChild)) == null) continue;
                childFolderItemList.add(childFolder);
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException(vcmFailure.getMessage(), vcmFailure);
        }
        IVfsFolderItem[] childFolderItems = childFolderItemList.toArray(new IVfsFolderItem[childFolderItemList.size()]);
        parent.initializeChildren(childFolderItems);
        return parent;
    }

    private static IVfsGenericFolder wrapFolderAndChildren(IResource dvFolder, IVersionControlledResource[] dvFolders, IVersionControlledResource[] dvChildFiles, VfsWorkspace workspace) throws VfsException {
        ArrayList<VfsActivityRecordedFolderItem> childFolderItemList;
        VfsFolder parent;
        VersionedFileSystemManager manager = workspace.getVfsManager();
        try {
            VfsActivityRecordedFolderItem childFolderItem;
            if (dvFolder == null) {
                LOCATION.errorT("Internal Error: Parent folder is <null>");
                return null;
            }
            IVirtualFile parentFile = FolderUtil.getLocalFile(manager.getCurrentContext(), dvFolder);
            VfsActivityRecordedFolderItem parentFolderItem = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(workspace, dvFolder.getAsVersionControlled(), parentFile);
            if (parentFolderItem == null || parentFolderItem.asFolder() == null) {
                throw new VfsException("Could not get VfsFolder for " + dvFolder.getPersistentURL());
            }
            parent = (VfsFolder)parentFolderItem.asFolder();
            HashSet<IVersionControlledResource> dvChildren = new HashSet<IVersionControlledResource>();
            dvChildren.addAll(Arrays.asList(dvFolders));
            dvChildren.addAll(Arrays.asList(dvChildFiles));
            dvChildren.remove(dvFolder);
            VirtualFilesByAbsolutePath localChildren = FolderUtil.getLocalChildren(parent);
            childFolderItemList = new ArrayList<VfsActivityRecordedFolderItem>(dvChildren.size());
            Iterator iterator = dvChildren.iterator();
            while (iterator.hasNext()) {
                IVersionControlledResource resource = (IVersionControlledResource)iterator.next();
                IVirtualFile childFile = FolderUtil.getLocalFile(manager.getCurrentContext(), resource);
                if (localChildren.get(childFile.getAbsolutePath()) != null) {
                    localChildren.remove(childFile.getAbsolutePath());
                }
                if ((childFolderItem = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(workspace, resource, childFile)) != null) {
                    childFolderItemList.add(childFolderItem);
                    continue;
                }
                LOCATION.errorT("Could not get VfsActivityRecordedFolderItem for " + resource.getPersistentURL());
            }
            Iterator iterator2 = localChildren.values();
            while (iterator2.hasNext()) {
                IVirtualFile localOnlyChild = (IVirtualFile)iterator2.next();
                childFolderItem = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(workspace, VfsFolderItem.NULL_DELTAV_RESOURCE, localOnlyChild);
                if (childFolderItem == null) continue;
                childFolderItemList.add(childFolderItem);
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException(vcmFailure.getMessage(), vcmFailure);
        }
        IVfsFolderItem[] childFolderItems = childFolderItemList.toArray(new IVfsFolderItem[childFolderItemList.size()]);
        parent.initializeChildren(childFolderItems);
        return parent;
    }

    private static IResourceResultSet getDvFolderAndChildrenUsingMget(int connectionTemplateId, String decodedAbsoluteRemoteParentPath, CollectionSynchronizerOptions syncOptions) throws VfsException {
        IResourceResultSet resultSet;
        ICollectionSynchronizer collectionSynchronizer = CollectionSynchronizerFactory.createSynchronizer(syncOptions);
        SelectResourcesOption selectOptions = new SelectResourcesOption();
        selectOptions.setDepth(1);
        selectOptions.setPropertiesOnly(true);
        try {
            resultSet = collectionSynchronizer.findSelectedResources(connectionTemplateId, new String[]{decodedAbsoluteRemoteParentPath}, selectOptions);
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() != 404) {
                throw new VfsException(vcmFailure.getMessage(), vcmFailure);
            }
            ResourceCollector resourceCollector = new ResourceCollector();
            resourceCollector.requestCompleted();
            resultSet = resourceCollector;
        }
        return resultSet;
    }

    static IVfsActivityRecordedFolderItem getFolderItem(IVersionControlledResource dvResource, IVfsWorkspace workspace) throws VfsException {
        try {
            IVirtualFile virtualFile = FolderUtil.getLocalFile(workspace.getContext(), dvResource);
            return VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(workspace, dvResource, virtualFile);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException(vcmFailure.getMessage(), vcmFailure);
        }
    }

    private static IVirtualFile getLocalFile(IVfsContext context, IResource dvResource) throws VcmFailure {
        String localPath = context.getAbsoluteLocalPath(dvResource.getConnectionTemplID(), dvResource.getCanonicalPath());
        IVirtualFile virtualFile = localPath == null ? VfsFolderItem.NULL_LOCAL_FILE : context.getFileService().constructFile(localPath);
        return virtualFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VirtualFilesByAbsolutePath {
        private Map _files = new HashMap();

        private VirtualFilesByAbsolutePath() {
        }

        void put(IVirtualFile virtualFile) {
            if (virtualFile != null) {
                this._files.put(virtualFile.getAbsolutePath(), virtualFile);
            }
        }

        IVirtualFile get(String absolutePath) {
            return (IVirtualFile)this._files.get(absolutePath);
        }

        int size() {
            return this._files.size();
        }

        IVirtualFile remove(String absolutePath) {
            return (IVirtualFile)this._files.remove(absolutePath);
        }

        Iterator values() {
            return this._files.values().iterator();
        }

        Set keySet() {
            return this._files.keySet();
        }
    }
}

