/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.MultiMap;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.fileservice.LocalFileService;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class FolderItemCache {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$FolderItemCache == null ? (class$com$tssap$dtr$client$lib$vfs$impl$FolderItemCache = FolderItemCache.class$("com.tssap.dtr.client.lib.vfs.impl.FolderItemCache")) : class$com$tssap$dtr$client$lib$vfs$impl$FolderItemCache));
    private static final Integer CONFIG_MOUNTED_ITEMS_CACHE_SIZE = Integer.getInteger("vfs.cache.mounted_items.size");
    private long m_mountedItemsCacheSize = 10000L;
    private static final Integer CONFIG_MOUNTED_ITEMS_CACHE_SWAPPING_NUMBER = Integer.getInteger("vfs.cache.mounted_items.swapping_number");
    private long m_mountedItemsCacheSwappingNumber = 1000L;
    private static final Integer CONFIG_MOUNTED_ITEMS_SHADOW_CACHE_EXPIRED_TIME = Integer.getInteger("vfs.cache.mounted_items.shadow_expired_time");
    private long m_mountedItemsShadowCacheExpiredTime = 1800000L;
    private static final boolean CONFIG_MOUNTED_ITMES_CACHE_CHECKING = Boolean.getBoolean("vfs.cache.consistency.check");
    private static boolean m_mountedItemsCacheChecking = false;
    private IVfsContext m_context = null;
    private HashMap m_repositories = null;
    private HashMap m_workspaces = null;
    private CacheWithWeakShadow m_itemsWithLocalPath = null;
    private MultiMap m_itemsOnlyWithBrowsePath = new MultiMap();
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$FolderItemCache;

    private FolderItemCache(HashMap repositories, HashMap workspaces, IVfsContext context) {
        if (CONFIG_MOUNTED_ITEMS_CACHE_SIZE != null) {
            this.m_mountedItemsCacheSize = CONFIG_MOUNTED_ITEMS_CACHE_SIZE.longValue() <= 0L ? 0L : CONFIG_MOUNTED_ITEMS_CACHE_SIZE.longValue();
        }
        if (CONFIG_MOUNTED_ITEMS_CACHE_SWAPPING_NUMBER != null && CONFIG_MOUNTED_ITEMS_CACHE_SWAPPING_NUMBER.longValue() > 0L) {
            this.m_mountedItemsCacheSwappingNumber = CONFIG_MOUNTED_ITEMS_CACHE_SWAPPING_NUMBER.longValue();
        }
        if (CONFIG_MOUNTED_ITEMS_SHADOW_CACHE_EXPIRED_TIME != null && CONFIG_MOUNTED_ITEMS_SHADOW_CACHE_EXPIRED_TIME.longValue() > 0L) {
            this.m_mountedItemsShadowCacheExpiredTime = CONFIG_MOUNTED_ITEMS_SHADOW_CACHE_EXPIRED_TIME.longValue();
        }
        m_mountedItemsCacheChecking = CONFIG_MOUNTED_ITMES_CACHE_CHECKING;
        this.m_context = context;
        this.m_repositories = repositories;
        this.m_workspaces = workspaces;
        this.m_itemsWithLocalPath = new CacheWithWeakShadow(this.m_mountedItemsCacheSize, this.m_mountedItemsCacheSwappingNumber, this.m_mountedItemsShadowCacheExpiredTime);
        this.m_itemsWithLocalPath.setCacheChecking(m_mountedItemsCacheChecking);
    }

    static void refreshFolderItemCache(VersionedFileSystemManager vfsManager, HashMap repositories, HashMap workspaces, IVfsContext context) {
        FolderItemCache folderItemCache = new FolderItemCache(repositories, workspaces, context);
        vfsManager.setFolderItemCache(folderItemCache);
        Iterator repositoryIterator = repositories.values().iterator();
        while (repositoryIterator.hasNext()) {
            ((VfsRepository)repositoryIterator.next()).setFolderItemCache(folderItemCache);
        }
    }

    void release() {
        Iterator repositoryIterator = this.m_repositories.values().iterator();
        while (repositoryIterator.hasNext()) {
            ((VfsRepository)repositoryIterator.next()).setFolderItemCache(null);
        }
        this.m_context = null;
        this.m_itemsOnlyWithBrowsePath.clear();
        this.m_itemsOnlyWithBrowsePath = null;
        this.m_itemsWithLocalPath.clear();
        this.m_itemsWithLocalPath = null;
        this.m_repositories.clear();
        this.m_repositories = null;
        this.m_workspaces.clear();
        this.m_workspaces = null;
    }

    private VfsFolderItem getItemFromCacheWithLocalPath(String absoluteLocalPath) {
        return (VfsFolderItem)this.m_itemsWithLocalPath.get((Comparable)((Object)absoluteLocalPath));
    }

    private void addItemToCacheWithLocalPath(VfsFolderItem folderItem) {
        String unifiedLocalPath = Util.preventTrailingFileSeparator(folderItem.getLocalPath(), folderItem.getContext().getFileService().getSeparator());
        this.m_itemsWithLocalPath.put((Comparable)((Object)unifiedLocalPath), folderItem);
    }

    void removeFolderItem(String absoluteLocalPath) {
        this.m_itemsWithLocalPath.remove((Comparable)((Object)absoluteLocalPath));
    }

    private VfsWorkspace getItemFromWorkspaceCache(String url) {
        return (VfsWorkspace)this.m_workspaces.get(Util.assureTrailingSlash(url));
    }

    private List getItemsFromWorkspaceCacheStartingWithUrl(String fromUrl) {
        Iterator urlIterator = this.m_workspaces.keySet().iterator();
        ArrayList workspaces = new ArrayList();
        while (urlIterator.hasNext()) {
            String url = (String)urlIterator.next();
            if (!url.startsWith(fromUrl)) continue;
            workspaces.add(this.m_workspaces.get(url));
            if (!url.equals(fromUrl)) continue;
            return workspaces;
        }
        return workspaces;
    }

    private void addItemToWorkspaceCache(VfsWorkspace workspace) throws VfsException {
        this.m_workspaces.put(workspace.getUrl(), workspace);
    }

    VfsFolderItem getFolderItemWithLocalPath(String absoluteLocalPath) {
        String unifiedLocalPath = Util.preventTrailingFileSeparator(absoluteLocalPath, this.m_context.getFileService().getSeparator());
        VfsFolderItem folderItem = this.getItemFromCacheWithLocalPath(unifiedLocalPath);
        if (folderItem == null) {
            IVfsRemoteLocator remoteLocator = this.m_context.getRemoteLocator(absoluteLocalPath);
            if (remoteLocator == null) {
                return null;
            }
            String url = Util.preventTrailingFileSeparator(this.m_context.getUrl(remoteLocator), this.m_context.getFileService().getSeparator());
            folderItem = this.getItemFromWorkspaceCache(url);
        }
        return folderItem;
    }

    VfsWorkspace getWorkspace(String url) {
        return this.getItemFromWorkspaceCache(url);
    }

    VfsFolderItem[] getFolderItemsWithBrowsePath(IVfsRemoteLocator remoteLocator) {
        VfsFolderItem folderItem;
        String absoluteLocalPath = this.m_context.getAbsoluteLocalPath(remoteLocator.getConnectionTemplateId(), remoteLocator.getAbsoluteRemotePath());
        if (absoluteLocalPath != null && (folderItem = this.getFolderItemWithLocalPath(absoluteLocalPath)) != null) {
            return new VfsFolderItem[]{folderItem};
        }
        return null;
    }

    void addFolderItem(VfsFolderItem folderItem, boolean doOverwrite) throws VfsException {
        VfsWorkspace workspace = (VfsWorkspace)folderItem.asWorkspace();
        if (workspace != null) {
            this.addItemToWorkspaceCache(workspace);
            return;
        }
        if (folderItem.isMounted()) {
            this.addItemToCacheWithLocalPath(folderItem);
            return;
        }
    }

    void touchFolderItemWithLocalPath(VfsFolderItem folderItem) throws VfsException {
        VfsWorkspace workspace = (VfsWorkspace)folderItem.asWorkspace();
        if (workspace != null) {
            return;
        }
        if (folderItem.isMounted()) {
            String unifiedLocalPath = Util.preventTrailingFileSeparator(folderItem.getLocalPath(), this.m_context.getFileService().getSeparator());
            this.m_itemsWithLocalPath.touch((Comparable)((Object)unifiedLocalPath), folderItem);
            return;
        }
    }

    TreeMap getFolderItemTreeWithLocalRoot(String absoluteLocalPathOfTreeRoot) {
        TreeMap folderItemTree = new TreeMap();
        LocalFileService localFileService = new LocalFileService();
        String fromPathWithoutTrailingSeparator = PathUtilities.preventTrailingSeparator(absoluteLocalPathOfTreeRoot, localFileService);
        VfsFolderItem folderItem = (VfsFolderItem)this.m_itemsWithLocalPath.get((Comparable)((Object)fromPathWithoutTrailingSeparator));
        if (folderItem != null && folderItem.asFile() != null) {
            folderItemTree.put(fromPathWithoutTrailingSeparator, folderItem);
            return folderItemTree;
        }
        String fromPathWithTrailingSeparator = PathUtilities.assureTrailingSeparator(absoluteLocalPathOfTreeRoot, localFileService);
        String toPath = fromPathWithTrailingSeparator + '\uffff';
        folderItemTree = this.m_itemsWithLocalPath.getEntrySubTree((Comparable)((Object)fromPathWithTrailingSeparator), (Comparable)((Object)toPath));
        if (folderItem != null) {
            folderItemTree.put(fromPathWithoutTrailingSeparator, folderItem);
        }
        String canonicalFromPath = null;
        try {
            canonicalFromPath = new File(fromPathWithoutTrailingSeparator).getCanonicalPath();
        }
        catch (IOException e) {
            return folderItemTree;
        }
        IVfsRemoteLocator fromRemoteLocator = this.m_context.getRemoteLocator(canonicalFromPath);
        if (fromRemoteLocator == null) {
            return folderItemTree;
        }
        String fromUrl = this.m_context.getUrl(fromRemoteLocator);
        List workspaces = this.getItemsFromWorkspaceCacheStartingWithUrl(fromUrl);
        Iterator workspacesIterator = workspaces.iterator();
        while (workspacesIterator.hasNext()) {
            VfsWorkspace workspace = (VfsWorkspace)workspacesIterator.next();
            folderItemTree.put(workspace.getLocalPath(), workspace);
        }
        return folderItemTree;
    }

    void removeFolderItemsWithLocalPath(Map folderItemMap) {
        HashSet<String> folderItemKeySet = new HashSet<String>();
        Iterator folderItemIterator = folderItemMap.keySet().iterator();
        while (folderItemIterator.hasNext()) {
            String absoluteLocalPath = (String)folderItemIterator.next();
            if (((VfsFolderItem)folderItemMap.get(absoluteLocalPath)).asWorkspace() != null) continue;
            folderItemKeySet.add(absoluteLocalPath);
        }
        this.m_itemsWithLocalPath.removeEntriesWithKey(folderItemKeySet);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CacheWithWeakShadow {
        private HashMap m_cache = new HashMap();
        private TreeMap m_invertedCache = new TreeMap();
        private HashMap m_shadowCache = new HashMap();
        private long m_shadowCacheTimestamp = 0L;
        private long m_cacheSize = 10000L;
        private long m_cacheSwappingNumber = 1000L;
        private long m_shadowCacheExpiredTime = 1800000L;
        private boolean m_cacheCheckingOn = false;

        void setCacheChecking(boolean cacheCheckingOn) {
            this.m_cacheCheckingOn = cacheCheckingOn;
        }

        boolean isCacheCheckingOn() {
            return this.m_cacheCheckingOn;
        }

        CacheWithWeakShadow(long cacheSize, long cacheSwappingNumber, long shadowCacheExpiredTime) {
            this.m_cacheSize = cacheSize;
            this.m_cacheSwappingNumber = cacheSwappingNumber;
            this.m_shadowCacheExpiredTime = shadowCacheExpiredTime;
            this.m_shadowCacheTimestamp = System.currentTimeMillis();
        }

        CacheEntryWithTimestamp getEntryFromCache(Comparable key) {
            return (CacheEntryWithTimestamp)this.m_cache.get(key);
        }

        void putEntryIntoCache(Comparable key, CacheEntryWithTimestamp entry) {
            this.m_cache.put(key, entry);
        }

        boolean removeEntryFromCache(Comparable key) {
            return this.m_cache.remove(key) != null;
        }

        void putEntryIntoInvertedCache(CacheEntryWithTimestamp entry) {
            this.m_invertedCache.put(entry, entry);
        }

        boolean removeEntryFromInvertedCache(CacheEntryWithTimestamp entry) {
            return this.m_invertedCache.remove(entry) != null;
        }

        WeakCacheEntry getEntryFromShadowCache(Comparable key) {
            return (WeakCacheEntry)this.m_shadowCache.get(key);
        }

        void putEntryIntoShadowCache(Comparable key, WeakCacheEntry entry) {
            this.m_shadowCache.put(key, entry);
        }

        boolean removeEntryFromShadowCache(Comparable key) {
            return this.m_shadowCache.remove(key) != null;
        }

        private boolean isSwappingTurnedOn() {
            return this.m_cacheSize > 0L;
        }

        private boolean isCacheOverflow() {
            if (this.isSwappingTurnedOn()) {
                return (long)this.m_cache.size() > this.m_cacheSize;
            }
            return false;
        }

        private boolean isShadowCacheExpired() {
            if (this.isSwappingTurnedOn()) {
                return this.m_shadowCacheTimestamp + this.m_shadowCacheExpiredTime < System.currentTimeMillis();
            }
            return false;
        }

        private void reorganizeCache() {
            if (this.isCacheOverflow()) {
                try {
                    this.checkConsistencyOfCaches();
                }
                catch (IllegalStateException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
                Iterator iterator = this.m_invertedCache.values().iterator();
                int i = 0;
                while ((long)i < this.m_cacheSwappingNumber && iterator.hasNext()) {
                    CacheEntryWithTimestamp cacheEntry = (CacheEntryWithTimestamp)iterator.next();
                    this.putEntryIntoShadowCache(cacheEntry.getKey(), new WeakCacheEntry(cacheEntry.getKey(), cacheEntry.getValue()));
                    if (!this.removeEntryFromCache(cacheEntry.getKey())) {
                        IllegalStateException e = new IllegalStateException("Reorganization of cache failed: remove item failed: " + cacheEntry.getKey().toString());
                        LogUtil.logException((Location)LOCATION, (Throwable)e);
                    }
                    iterator.remove();
                    ++i;
                }
                try {
                    this.checkConsistencyOfCaches();
                }
                catch (IllegalStateException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            }
        }

        private void reorganizeShadowCache() {
            if (this.isShadowCacheExpired()) {
                Iterator iterator = this.m_shadowCache.values().iterator();
                while (iterator.hasNext()) {
                    WeakCacheEntry cacheEntry = (WeakCacheEntry)iterator.next();
                    if (cacheEntry != null && !cacheEntry.isReferenceReleased()) continue;
                    iterator.remove();
                }
                this.m_shadowCacheTimestamp = System.currentTimeMillis();
            }
        }

        private void checkConsistencyOfCaches() throws IllegalStateException {
            Object cacheEntry;
            Map.Entry mapEntry;
            if (!this.isCacheCheckingOn()) {
                return;
            }
            if (this.isSwappingTurnedOn()) {
                if (this.m_cache.size() != this.m_invertedCache.size()) {
                    throw new IllegalStateException("Internal error: size of cache is: " + this.m_cache.size() + " != size of inverted cache: " + this.m_invertedCache.size());
                }
                Iterator cacheIterator = this.m_cache.entrySet().iterator();
                while (cacheIterator.hasNext()) {
                    mapEntry = cacheIterator.next();
                    cacheEntry = (CacheEntryWithTimestamp)mapEntry.getValue();
                    if (!mapEntry.getKey().equals(((CacheEntryWithTimestamp)cacheEntry).getKey())) {
                        throw new IllegalStateException("Internal error: inconsistent key found in cache, key in map: " + mapEntry.getKey().toString() + ", key in map entry: " + ((CacheEntryWithTimestamp)cacheEntry).getKey());
                    }
                    if (this.m_invertedCache.get(mapEntry.getValue()) != null) continue;
                    throw new IllegalStateException("Internal error: cache contains mapEntry which is not contained in inverted cache:" + mapEntry.getKey().toString());
                }
            } else if (this.m_invertedCache.size() != 0) {
                throw new IllegalStateException("Internal error: Cache swapping is turned off, but inverted cache is not empty");
            }
            if (this.isSwappingTurnedOn()) {
                Iterator shadowCacheIterator = this.m_shadowCache.entrySet().iterator();
                while (shadowCacheIterator.hasNext()) {
                    mapEntry = shadowCacheIterator.next();
                    cacheEntry = (WeakCacheEntry)mapEntry.getValue();
                    if (!mapEntry.getKey().equals(((WeakCacheEntry)cacheEntry).getKey())) {
                        throw new IllegalStateException("Internal error: inconsistent key found in shadow cache, key in map: " + mapEntry.getKey().toString() + ", key in map entry: " + ((WeakCacheEntry)cacheEntry).getKey());
                    }
                    if (this.m_cache.get(mapEntry.getKey()) == null) continue;
                    throw new IllegalStateException("Internal error: shadow cache contains entry which is still in cache: " + mapEntry.getKey().toString());
                }
            } else if (this.m_shadowCache.size() != 0) {
                throw new IllegalStateException("Internal error: Cache swapping is turned off, but shadow cache is not empty");
            }
        }

        Object get(Comparable key) {
            Object value = null;
            CacheEntryWithTimestamp entry = this.getEntryFromCache(key);
            if (!this.isSwappingTurnedOn()) {
                if (entry != null) {
                    value = entry.getValueAndTouchTimestamp();
                }
            } else if (entry != null) {
                this.removeEntryFromInvertedCache(entry);
                value = entry.getValueAndTouchTimestamp();
                this.putEntryIntoInvertedCache(entry);
            } else {
                WeakCacheEntry weakEntry = this.getEntryFromShadowCache(key);
                if (weakEntry != null && (value = weakEntry.getValue()) != null) {
                    entry = new CacheEntryWithTimestamp(key, value);
                    this.putEntryIntoCache(key, entry);
                    this.putEntryIntoInvertedCache(entry);
                    this.removeEntryFromShadowCache(key);
                }
            }
            if (this.isSwappingTurnedOn()) {
                this.reorganizeShadowCache();
            }
            try {
                this.checkConsistencyOfCaches();
            }
            catch (IllegalStateException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
            return value;
        }

        void put(Comparable key, Object value) {
            CacheEntryWithTimestamp entry = new CacheEntryWithTimestamp(key, value);
            if (!this.isSwappingTurnedOn()) {
                this.putEntryIntoCache(key, entry);
                try {
                    this.checkConsistencyOfCaches();
                }
                catch (IllegalStateException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            } else {
                CacheEntryWithTimestamp cacheEntry = this.getEntryFromCache(key);
                if (cacheEntry != null) {
                    this.removeEntryFromCache(key);
                    this.removeEntryFromInvertedCache(cacheEntry);
                } else {
                    WeakCacheEntry shadowEntry = this.getEntryFromShadowCache(key);
                    if (shadowEntry != null) {
                        this.removeEntryFromShadowCache(key);
                    }
                }
                this.putEntryIntoCache(key, entry);
                this.putEntryIntoInvertedCache(entry);
                this.reorganizeCache();
                this.reorganizeShadowCache();
            }
        }

        void remove(Comparable key) {
            if (!this.isSwappingTurnedOn()) {
                if (!this.removeEntryFromCache(key)) {
                    IllegalStateException e = new IllegalStateException("Internal error: Remove entry from cache failed: " + key.toString());
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            } else {
                CacheEntryWithTimestamp entry = this.getEntryFromCache(key);
                if (entry != null) {
                    IllegalStateException e;
                    if (!this.removeEntryFromCache(key)) {
                        e = new IllegalStateException("Internal error: Remove entry from cache failed: " + key.toString());
                        LogUtil.logException((Location)LOCATION, (Throwable)e);
                    }
                    if (!this.removeEntryFromInvertedCache(entry)) {
                        e = new IllegalStateException("Internal error: Remove entry from cache failed: " + key.toString());
                        LogUtil.logException((Location)LOCATION, (Throwable)e);
                    }
                } else if (!this.removeEntryFromShadowCache(key)) {
                    IllegalStateException e = new IllegalStateException("Internal error: Remove entry from cache failed: " + key.toString());
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            }
            try {
                this.checkConsistencyOfCaches();
            }
            catch (IllegalStateException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }

        void clear() {
            this.m_cache.clear();
            this.m_invertedCache.clear();
            this.m_shadowCache.clear();
            this.m_shadowCacheTimestamp = 0L;
            this.m_cacheSize = 0L;
            this.m_cacheSwappingNumber = 1000L;
            this.m_shadowCacheExpiredTime = 1800000L;
        }

        void touch(Comparable key, Object value) {
            if (this.isSwappingTurnedOn()) {
                Object cachedValue = this.get(key);
                if (cachedValue == null) {
                    new VfsException("Internal error: Touch object which was not in cache -> inserted object into cache");
                    this.put(key, value);
                } else if (cachedValue != value) {
                    new VfsException("Internal error: Touch object which was in cache but with different value -> exchanged value in cache");
                    this.remove(key);
                    this.put(key, value);
                }
            }
        }

        TreeMap getEntrySubTree(Comparable fromKey, Comparable toKey) {
            TreeMap<Comparable, Object> entrySubTree = new TreeMap<Comparable, Object>();
            Iterator valuesIterator = this.m_cache.values().iterator();
            while (valuesIterator.hasNext()) {
                CacheEntryWithTimestamp cacheEntryWithTimestamp = (CacheEntryWithTimestamp)valuesIterator.next();
                if (cacheEntryWithTimestamp.getKey().compareTo(fromKey) < 0 || cacheEntryWithTimestamp.getKey().compareTo(toKey) >= 0) continue;
                entrySubTree.put(cacheEntryWithTimestamp.getKey(), cacheEntryWithTimestamp.getValue());
            }
            valuesIterator = this.m_shadowCache.values().iterator();
            while (valuesIterator.hasNext()) {
                Comparable key;
                WeakCacheEntry weakEntry = (WeakCacheEntry)valuesIterator.next();
                Object value = weakEntry == null ? null : weakEntry.getValue();
                Comparable comparable = key = weakEntry == null ? null : weakEntry.getKey();
                if (key == null || key.compareTo(fromKey) < 0 || key.compareTo(toKey) >= 0) continue;
                entrySubTree.put(key, value);
            }
            return entrySubTree;
        }

        void removeEntriesWithKey(Set keySet) {
            Iterator keyIterator = keySet.iterator();
            while (keyIterator.hasNext()) {
                Comparable key = (Comparable)keyIterator.next();
                this.remove(key);
            }
        }

        private class WeakCacheEntry {
            private Comparable m_key = null;
            private WeakReference m_weakReference = null;

            WeakCacheEntry(Comparable key, Object value) {
                this.m_key = key;
                this.m_weakReference = new WeakReference<Object>(value);
            }

            Object getValue() {
                return this.m_weakReference.get();
            }

            Comparable getKey() {
                return this.m_key;
            }

            boolean isReferenceReleased() {
                return this.m_weakReference.get() == null;
            }
        }

        private class CacheEntryWithTimestamp
        implements Comparable {
            private Comparable m_key;
            private Object m_value;
            private Long m_timestamp;

            CacheEntryWithTimestamp(Comparable key, Object object) {
                this.m_key = key;
                this.m_value = object;
                this.m_timestamp = new Long(System.currentTimeMillis());
            }

            public int compareTo(Object o) {
                CacheEntryWithTimestamp entry = (CacheEntryWithTimestamp)o;
                if (this == entry) {
                    return 0;
                }
                if (this.getTimestamp() < entry.getTimestamp()) {
                    return -1;
                }
                if (this.getTimestamp() > entry.getTimestamp()) {
                    return 1;
                }
                return this.getKey().compareTo(entry.getKey());
            }

            Comparable getKey() {
                return this.m_key;
            }

            Object getValue() {
                return this.m_value;
            }

            Long getTimestamp() {
                return this.m_timestamp;
            }

            void touchEntry() {
                this.m_timestamp = new Long(System.currentTimeMillis());
            }

            Object getValueAndTouchTimestamp() {
                this.touchEntry();
                return this.getValue();
            }
        }
    }
}

