/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.AbstractSynchronizeResourceCallback;
import com.tssap.dtr.client.lib.vfs.impl.SyncRemoveFeatureMget;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDBMget;
import java.util.Date;
import java.util.Map;

class DeltaSynchronizeResourceCallback
extends AbstractSynchronizeResourceCallback {
    public DeltaSynchronizeResourceCallback(SyncRemoveFeatureMget syncRemoveFeatureMget, IVfsContext context, IFileService fileService, VersionedFileSystemManager manager, SyncDB syncDB, Map checkedOutItemsByLocalPath, boolean previewSync, SyncDBMget syncDBMget, Map syncedVersionDateByLocalPath, int connectionTemplateId) {
        super(syncRemoveFeatureMget, context, fileService, manager, syncDB, checkedOutItemsByLocalPath, previewSync, syncDBMget, syncedVersionDateByLocalPath, connectionTemplateId);
    }

    boolean checkPreconditions(boolean hasLocalRemoteNameclash, VfsActivityRecordedFolderItem folderItem, IVersionControlledResource dvVersionControlledResource, IVirtualFile virtualFile, long syncedVersionTime, boolean checkedOut, long lastModified, IResource dvFileResource, boolean exists, boolean writable, long currentServerTime) {
        String absoluteLocalPath = virtualFile.getAbsolutePath();
        long timeDiff = lastModified - syncedVersionTime;
        if (timeDiff > 0L && timeDiff < 1000L && syncedVersionTime % 1000L == 0L) {
            syncedVersionTime += lastModified % 1000L;
        }
        if (hasLocalRemoteNameclash) {
            if (folderItem != null) {
                folderItem.setDvLocalRemoteNameClashVcr(dvVersionControlledResource);
            }
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, virtualFile, "File has local-remote name clash");
            this.lockInSyncDbMget(this._syncDBMget, virtualFile, syncedVersionTime, this._previewSync);
            return false;
        }
        if (checkedOut) {
            this.lockInSyncDbMget(this._syncDBMget, virtualFile, syncedVersionTime, this._previewSync);
            if (lastModified > syncedVersionTime) {
                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED_BUT_WARN, virtualFile, "File is " + folderItem.getActivityState());
            } else {
                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, virtualFile, "File is in sync");
            }
            this.updateLocationState(folderItem, dvFileResource, syncedVersionTime, lastModified);
            return false;
        }
        if (exists && writable) {
            this.lockInSyncDbMget(this._syncDBMget, virtualFile, -1L, this._previewSync);
            if (lastModified > syncedVersionTime) {
                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, virtualFile, "File is writable");
                this._exception = new VfsException("Sync failed (file is writable): " + virtualFile.getAbsolutePath());
            } else {
                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED_BUT_WARN, virtualFile, "File is writable");
            }
            this.updateLocationState(folderItem, dvFileResource, syncedVersionTime, lastModified);
            return false;
        }
        if (exists) {
            if (lastModified < syncedVersionTime) {
                String message = "Synced file is newer (" + new Date(syncedVersionTime) + ") than active repository version (" + new Date(lastModified) + ")";
                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, virtualFile, message);
                this._exception = new VfsException(message);
                this.updateLocationState(folderItem, dvFileResource, syncedVersionTime, lastModified);
                this.lockInSyncDbMget(this._syncDBMget, virtualFile, syncedVersionTime, this._previewSync);
                return false;
            }
            if (lastModified == syncedVersionTime) {
                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, virtualFile, "File is in sync");
                this.updateLocationState(folderItem, dvFileResource, syncedVersionTime, lastModified);
                if (!this._previewSync) {
                    this._syncDBMget.setLastRemoteSyncTime(absoluteLocalPath, currentServerTime);
                }
                return false;
            }
        }
        return true;
    }
}

