/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.impl.FolderUtil;
import com.tssap.dtr.client.lib.vfs.impl.VfsAmbiguousFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFile;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspaceFolder;
import java.util.ArrayList;

class AllowedActionsFeature {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$AllowedActionsFeature == null ? (class$com$tssap$dtr$client$lib$vfs$impl$AllowedActionsFeature = AllowedActionsFeature.class$("com.tssap.dtr.client.lib.vfs.impl.AllowedActionsFeature")) : class$com$tssap$dtr$client$lib$vfs$impl$AllowedActionsFeature));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$AllowedActionsFeature;

    AllowedActionsFeature() {
    }

    VfsActionOnFolderItem[] getAllowedActionsForCurrentState(VfsWorkspaceFolder workspaceFolder) {
        boolean mountedOrMountPointBelow = false;
        try {
            mountedOrMountPointBelow = workspaceFolder.isMounted() || FolderUtil.getMountPointFolderItemsBelow(workspaceFolder).size() > 0;
        }
        catch (VfsException x) {
            String METHOD = "getAllowedActionsForCurrentState";
            LOCATION.warningT("getAllowedActionsForCurrentState", "Could not get folder items for mountpoints below workspace {0}", new Object[]{workspaceFolder.getAbsoluteRemotePath()});
        }
        return this.getActionsForState(workspaceFolder.getCategory(), workspaceFolder, mountedOrMountPointBelow);
    }

    VfsActionOnFolderItem[] getAllowedActionsForCurrentState(VfsWorkspace workspace) {
        boolean mountedOrMountPointBelow = false;
        try {
            mountedOrMountPointBelow = workspace.isMounted() || FolderUtil.getMountPointFolderItemsBelow(workspace).size() > 0;
        }
        catch (VfsException x) {
            String METHOD = "getAllowedActionsForCurrentState";
            LOCATION.warningT("getAllowedActionsForCurrentState", "Could not get folder items for mountpoints below workspace {0}", new Object[]{workspace.getAbsoluteRemotePath()});
        }
        return this.getActionsForState(workspace.getCategory(), workspace, mountedOrMountPointBelow);
    }

    VfsActionOnFolderItem[] getAllowedActionsForCurrentState(VfsFolder folder) {
        boolean mountedOrMountPointBelow = false;
        try {
            mountedOrMountPointBelow = folder.isMounted() || FolderUtil.getMountPointFolderItemsBelow(folder).size() > 0;
        }
        catch (VfsException x) {
            String METHOD = "getAllowedActionsForCurrentState";
            LOCATION.warningT("getAllowedActionsForCurrentState", "Could not get folder items for mountpoints below workspace {0}", new Object[]{folder.getAbsoluteRemotePath()});
        }
        return this.getActionsForState(folder.getCategory(), folder, mountedOrMountPointBelow);
    }

    VfsActionOnFolderItem[] getAllowedActionsForCurrentState(VfsFile file) {
        VfsFolderItemLocationState locationState = file.getLocationState();
        VfsFolderItemActivityState activityState = file.getActivityState();
        boolean isModifiable = file.isModifiable();
        boolean isCheckedOutByOthers = file.isCheckedOutByOthers();
        ArrayList<VfsActionOnFolderItem> actions = new ArrayList<VfsActionOnFolderItem>();
        if (locationState == VfsFolderItemLocationState.DELETED) {
            return new VfsActionOnFolderItem[0];
        }
        if (activityState == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            if (isModifiable) {
                actions.add(VfsActionOnFolderItem.UNCHECKOUT);
            }
            return actions.toArray(new VfsActionOnFolderItem[0]);
        }
        if (locationState == VfsFolderItemLocationState.LOCAL_ONLY && activityState == VfsFolderItemActivityState.NOT_CHECKED_OUT && isModifiable && !file.hasLocalRemoteNameClash()) {
            actions.add(VfsActionOnFolderItem.CREATE_AND_CHECKOUT);
        }
        if (locationState == VfsFolderItemLocationState.SERVER_ONLY && activityState == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            actions.add(VfsActionOnFolderItem.SYNC_TO_LATEST);
            actions.add(VfsActionOnFolderItem.SYNC_TO_PREVIOUS);
        }
        if ((locationState == VfsFolderItemLocationState.SYNCED_TO_LATEST || locationState == VfsFolderItemLocationState.SERVER_ONLY) && activityState == VfsFolderItemActivityState.NOT_CHECKED_OUT && isModifiable && !isCheckedOutByOthers) {
            actions.add(VfsActionOnFolderItem.CHECKOUT_AND_DELETE);
        }
        if (locationState == VfsFolderItemLocationState.SYNCED_TO_LATEST && activityState == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            if (isModifiable) {
                if (isCheckedOutByOthers) {
                    try {
                        if (!file.isExclusiveCheckedOutByOthers()) {
                            actions.add(VfsActionOnFolderItem.CHECKOUT_FOR_EDIT);
                        }
                    }
                    catch (VfsException e) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    }
                } else {
                    actions.add(VfsActionOnFolderItem.CHECKOUT_FOR_EDIT);
                    actions.add(VfsActionOnFolderItem.CHECKOUT_FOR_EDIT_EXCLUSIVE);
                }
            }
            actions.add(VfsActionOnFolderItem.SYNC_TO_PREVIOUS);
            actions.add(VfsActionOnFolderItem.REMOVE_FROM_CLIENT);
        }
        if (locationState == VfsFolderItemLocationState.SYNCED_TO_FORMER && activityState == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            actions.add(VfsActionOnFolderItem.SYNC_TO_LATEST);
            actions.add(VfsActionOnFolderItem.SYNC_TO_PREVIOUS);
            actions.add(VfsActionOnFolderItem.REMOVE_FROM_CLIENT);
        }
        if (activityState != VfsFolderItemActivityState.NOT_CHECKED_OUT && activityState != VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE && isModifiable) {
            actions.add(VfsActionOnFolderItem.UPLOAD);
            actions.add(VfsActionOnFolderItem.FORCE_UPLOAD);
            actions.add(VfsActionOnFolderItem.DOWNLOAD);
            actions.add(VfsActionOnFolderItem.FORCE_DOWNLOAD);
        }
        if (locationState != VfsFolderItemLocationState.LOCAL_ONLY || activityState != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            actions.add(VfsActionOnFolderItem.HANDLE_PROPERTIES);
        }
        if (activityState != VfsFolderItemActivityState.NOT_CHECKED_OUT && isModifiable) {
            actions.add(VfsActionOnFolderItem.UNCHECKOUT);
            actions.add(VfsActionOnFolderItem.MOVE_INTO_ACTIVITY);
        }
        if (activityState == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT && isModifiable) {
            try {
                if (!file.isExclusiveCheckedOut()) {
                    if (!isCheckedOutByOthers) {
                        actions.add(VfsActionOnFolderItem.SET_EXCLUSIVE_CHECKOUT_LOCK);
                    }
                } else {
                    actions.add(VfsActionOnFolderItem.RESET_EXCLUSIVE_CHECKOUT_LOCK);
                }
            }
            catch (VfsException e) {
                actions.add(VfsActionOnFolderItem.SET_EXCLUSIVE_CHECKOUT_LOCK);
                actions.add(VfsActionOnFolderItem.RESET_EXCLUSIVE_CHECKOUT_LOCK);
            }
        }
        VfsActionOnFolderItem[] possibleActions = new VfsActionOnFolderItem[actions.size()];
        actions.toArray(possibleActions);
        return possibleActions;
    }

    VfsActionOnFolderItem[] getAllowedActionsForCurrentState(VfsAmbiguousFolder ambiguousFolder) {
        boolean mountedOrMountPointsBelow = false;
        int i = 0;
        while (i < ambiguousFolder.m_unambiguousFolders.length) {
            IVfsGenericFolder unambiguousFolder = ambiguousFolder.m_unambiguousFolders[i];
            try {
                if (((VfsFolderItem)((Object)unambiguousFolder)).isMounted() || FolderUtil.getMountPointFolderItemsBelow(unambiguousFolder).size() > 0) {
                    mountedOrMountPointsBelow = true;
                    break;
                }
            }
            catch (VfsException x) {
                String METHOD = "getAllowedActionsForCurrentState";
                LOCATION.warningT("getAllowedActionsForCurrentState", "Could not get folder items for mountpoints below workspace {0}", new Object[]{unambiguousFolder.getAbsoluteRemotePath()});
            }
            ++i;
        }
        return this.getActionsForState(ambiguousFolder.getCategory(), ambiguousFolder, mountedOrMountPointsBelow);
    }

    private VfsActionOnFolderItem[] getActionsForState(VfsFolderItemCategory category, IVfsGenericFolder folder, boolean mountedOrMountPointsBelow) {
        VfsFolderItemLocationState locationState = folder.getLocationState();
        VfsFolderItemActivityState activityState = folder.asActivityRecordedFolderItem() != null ? folder.asActivityRecordedFolderItem().getActivityState() : VfsFolderItemActivityState.NOT_CHECKED_OUT;
        boolean isModifiable = folder.isModifiable();
        ArrayList<VfsActionOnFolderItem> actions = new ArrayList<VfsActionOnFolderItem>();
        if (locationState == VfsFolderItemLocationState.DELETED) {
            return new VfsActionOnFolderItem[0];
        }
        if (activityState == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            if (isModifiable) {
                actions.add(VfsActionOnFolderItem.UNCHECKOUT);
            }
            return actions.toArray(new VfsActionOnFolderItem[0]);
        }
        if (mountedOrMountPointsBelow && locationState != VfsFolderItemLocationState.LOCAL_ONLY) {
            actions.add(VfsActionOnFolderItem.SYNC_TO_LATEST);
            actions.add(VfsActionOnFolderItem.REMOVE_FROM_CLIENT);
        }
        if (category == VfsFolderItemCategory.FOLDER) {
            if (locationState == VfsFolderItemLocationState.LOCAL_ONLY && activityState == VfsFolderItemActivityState.NOT_CHECKED_OUT && isModifiable) {
                actions.add(VfsActionOnFolderItem.ADD_0);
            }
            if (mountedOrMountPointsBelow && locationState != VfsFolderItemLocationState.LOCAL_ONLY) {
                actions.add(VfsActionOnFolderItem.SYNC_TO_PREVIOUS);
            }
            if ((locationState == VfsFolderItemLocationState.SYNCED_TO_LATEST || locationState == VfsFolderItemLocationState.MOUNTED || locationState == VfsFolderItemLocationState.LOCAL_ONLY) && isModifiable) {
                actions.add(VfsActionOnFolderItem.ADD_1);
                actions.add(VfsActionOnFolderItem.ADD_INF);
            }
            if ((locationState == VfsFolderItemLocationState.MOUNTED || locationState == VfsFolderItemLocationState.SYNCED_TO_LATEST) && isModifiable) {
                actions.add(VfsActionOnFolderItem.CHECKOUT_FOR_EDIT_1);
                actions.add(VfsActionOnFolderItem.CHECKOUT_FOR_EDIT_INF);
                if (!folder.asActivityRecordedFolderItem().isCheckedOutByOthers()) {
                    actions.add(VfsActionOnFolderItem.CHECKOUT_FOR_EDIT_EXCLUSIVE);
                }
                actions.add(VfsActionOnFolderItem.CHECKOUT_FOR_EDIT_EXCLUSIVE_1);
                actions.add(VfsActionOnFolderItem.CHECKOUT_FOR_EDIT_EXCLUSIVE_INF);
            }
            if ((locationState == VfsFolderItemLocationState.MOUNTED || locationState == VfsFolderItemLocationState.SYNCED_TO_LATEST || locationState == VfsFolderItemLocationState.SERVER_ONLY) && activityState == VfsFolderItemActivityState.NOT_CHECKED_OUT && isModifiable) {
                try {
                    if (!((VfsFolder)folder).hasCheckedOutFolderItems()) {
                        if (!((VfsFolder)folder).hasFolderItemsOnServer()) {
                            actions.add(VfsActionOnFolderItem.CHECKOUT_AND_DELETE);
                        }
                        actions.add(VfsActionOnFolderItem.DEPRECATED_IMMEDIATE_CHECKOUT_AND_DELETE);
                    }
                }
                catch (VfsException e) {
                    VfsException e1 = new VfsException("Checking if action 'delete' is allowed failed: " + folder.getLocalPath(), e);
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e1);
                }
            }
            if (activityState == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT && isModifiable) {
                try {
                    if (!folder.asFolder().isExclusiveCheckedOut()) {
                        if (!folder.asFolder().isCheckedOutByOthers()) {
                            actions.add(VfsActionOnFolderItem.SET_EXCLUSIVE_CHECKOUT_LOCK);
                        }
                    } else {
                        actions.add(VfsActionOnFolderItem.RESET_EXCLUSIVE_CHECKOUT_LOCK);
                    }
                }
                catch (VfsException e) {
                    actions.add(VfsActionOnFolderItem.SET_EXCLUSIVE_CHECKOUT_LOCK);
                    actions.add(VfsActionOnFolderItem.RESET_EXCLUSIVE_CHECKOUT_LOCK);
                }
            }
        }
        if (locationState != VfsFolderItemLocationState.SERVER_ONLY && locationState != VfsFolderItemLocationState.LOCAL_ONLY && locationState != VfsFolderItemLocationState.DELETED && activityState != VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE && isModifiable) {
            actions.add(VfsActionOnFolderItem.SET_EXCLUSIVE_CHECKOUT_LOCK_1);
            actions.add(VfsActionOnFolderItem.SET_EXCLUSIVE_CHECKOUT_LOCK_INF);
            actions.add(VfsActionOnFolderItem.RESET_EXCLUSIVE_CHECKOUT_LOCK_1);
            actions.add(VfsActionOnFolderItem.RESET_EXCLUSIVE_CHECKOUT_LOCK_INF);
        }
        if (category == VfsFolderItemCategory.WORKSPACE) {
            if (isModifiable) {
                actions.add(VfsActionOnFolderItem.CREATE_ACTIVITY);
            }
            if (mountedOrMountPointsBelow) {
                actions.add(VfsActionOnFolderItem.SYNC_TO_PREVIOUS);
            }
        }
        if ((category == VfsFolderItemCategory.WORKSPACE_FOLDER || category == VfsFolderItemCategory.ROOT) && mountedOrMountPointsBelow) {
            actions.add(VfsActionOnFolderItem.SYNC_TO_PREVIOUS);
        }
        if (locationState != VfsFolderItemLocationState.LOCAL_ONLY || activityState != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            actions.add(VfsActionOnFolderItem.HANDLE_PROPERTIES);
        }
        if (activityState != VfsFolderItemActivityState.NOT_CHECKED_OUT && isModifiable) {
            actions.add(VfsActionOnFolderItem.UPLOAD);
            actions.add(VfsActionOnFolderItem.FORCE_UPLOAD);
            actions.add(VfsActionOnFolderItem.DOWNLOAD);
            actions.add(VfsActionOnFolderItem.FORCE_DOWNLOAD);
        }
        if (activityState != VfsFolderItemActivityState.NOT_CHECKED_OUT && isModifiable) {
            actions.add(VfsActionOnFolderItem.UNCHECKOUT);
            actions.add(VfsActionOnFolderItem.MOVE_INTO_ACTIVITY);
        }
        return actions.toArray(new VfsActionOnFolderItem[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

