/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.xcm.ISynchronizeResourceCallback;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener2;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.SyncRemoveFeatureMget;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsFile;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import com.tssap.dtr.client.lib.vfs.impl.WrongCaseOfFolderPathUtil;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDBMget;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class AbstractSynchronizeResourceCallback
implements ISynchronizeResourceCallback {
    long _currentServerTime = Long.MIN_VALUE;
    VfsException _exception;
    final IVfsContext _context;
    final IFileService _fileService;
    final VersionedFileSystemManager _manager;
    final SyncDB _syncDB;
    final Map _checkedOutItemsByLocalPath;
    final boolean _previewSync;
    final SyncDBMget _syncDBMget;
    final Map _syncedVersionDateByLocalPath;
    SyncRemoveFeatureMget _syncRemoveFeatureMget;
    HashSet _createdLocalFolders = new HashSet();
    int _connectionTemplateId;
    boolean _syncRequestCompleted = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$AbstractSynchronizeResourceCallback == null ? (class$com$tssap$dtr$client$lib$vfs$impl$AbstractSynchronizeResourceCallback = AbstractSynchronizeResourceCallback.class$("com.tssap.dtr.client.lib.vfs.impl.AbstractSynchronizeResourceCallback")) : class$com$tssap$dtr$client$lib$vfs$impl$AbstractSynchronizeResourceCallback));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$AbstractSynchronizeResourceCallback;

    public AbstractSynchronizeResourceCallback(SyncRemoveFeatureMget syncRemoveFeatureMget, IVfsContext context, IFileService fileService, VersionedFileSystemManager manager, SyncDB syncDB, Map checkedOutItemsByLocalPath, boolean previewSync, SyncDBMget syncDBMget, Map syncedVersionDateByLocalPath, int connectionTemplateId) {
        this._syncRemoveFeatureMget = syncRemoveFeatureMget;
        this._context = context;
        this._fileService = fileService;
        this._manager = manager;
        this._syncDB = syncDB;
        this._checkedOutItemsByLocalPath = checkedOutItemsByLocalPath;
        this._previewSync = previewSync;
        this._syncDBMget = syncDBMget;
        this._syncedVersionDateByLocalPath = syncedVersionDateByLocalPath;
        this._connectionTemplateId = connectionTemplateId;
    }

    public VfsException getException() {
        return this._exception;
    }

    public Set getCreatedLocalFolders() {
        return Collections.unmodifiableSet(this._createdLocalFolders);
    }

    IVirtualFile getFile(IResource resource, boolean resourceExistsEitherDeletedOrNot) {
        String absoluteLocalPath = null;
        try {
            absoluteLocalPath = resourceExistsEitherDeletedOrNot ? this._context.getAbsoluteLocalPath(resource.getConnectionTemplID(), resource.getCanonicalPath()) : this._context.getAbsoluteLocalPath(resource.getConnectionTemplID(), resource.getDecodedPath());
            if (absoluteLocalPath == null) {
                Logbook.getErrorChapter().println("Not mounted: " + resource.getCanonicalPath());
                return null;
            }
        }
        catch (VcmFailure vcmFailure) {
            Logbook.getErrorChapter().println("Error: " + vcmFailure.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
            return null;
        }
        return this._fileService.constructFile(absoluteLocalPath);
    }

    IVirtualFile getFile(String canonicalPath) {
        String absoluteLocalPath = null;
        absoluteLocalPath = this._context.getAbsoluteLocalPath(this._connectionTemplateId, canonicalPath);
        if (absoluteLocalPath == null) {
            Logbook.getErrorChapter().println("Not mounted: " + canonicalPath);
            return null;
        }
        return this._fileService.constructFile(absoluteLocalPath);
    }

    void updateLocationState(VfsActivityRecordedFolderItem folderItem, IResource dvFileResource, long syncedVersionTime, long lastModified) {
        if (folderItem != null) {
            if (folderItem.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
                return;
            }
            folderItem.setVcrResource(dvFileResource);
            if (folderItem.getLocalFile().exists()) {
                if (lastModified > syncedVersionTime) {
                    folderItem.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
                } else {
                    folderItem.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
                }
            } else {
                folderItem.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
            }
        }
    }

    void lockInSyncDbMget(SyncDBMget syncDBMget, IVirtualFile virtualFile, long syncedVersionTime, boolean preview) {
        if (preview) {
            return;
        }
        long negativeSyncTime = syncedVersionTime > 0L ? -syncedVersionTime : syncedVersionTime;
        syncDBMget.setLastRemoteSyncTime(virtualFile.getAbsolutePath(), negativeSyncTime);
    }

    public void currentServerTime(Date time) {
        this._currentServerTime = time.getTime();
    }

    public long getCurrentServerTime() throws VfsException {
        if (this._currentServerTime == Long.MIN_VALUE) {
            throw new VfsException("Current server time not available.");
        }
        return this._currentServerTime;
    }

    public boolean deleted(IResource dvResource) {
        if (Thread.currentThread().isInterrupted()) {
            return true;
        }
        IVirtualFile virtualFile = this.getFile(dvResource, true);
        if (virtualFile == null) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, dvResource, "Not mounted", 2);
            this._exception = new VfsException("Internal error: not mounted resource below mounted folder: " + dvResource.getPersistentURL());
            return false;
        }
        this._syncRemoveFeatureMget.removeIoObjectFromClient(this._manager, virtualFile, this._syncDB, this._checkedOutItemsByLocalPath, this._previewSync);
        if (!this._previewSync) {
            this.setLocationStateDeletedAndRemoveFromParent(this._manager, virtualFile);
        }
        return false;
    }

    public boolean moved(IResource dvResource) {
        return this.deleted(dvResource);
    }

    public boolean notFound(IResource dvResource) {
        if (Thread.currentThread().isInterrupted()) {
            return true;
        }
        IVirtualFile virtualFile = this.getFile(dvResource, false);
        if (virtualFile == null) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, dvResource, "Not mounted", 2);
            this._exception = new VfsException("Internal error: not mounted resource below mounted folder: " + dvResource.getPersistentURL());
            return false;
        }
        this._syncRemoveFeatureMget.removeIoObjectFromClient(this._manager, virtualFile, this._syncDB, this._checkedOutItemsByLocalPath, this._previewSync);
        this.setLocationStateDeletedAndRemoveFromParent(this._manager, virtualFile);
        return false;
    }

    public boolean notApplicable(IResource resource) {
        return false;
    }

    public boolean invalid(String resourcePath) {
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, resourcePath, "Invalid Path", 0);
        this._exception = new VfsException("Internal error: invalid path: " + resourcePath);
        return false;
    }

    private void setLocationStateDeletedAndRemoveFromParent(VersionedFileSystemManager manager, IVirtualFile virtualFile) {
        VfsFolderItem folderItem = manager.getFolderItemCache().getFolderItemWithLocalPath(virtualFile.getAbsolutePath());
        if (folderItem != null) {
            VfsFolderItem parentFolderItem;
            folderItem.setLocationState(VfsFolderItemLocationState.DELETED);
            String parentLocalPath = virtualFile.getParent();
            if (parentLocalPath != null && (parentFolderItem = manager.getFolderItemCache().getFolderItemWithLocalPath(parentLocalPath)) != null) {
                HashMap<String, VfsFolderItem> removeMap = new HashMap<String, VfsFolderItem>();
                removeMap.put(folderItem.getAbsoluteRemotePath(), folderItem);
                VfsFolderItem.removeFolderItemsFromParent(parentFolderItem.asGenericFolder(), removeMap);
                manager.fireEventFolderItemsAddedOrRemoved(parentFolderItem.asGenericFolder());
            }
        }
    }

    public boolean receivedCollection(IResource dvCollection) {
        long currentServerTime = 0L;
        try {
            currentServerTime = this.getCurrentServerTime();
        }
        catch (VfsException e) {
            this._exception = e;
            return true;
        }
        IVirtualFile virtualFile = this.getFile(dvCollection, true);
        if (virtualFile == null) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, dvCollection, "Not mounted", 2);
            this._exception = new VfsException("Internal error: not mounted folder below mounted folder: " + dvCollection.getPersistentURL());
            return false;
        }
        String absoluteLocalPath = virtualFile.getAbsolutePath();
        SyncEntry syncEntry = this._syncDB.getEntry(absoluteLocalPath);
        VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)this._manager.getFolderItemCache().getFolderItemWithLocalPath(absoluteLocalPath);
        if (!this._previewSync) {
            this.mkdirs(virtualFile);
            if (syncEntry == null) {
                syncEntry = this._syncDB.createEntry(absoluteLocalPath, "UNKNOWN_OBJECT_ID");
            }
            IVersion dvVersion = null;
            try {
                dvVersion = dvCollection.getAsVersionControlled().getActiveVersion();
                if (folderItem != null) {
                    folderItem.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
                    folderItem.setSyncedVersion(new VfsVersion(this._manager, dvVersion));
                    if (folderItem.getVcrResource() == null) {
                        folderItem.setVcrResource(dvCollection);
                    }
                }
                syncEntry.setVersionUrlAndRemoteSyncTime(dvVersion.getPersistentURL(), dvCollection.lastModified().getTime());
            }
            catch (VcmFailure vcmFailure) {
                new VfsException("Adapt SyncDB failed, because get active version failed: " + absoluteLocalPath, vcmFailure);
            }
            this._syncDBMget.setLastRemoteSyncTime(virtualFile.getAbsolutePath(), currentServerTime);
        }
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SUCCEEDED, virtualFile, null, 2);
        return false;
    }

    public boolean forbidden(String decodedResourcePath) {
        IVirtualFile virtualFile = this.getFile(decodedResourcePath);
        if (virtualFile == null) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, decodedResourcePath, "Not mounted and forbidden", 0);
            this._exception = new VfsException("Internal error: not mounted and forbidden resource below mounted folder: " + decodedResourcePath);
            return false;
        }
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, virtualFile, "Access denied");
        this._exception = new VfsException("Forbidden: " + decodedResourcePath);
        this.lockInSyncDbMget(this._syncDBMget, virtualFile, -1L, this._previewSync);
        return false;
    }

    public boolean receivedFile(IResource dvFileResource, IResponseStream content) {
        String detail;
        long syncedVersionTime;
        long currentServerTime = 0L;
        try {
            currentServerTime = this.getCurrentServerTime();
        }
        catch (VfsException e) {
            this._exception = e;
            return true;
        }
        if (Thread.currentThread().isInterrupted()) {
            return true;
        }
        IVirtualFile virtualFile = this.getFile(dvFileResource, true);
        if (virtualFile == null) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, dvFileResource, "Not mounted", 1);
            this._exception = new VfsException("Internal error: not mounted file below mounted folder: " + dvFileResource.getPersistentURL());
            return false;
        }
        String absoluteLocalPath = virtualFile.getAbsolutePath();
        boolean exists = virtualFile.exists();
        boolean writable = virtualFile.canWrite(false);
        SyncEntry syncEntry = this._syncDB.getEntry(absoluteLocalPath);
        VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)this._manager.getFolderItemCache().getFolderItemWithLocalPath(absoluteLocalPath);
        boolean hasLocalRemoteNameclash = exists && syncEntry == null;
        boolean checkedOut = folderItem != null && folderItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT;
        Date tmp_syncedVersionDate = (Date)this._syncedVersionDateByLocalPath.get(absoluteLocalPath);
        long NO_SYNC_TIME = -1L;
        long l = syncEntry != null ? syncEntry.getRemoteSyncTime() : (syncedVersionTime = tmp_syncedVersionDate != null ? tmp_syncedVersionDate.getTime() : -1L);
        if (checkedOut && syncedVersionTime == -1L) {
            String message = "No sync time for checked-out file";
            new VfsException(message + ": " + absoluteLocalPath);
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, virtualFile, message, 1);
            return false;
        }
        long lastModified = 0L;
        IVersionControlledResource dvVersionControlledResource = null;
        IVersion dvActiveVersion = null;
        String xcmObjectId = null;
        try {
            lastModified = dvFileResource.lastModified().getTime();
            dvVersionControlledResource = dvFileResource.getAsVersionControlled();
            dvActiveVersion = dvVersionControlledResource.getActiveVersion();
            xcmObjectId = dvFileResource.getXCMObjectId();
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, virtualFile, "Could not get remote properties: " + vcmFailure.getMessage());
            this._exception = new VfsException(vcmFailure.getMessage(), vcmFailure);
            this.lockInSyncDbMget(this._syncDBMget, virtualFile, syncedVersionTime, this._previewSync);
            return false;
        }
        boolean preconditionsOk = this.checkPreconditions(hasLocalRemoteNameclash, folderItem, dvVersionControlledResource, virtualFile, syncedVersionTime, checkedOut, lastModified, dvFileResource, exists, writable, currentServerTime);
        if (!preconditionsOk) {
            return false;
        }
        if (!this._previewSync) {
            this.mkdirs(virtualFile.getParentFile());
            if (syncEntry == null) {
                syncEntry = this._syncDB.createEntry(absoluteLocalPath, xcmObjectId);
            }
        }
        if (folderItem != null) {
            folderItem.setVcrResource(dvFileResource);
        }
        if (!this._previewSync) {
            try {
                this.writeToDisk(virtualFile, content, absoluteLocalPath, lastModified);
            }
            catch (VfsException e) {
                this._exception = e;
                this.lockInSyncDbMget(this._syncDBMget, virtualFile, 0L, false);
                if (virtualFile.exists()) {
                    syncEntry.setVersionUrlAndRemoteSyncTime(dvActiveVersion.getPersistentURL(), 0L);
                    if (folderItem != null) {
                        folderItem.setSyncedVersion(new VfsVersion(this._manager, dvActiveVersion));
                        folderItem.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
                    }
                } else {
                    this._syncDB.removeEntry(absoluteLocalPath);
                    if (folderItem != null) {
                        folderItem.setSyncedVersion(null);
                        folderItem.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
                    }
                }
                return false;
            }
            if (folderItem != null) {
                folderItem.setSyncedVersion(new VfsVersion(this._manager, dvActiveVersion));
                folderItem.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
                folderItem.setDvLocalRemoteNameClashVcr(null);
            }
            syncEntry.setVersionUrlAndRemoteSyncTime(dvActiveVersion.getPersistentURL(), lastModified);
            this._syncDBMget.setLastRemoteSyncTime(absoluteLocalPath, currentServerTime);
        }
        String string = detail = this._previewSync ? "preview" : null;
        if (exists) {
            VfsActionRecorder.log(VfsActionType.UPDATE, VfsActionStatus.SUCCEEDED, virtualFile, detail);
            if (!this._previewSync) {
                this._manager.fireEventFolderItemContentChanged(absoluteLocalPath, IVfsFolderItemListener2.ContentChangeReasons.UPDATED);
            }
        } else {
            VfsActionRecorder.log(VfsActionType.CREATE, VfsActionStatus.SUCCEEDED, virtualFile, detail);
            if (!this._previewSync) {
                this._manager.fireEventFolderItemContentChanged(absoluteLocalPath, IVfsFolderItemListener2.ContentChangeReasons.ADDED);
            }
        }
        return false;
    }

    abstract boolean checkPreconditions(boolean var1, VfsActivityRecordedFolderItem var2, IVersionControlledResource var3, IVirtualFile var4, long var5, boolean var7, long var8, IResource var10, boolean var11, boolean var12, long var13);

    void mkdirs(IVirtualFile folder) {
        if (folder.mkdirs()) {
            this._createdLocalFolders.add(folder);
        }
    }

    /*
     * Loose catch block
     */
    void writeToDisk(IVirtualFile virtualFile, IResponseStream content, String absoluteLocalPath, long lastModified) throws VfsException {
        block20: {
            virtualFile.setWritable();
            try {
                block21: {
                    VfsException exception;
                    OutputStream outputStream;
                    block17: {
                        outputStream = null;
                        try {
                            outputStream = this._fileService.constructFileOutputStream(virtualFile);
                        }
                        catch (FileNotFoundException e) {
                            String message = "Failed to create/open file: " + e.getMessage();
                            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, virtualFile, message);
                            throw new VfsException(message, e);
                        }
                        exception = null;
                        if (content == null) break block17;
                        while (content.read(outputStream) != -1) {
                        }
                    }
                    Object var11_10 = null;
                    try {
                        outputStream.close();
                    }
                    catch (IOException e2) {
                        String message2 = "Failed to close file " + absoluteLocalPath + ": " + e2.getMessage();
                        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, virtualFile, message2);
                        exception = new VfsException(message2, e2);
                    }
                    WrongCaseOfFolderPathUtil.rememberWrongCaseOfFolderPathAfterLocalWrite(this._context, virtualFile);
                    VfsFile.refreshTimestampOnSyncedFile(virtualFile, new Date(lastModified));
                    if (exception != null) {
                        throw exception;
                    }
                    break block21;
                    {
                        catch (IOException e) {
                            String message = "Failed to write content for file " + absoluteLocalPath + ": " + e.getMessage();
                            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, virtualFile, message);
                            exception = new VfsException(message, e);
                            Object var11_11 = null;
                            try {
                                outputStream.close();
                            }
                            catch (IOException e2) {
                                String message2 = "Failed to close file " + absoluteLocalPath + ": " + e2.getMessage();
                                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, virtualFile, message2);
                                exception = new VfsException(message2, e2);
                            }
                            WrongCaseOfFolderPathUtil.rememberWrongCaseOfFolderPathAfterLocalWrite(this._context, virtualFile);
                            VfsFile.refreshTimestampOnSyncedFile(virtualFile, new Date(lastModified));
                            if (exception != null) {
                                throw exception;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        try {
                            outputStream.close();
                        }
                        catch (IOException e2) {
                            String message2 = "Failed to close file " + absoluteLocalPath + ": " + e2.getMessage();
                            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, virtualFile, message2);
                            exception = new VfsException(message2, e2);
                        }
                        WrongCaseOfFolderPathUtil.rememberWrongCaseOfFolderPathAfterLocalWrite(this._context, virtualFile);
                        VfsFile.refreshTimestampOnSyncedFile(virtualFile, new Date(lastModified));
                        if (exception != null) {
                            throw exception;
                        }
                        throw throwable;
                    }
                }
                Object var15_21 = null;
                if (virtualFile.setReadOnly()) break block20;
                String message = "Setting file " + absoluteLocalPath + " to read-only failed.";
                Logbook.getErrorChapter().println(message);
                new VfsException(message);
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                if (!virtualFile.setReadOnly()) {
                    String message = "Setting file " + absoluteLocalPath + " to read-only failed.";
                    Logbook.getErrorChapter().println(message);
                    new VfsException(message);
                }
                throw throwable;
            }
            {
            }
        }
    }

    public void requestCompleted() {
        this._syncRequestCompleted = true;
    }

    public boolean getSyncRequestCompleted() {
        return this._syncRequestCompleted;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

