/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.fileservice;

import com.tssap.dtr.client.lib.util.EnvironmentVariables;
import com.tssap.dtr.client.lib.util.Platform;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.fileservice.LocalFileService;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

class VirtualFile
implements IVirtualFile {
    File _file;

    public IFileService getFileService() {
        return new LocalFileService();
    }

    VirtualFile(File file) {
        this._file = file;
    }

    public boolean canRead() {
        return this._file.canRead();
    }

    public boolean canWrite() {
        return this._file.canWrite();
    }

    public int compareTo(Object o) {
        if (o instanceof IVirtualFile) {
            return this.compareTo((IVirtualFile)o);
        }
        throw new ClassCastException("Wrong class: " + (o == null ? "<null>" : o.getClass().getName()) + " (expected IVirtualFile).");
    }

    public int compareTo(IVirtualFile pathname) {
        return this._file.compareTo(((VirtualFile)pathname)._file);
    }

    public boolean createNewFile() throws IOException {
        return this._file.createNewFile();
    }

    public boolean delete() {
        return this._file.delete();
    }

    public void deleteOnExit() {
        this._file.deleteOnExit();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VirtualFile) {
            return this._file.equals(((VirtualFile)obj)._file);
        }
        return false;
    }

    public boolean exists() {
        return this._file.exists();
    }

    public String getCanonicalPath() throws IOException {
        return this._file.getCanonicalPath();
    }

    public String getName() {
        return this._file.getName();
    }

    public String getParent() {
        return this._file.getParent();
    }

    public IVirtualFile getParentFile() {
        File parentFile = this._file.getParentFile();
        if (parentFile != null) {
            return new VirtualFile(parentFile);
        }
        return null;
    }

    public String getAbsolutePath() {
        return this._file.getAbsolutePath();
    }

    public int hashCode() {
        return this._file.hashCode();
    }

    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    public boolean isFile() {
        return this._file.isFile();
    }

    public boolean isHidden() {
        return this._file.isHidden();
    }

    public long lastModified() {
        return this._file.lastModified();
    }

    public long length() {
        return this._file.length();
    }

    public String[] list() {
        return this._file.list();
    }

    public IVirtualFile[] listFiles() {
        File[] files = this._file.listFiles();
        if (files == null) {
            return new IVirtualFile[0];
        }
        IVirtualFile[] virtualFiles = new IVirtualFile[files.length];
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            virtualFiles[i] = new VirtualFile(file);
            ++i;
        }
        return virtualFiles;
    }

    public boolean mkdir() {
        return this._file.mkdir();
    }

    public boolean mkdirs() {
        return this._file.mkdirs();
    }

    public boolean renameTo(IVirtualFile dest) {
        return this._file.renameTo(((VirtualFile)dest)._file);
    }

    public boolean setLastModified(long time) {
        return this._file.setLastModified(time);
    }

    public boolean setReadOnly() {
        if (EnvironmentVariables.IGNORE_READONLY_FLAG) {
            return true;
        }
        return this._file.setReadOnly();
    }

    public String toString() {
        return this._file.toString();
    }

    public URL toURL() throws MalformedURLException {
        return this._file.toURL();
    }

    public boolean setWritable() {
        if (!this.exists() || this.canWrite()) {
            return true;
        }
        return Platform.getPlatform().setWritable(this._file);
    }

    public boolean canWrite(boolean expected) {
        if (EnvironmentVariables.IGNORE_READONLY_FLAG) {
            if (expected && !this.canWrite()) {
                this.setWritable();
            }
            return expected;
        }
        return this.canWrite();
    }

    public char getSeparatorChar() {
        return File.separatorChar;
    }

    public String getSeparator() {
        return File.separator;
    }
}

