/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WrongCaseOfFoldernameManager {
    private Map _wrongPathToMountedPath = new HashMap();
    private final IVirtualFile _file;
    private static final String DELIMITER = "=";

    WrongCaseOfFoldernameManager(IVirtualFile file) {
        this._file = file;
        try {
            if (this._file.exists()) {
                this.depersist();
            }
        }
        catch (IOException e) {
            throw new VfsRuntimeException("Failed to depersist WrongCaseOfFoldername map (" + e.getMessage() + ").", e);
        }
    }

    private void persist() throws IOException {
        this._file.getParentFile().mkdirs();
        OutputStream outputStream = this._file.getFileService().constructFileOutputStream(this._file);
        PrintWriter printWriter = new PrintWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(printWriter);
        Iterator iterator = this._wrongPathToMountedPath.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            bufferedWriter.write((String)entry.getKey());
            bufferedWriter.write(DELIMITER);
            bufferedWriter.write((String)entry.getValue());
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }

    /*
     * WARNING - void declaration
     */
    private void depersist() throws IOException {
        String line;
        this._wrongPathToMountedPath.clear();
        InputStream inputStream = this._file.getFileService().constructFileInputStream(this._file);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((line = bufferedReader.readLine()) != null) {
            void var4_4;
            int indexDelimiter = var4_4.indexOf(DELIMITER);
            String wrongPath = var4_4.substring(0, indexDelimiter);
            String mountedPath = var4_4.substring(indexDelimiter + DELIMITER.length());
            this._wrongPathToMountedPath.put(wrongPath, mountedPath);
        }
    }

    public String resolveWrongAbsoluteLocalFolderpath(String wrongPathToResolve) {
        wrongPathToResolve = this.simpliflyLocalPath(wrongPathToResolve);
        Iterator iterator = this._wrongPathToMountedPath.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String wrongPath = (String)entry.getKey();
            if (!wrongPath.equalsIgnoreCase(wrongPathToResolve)) continue;
            String mountedPath = (String)entry.getValue();
            return mountedPath;
        }
        return null;
    }

    public void storeWrongAbsoluteLocalFolderpath(String wrongPathToResolve, String mountedPath) {
        wrongPathToResolve = this.simpliflyLocalPath(wrongPathToResolve);
        mountedPath = this.simpliflyLocalPath(mountedPath);
        if (!this._wrongPathToMountedPath.containsKey(wrongPathToResolve)) {
            this._wrongPathToMountedPath.put(wrongPathToResolve, mountedPath);
            try {
                this.persist();
            }
            catch (IOException e) {
                throw new VfsRuntimeException("Failed to persist WrongCaseOfFoldername map (" + e.getMessage() + ").", e);
            }
        }
    }

    private String simpliflyLocalPath(String localPath) {
        return PathUtilities.preventTrailingSeparator(localPath, true);
    }
}

