/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFilterType;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.impl.Client;
import com.tssap.dtr.client.lib.vfs.config.impl.Configuration;
import com.tssap.dtr.client.lib.vfs.config.impl.MountPoint;
import com.tssap.dtr.client.lib.vfs.config.impl.RepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.impl.Server;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.LocalFileService;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmClientProperty;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

class VfsContext
implements IVfsContext {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$config$impl$VfsContext == null ? (class$com$tssap$dtr$client$lib$vfs$config$impl$VfsContext = VfsContext.class$("com.tssap.dtr.client.lib.vfs.config.impl.VfsContext")) : class$com$tssap$dtr$client$lib$vfs$config$impl$VfsContext));
    private Client m_client;
    private IVfsRemoteLocator[] m_rootRemoteLocators = null;
    private static final String BROWSE_ROOT_SET = XCM.WORKSPACE_ROOT_SET.qualifiedName;
    private IVfsRemoteLocator[] m_browseRootRemoteLocators = null;
    final IVfsRemoteLocator[] EMPTY_LOCATORS = new IVfsRemoteLocator[0];
    IFileService _fileService = new LocalFileService();
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$config$impl$VfsContext;

    VfsContext(Client client) {
        this.m_client = client;
    }

    public IVfsRemoteLocator getRemoteLocator(String absoluteLocalPath) {
        if (absoluteLocalPath == null) {
            return null;
        }
        if (absoluteLocalPath.length() == this.m_client.getAbsoluteLocalRoot().length() - 1 ? !absoluteLocalPath.startsWith(PathUtilities.preventTrailingSeparator(this.m_client.getAbsoluteLocalRoot(), new LocalFileService())) : !absoluteLocalPath.startsWith(this.m_client.getAbsoluteLocalRoot())) {
            return null;
        }
        SimpleLocator remoteLocator = null;
        Iterator mountPoints = this.m_client.mountPoints();
        while (mountPoints.hasNext()) {
            IMountPoint mountPoint = (IMountPoint)mountPoints.next();
            String absoluteRemotePath = mountPoint.getAbsoluteRemotePath(absoluteLocalPath);
            if (absoluteRemotePath == null) continue;
            remoteLocator = new SimpleLocator(mountPoint.getRepositoryServer().getConnectionTemplateId(), absoluteRemotePath);
            break;
        }
        return remoteLocator;
    }

    public IVfsRemoteLocator getRemoteLocator(URL url) {
        if (url == null) {
            return null;
        }
        String urlAsString = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + url.getPath();
        return this.getRemoteLocatorFromUrl(urlAsString);
    }

    public IVfsRemoteLocator getRemoteLocatorFromUrl(String urlAsString) {
        if (urlAsString == null) {
            return null;
        }
        Iterator servers = this.m_client.getLogicalSystem().repositoryServers();
        while (servers.hasNext()) {
            IRepositoryServer server = (IRepositoryServer)servers.next();
            String webLocator = server.getWebLocator();
            if (urlAsString.length() < webLocator.length() || !urlAsString.startsWith(server.getWebLocator())) continue;
            return new SimpleLocator(server.getConnectionTemplateId(), Encoder.decodePath((String)urlAsString.substring(webLocator.length())));
        }
        return null;
    }

    public String getBrowsePath(IVfsRemoteLocator locator) {
        IVfsRemoteLocator[] browseRoots = this.getBrowseRootRemoteLocators();
        int i = 0;
        while (i < browseRoots.length) {
            IVfsRemoteLocator browseRoot = browseRoots[i];
            if (locator.getConnectionTemplateId() == browseRoot.getConnectionTemplateId() && locator.getCanonicalAbsoluteRemotePath().startsWith(browseRoot.getCanonicalAbsoluteRemotePath())) {
                return locator.getCanonicalAbsoluteRemotePath().substring(browseRoot.getCanonicalAbsoluteRemotePath().length() - 1);
            }
            ++i;
        }
        return null;
    }

    public String getUrl(IVfsRemoteLocator remoteLocator) {
        IRepositoryServer server = this.m_client.getLogicalSystem().getRepositoryServer(remoteLocator.getConnectionTemplateId());
        return server.getWebLocator().concat(Encoder.encodePath((String)remoteLocator.getAbsoluteRemotePath()));
    }

    public IVfsRemoteLocator[] getRootRemoteLocators() {
        if (this.m_rootRemoteLocators == null) {
            Iterator servers = this.m_client.getLogicalSystem().repositoryServers();
            ArrayList<SimpleLocator> locators = new ArrayList<SimpleLocator>();
            while (servers.hasNext()) {
                IRepositoryServer server = (IRepositoryServer)servers.next();
                locators.add(new SimpleLocator(server.getConnectionTemplateId(), server.getAbsoluteRemoteRoot()));
            }
            IVfsRemoteLocator[] asArray = new IVfsRemoteLocator[locators.size()];
            locators.toArray(asArray);
            this.m_rootRemoteLocators = asArray;
        }
        return this.m_rootRemoteLocators;
    }

    public String getServerProperty(IVfsRemoteLocator serverLocator, String qualifiedPropertyName) throws VfsException {
        Iterator servers = this.m_client.getLogicalSystem().repositoryServers();
        while (servers.hasNext()) {
            IRepositoryServer server = (IRepositoryServer)servers.next();
            if (server.getConnectionTemplateId() != serverLocator.getConnectionTemplateId() || !server.getAbsoluteRemoteRoot().equals(serverLocator.getAbsoluteRemotePath())) continue;
            try {
                return server.getProperty(qualifiedPropertyName);
            }
            catch (ConfigurationException e) {
                throw new VfsException("Accessing server root property (" + qualifiedPropertyName + ") failed: " + e.getMessage(), e);
            }
        }
        throw new VfsException("Unknown server: " + this.getUrl(serverLocator));
    }

    public IVfsRemoteLocator[] getBrowseRootRemoteLocators() {
        if (this.m_browseRootRemoteLocators == null) {
            IVfsRemoteLocator[] servletRoots = this.getRootRemoteLocators();
            ArrayList<SimpleLocator> browseRoots = new ArrayList<SimpleLocator>();
            int i = 0;
            while (i < servletRoots.length) {
                IVfsRemoteLocator servletRoot = servletRoots[i];
                try {
                    String root = this.getServerProperty(servletRoot, BROWSE_ROOT_SET);
                    if (root == null) {
                        throw new VfsRuntimeException("No browseroot found for server " + this.getUrl(servletRoot));
                    }
                    root = PathUtilities.assureTrailingSeparator(root, PathUtilities.REMOTE_FILESERVICE);
                    browseRoots.add(new SimpleLocator(servletRoot.getConnectionTemplateId(), root));
                }
                catch (VfsException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
                ++i;
            }
            this.m_browseRootRemoteLocators = new IVfsRemoteLocator[browseRoots.size()];
            browseRoots.toArray(this.m_browseRootRemoteLocators);
        }
        return this.m_browseRootRemoteLocators;
    }

    public String getAbsoluteLocalPath(int connectionTemplateId, String absoluteRemotePath) {
        Iterator mountPoints = this.m_client.mountPoints();
        while (mountPoints.hasNext()) {
            String absoluteLocalPath;
            IMountPoint mountPoint = (IMountPoint)mountPoints.next();
            IRepositoryServer repositoryServer = mountPoint.getRepositoryServer();
            if (repositoryServer.getConnectionTemplateId() != connectionTemplateId || (absoluteLocalPath = mountPoint.getAbsoluteLocalPath(absoluteRemotePath)) == null) continue;
            return absoluteLocalPath;
        }
        return null;
    }

    public SyncDB getSyncDb(String absoluteLocalPath) {
        IMountPoint mountPoint = this.m_client.getMountPointForLocalPath(absoluteLocalPath);
        if (mountPoint != null) {
            return mountPoint.getSyncDb();
        }
        return null;
    }

    public boolean hasSyncDb(String absoluteLocalPath) {
        IMountPoint mountPoint = this.m_client.getMountPointForLocalPath(absoluteLocalPath);
        return mountPoint != null;
    }

    public VfsFilterType getFilterType(IVfsRemoteLocator folderLocator) {
        if (this.areFiltersDefined()) {
            return this.m_client.getLogicalSystem().getRepositoryServer(folderLocator.getConnectionTemplateId()).getFilterType(folderLocator.getCanonicalAbsoluteRemotePath());
        }
        return VfsFilterType.INCLUDE;
    }

    public IVfsRemoteLocator[] getWorkspaceFilters(IVfsRemoteLocator repository) {
        return this.m_client.getLogicalSystem().getRepositoryServer(repository.getConnectionTemplateId()).getWorkspaceFilters();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VfsContext) {
            return this.m_client.equals(((VfsContext)obj).m_client);
        }
        return false;
    }

    public int hashCode() {
        return this.m_client.hashCode();
    }

    public String toString() {
        return this.m_client.getName();
    }

    public String[] getAbsoluteLocalPathsOfMountPoints() {
        Iterator mountPoints = this.m_client.mountPoints();
        ArrayList<String> mountPointFolders = new ArrayList<String>();
        while (mountPoints.hasNext()) {
            IMountPoint mountPoint = (IMountPoint)mountPoints.next();
            mountPointFolders.add(this.m_client.getAbsoluteLocalRoot().concat(mountPoint.getRelativeLocalRoot()));
        }
        return mountPointFolders.toArray(new String[mountPointFolders.size()]);
    }

    public IVfsRemoteLocator[] getRemoteLocatorsOfMountPoints() {
        Iterator mountPoints = this.m_client.mountPoints();
        ArrayList<SimpleLocator> mountPointFolders = new ArrayList<SimpleLocator>();
        while (mountPoints.hasNext()) {
            IMountPoint mountPoint = (IMountPoint)mountPoints.next();
            mountPointFolders.add(new SimpleLocator(mountPoint.getRepositoryServer().getConnectionTemplateId(), mountPoint.getRepositoryServer().getAbsoluteRemoteRoot().concat(mountPoint.getRelativeRemoteRoot())));
        }
        return mountPointFolders.toArray(new IVfsRemoteLocator[mountPointFolders.size()]);
    }

    public IVfsRemoteLocator[] getPossibleRemoteLocators(int connectionTemplateId, String browsePath) {
        if (browsePath == null) {
            return this.EMPTY_LOCATORS;
        }
        IVfsRemoteLocator[] browseRoots = this.getBrowseRootRemoteLocators();
        ArrayList<SimpleLocator> possibleLocators = new ArrayList<SimpleLocator>(browseRoots.length);
        int i = 0;
        while (i < browseRoots.length) {
            IVfsRemoteLocator browseRoot = browseRoots[i];
            if (connectionTemplateId == browseRoot.getConnectionTemplateId()) {
                String canonicalAbsoluteRemotePath = browseRoot.getCanonicalAbsoluteRemotePath().concat(browsePath.substring(1));
                possibleLocators.add(new SimpleLocator(connectionTemplateId, canonicalAbsoluteRemotePath));
            }
            ++i;
        }
        return possibleLocators.toArray(this.EMPTY_LOCATORS);
    }

    public String getUserName(int connectionTemplateId) {
        try {
            IConnectionTemplate template = Configuration.getTemplateProvider().getConnectionTemplate(connectionTemplateId);
            return template.getSessionContext().getUser();
        }
        catch (InvalidTemplateIDException ex) {
            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)ex, (int)500);
            return null;
        }
    }

    public String getWebLocator(int connectionTemplateId) {
        return this.m_client.getLogicalSystem().getRepositoryServer(connectionTemplateId).getWebLocator();
    }

    public String getClientName() {
        return this.m_client.getName();
    }

    public String getClientFilter() {
        return this.m_client.getClientFilter();
    }

    public IVfsContext.MountpointRelation getMountpointRelation(String absoluteRemotePath) {
        if (absoluteRemotePath != null) {
            Iterator mountPoints = this.m_client.mountPoints();
            while (mountPoints.hasNext()) {
                IMountPoint mountPoint = (IMountPoint)mountPoints.next();
                String mountpointRemoteRoot = mountPoint.getRepositoryServer().getAbsoluteRemoteRoot().concat(mountPoint.getRelativeRemoteRoot());
                if (mountpointRemoteRoot.equals(absoluteRemotePath)) {
                    return IVfsContext.MountpointRelation.MOUNTPOINT;
                }
                if (mountpointRemoteRoot.startsWith(absoluteRemotePath)) {
                    return IVfsContext.MountpointRelation.ABOVE_MOUNTPOINT;
                }
                if (!absoluteRemotePath.startsWith(mountpointRemoteRoot)) continue;
                return IVfsContext.MountpointRelation.BELOW_MOUNTPOINT;
            }
        }
        return null;
    }

    private void assertNotNull(Object o, String message) {
        if (o == null) {
            throw new IllegalStateException(message);
        }
    }

    public boolean ping(IVfsRemoteLocator serverLocator, int maxRepeats, int millisToWaitForResponse, int acceptLastPingIfNoOlderThanMillis) {
        this.assertNotNull(serverLocator, "serverLocator is <null>");
        this.assertNotNull(this.m_client, "Client is <null>");
        ILogicalSystem system = this.m_client.getLogicalSystem();
        this.assertNotNull(system, "LogicalSystem is <null>");
        IRepositoryServer server = system.getRepositoryServer(serverLocator.getConnectionTemplateId());
        this.assertNotNull(server, "RepositoryServer is <null>");
        return server.ping(maxRepeats, millisToWaitForResponse, acceptLastPingIfNoOlderThanMillis);
    }

    public void resetlastPingSate(IVfsRemoteLocator serverLocator) {
        Server server = (Server)((Object)this.m_client.getLogicalSystem().getRepositoryServer(serverLocator.getConnectionTemplateId()));
        if (server != null) {
            server._lastPingTime = 0L;
        }
    }

    public int httpPing(IVfsRemoteLocator serverLocator, int maxRepeats, int millisToWaitForResponse, int acceptLastPingIfNoOlderThanMillis) {
        IRepositoryServer server = this.m_client.getLogicalSystem().getRepositoryServer(serverLocator.getConnectionTemplateId());
        return server.httpPing(maxRepeats, millisToWaitForResponse, acceptLastPingIfNoOlderThanMillis);
    }

    public boolean areFiltersDefined() {
        Iterator servers = this.m_client.getLogicalSystem().repositoryServers();
        while (servers.hasNext()) {
            RepositoryServer server = (RepositoryServer)servers.next();
            if (!server.filters().hasNext()) continue;
            return true;
        }
        return false;
    }

    public void setAllowedClientVersions(String minVersion, String maxVersion, String[] excludedVersions, String[] includedVersions) throws VfsException {
        IVfsRemoteLocator[] locators = this.getRootRemoteLocators();
        if (minVersion == null) {
            minVersion = "";
        }
        if (maxVersion == null) {
            maxVersion = "~";
        }
        StringBuffer exludeList = new StringBuffer();
        if (excludedVersions != null) {
            int i = 0;
            while (i < excludedVersions.length) {
                exludeList.append(excludedVersions[i]);
                exludeList.append('\n');
                ++i;
            }
        }
        StringBuffer includeList = new StringBuffer();
        if (includedVersions != null) {
            int i = 0;
            while (i < includedVersions.length) {
                includeList.append(includedVersions[i]);
                includeList.append('\n');
                ++i;
            }
        }
        IProperty minVersionProperty = PropertyFactoryAccess.getFactory().createStringProperty("XCM_CLIENT", VfsXcmClientProperty.MIN_CLIENT_VERSION.getPropertyName(), minVersion);
        IProperty maxVersionProperty = PropertyFactoryAccess.getFactory().createStringProperty("XCM_CLIENT", VfsXcmClientProperty.MAX_CLIENT_VERSION.getPropertyName(), maxVersion);
        IProperty excludeListProperty = PropertyFactoryAccess.getFactory().createStringProperty("XCM_CLIENT", VfsXcmClientProperty.EXCLUDED_CLIENT_VERSIONS.getPropertyName(), exludeList.toString());
        IProperty includeListProperty = PropertyFactoryAccess.getFactory().createStringProperty("XCM_CLIENT", VfsXcmClientProperty.INCLUDED_CLIENT_VERSIONS.getPropertyName(), includeList.toString());
        IProperty[] versionProperties = new IProperty[]{minVersionProperty, maxVersionProperty, excludeListProperty, includeListProperty};
        int i = 0;
        while (i < locators.length) {
            IVfsRemoteLocator locator = locators[i];
            try {
                IResource resource = ResourceFactoryManager.getInstance().getProxyFactory().createResource(locator.getConnectionTemplateId(), locator.getAbsoluteRemotePath());
                resource.setProperties(versionProperties);
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Setting version properties failed.", vcmFailure);
            }
            ++i;
        }
    }

    public IFileService getFileService() {
        return this._fileService;
    }

    public String resolveWrongAbsoluteLocalFolderpath(String wrongPathToResolve) {
        MountPoint mountPoint = this.m_client.getMountPointForMaybeWrongCasedLocalPath(wrongPathToResolve);
        if (mountPoint != null) {
            return mountPoint.resolveWrongAbsoluteLocalFolderpath(wrongPathToResolve);
        }
        return null;
    }

    public void storeWrongAbsoluteLocalFolderpath(String wrongPathToResolve, String correctMountedPath) {
        MountPoint mountPoint = (MountPoint)this.m_client.getMountPointForLocalPath(correctMountedPath);
        if (mountPoint != null) {
            mountPoint.storeWrongAbsoluteLocalFolderpath(wrongPathToResolve, correctMountedPath);
        } else {
            new VfsException("No mountpoint found for correctMountedPath=\"" + correctMountedPath + "\" and wrongPathToResolve=\"" + wrongPathToResolve + "\".");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SimpleLocator
    implements IVfsRemoteLocator {
        private int m_connectionTemplateId;
        private String m_absoluteRemotePath;
        private String m_canonicalAbsoluteRemotePath;

        SimpleLocator(int connectionTemplateId, String absoluteRemotePath) {
            this.m_connectionTemplateId = connectionTemplateId;
            this.m_absoluteRemotePath = absoluteRemotePath;
        }

        SimpleLocator(int connectionTemplateId, String absoluteRemotePath, String canonicalAbsoluteRemotePath) {
            this.m_connectionTemplateId = connectionTemplateId;
            this.m_absoluteRemotePath = absoluteRemotePath;
            this.m_canonicalAbsoluteRemotePath = canonicalAbsoluteRemotePath;
        }

        public int getConnectionTemplateId() {
            return this.m_connectionTemplateId;
        }

        public String getAbsoluteRemotePath() {
            return this.m_absoluteRemotePath;
        }

        public String getCanonicalAbsoluteRemotePath() {
            return this.m_canonicalAbsoluteRemotePath != null ? this.m_canonicalAbsoluteRemotePath : this.m_absoluteRemotePath;
        }
    }
}

