/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.ISettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Settings
implements ISettings {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$config$impl$Settings == null ? (class$com$tssap$dtr$client$lib$vfs$config$impl$Settings = Settings.class$("com.tssap.dtr.client.lib.vfs.config.impl.Settings")) : class$com$tssap$dtr$client$lib$vfs$config$impl$Settings));
    final File m_configFile;
    private boolean m_isChanged = false;
    private String diffToolPath;
    private String mergeToolPath;
    private String editToolPath;
    private IConfiguration m_configuration;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$config$impl$Settings;

    public Settings(IConfiguration configuration) {
        this.m_configuration = configuration;
        this.m_configFile = new File(this.m_configuration.getConfigFolder().getAbsolutePath(), "settings.xml");
        if (!this.m_configFile.exists()) {
            try {
                this.m_configFile.createNewFile();
            }
            catch (IOException e) {
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
            }
        }
        this.depersist();
    }

    public String getDiffToolPath() {
        return this.diffToolPath;
    }

    public String getMergeToolPath() {
        return this.mergeToolPath;
    }

    public String getEditToolPath() {
        return this.editToolPath;
    }

    public void persist() throws IOException {
        if (this.m_isChanged) {
            if (!this.m_configFile.canWrite()) {
                throw new IOException("settings " + this.m_configFile.getAbsolutePath() + " is read-only");
            }
            PrintWriter pw = new PrintWriter(new FileOutputStream(this.m_configFile));
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.println();
            pw.println("<tools>");
            pw.println("\t<mergetool path=\"" + this.mergeToolPath + "\" />");
            pw.println();
            pw.println("\t<difftool path=\"" + this.diffToolPath + "\" />");
            pw.println();
            pw.println("\t<edittool path=\"" + this.editToolPath + "\" />");
            pw.println();
            pw.println("</tools>");
            pw.close();
            this.m_isChanged = false;
        }
    }

    public void depersist() {
        SettingsXMLHandler settingsXMLHandler = new SettingsXMLHandler();
        if (this.m_configFile.length() <= 0L) {
            this.createDefaultSettingsXML();
        }
        try {
            InputSource settingsIS = new InputSource(new FileInputStream(this.m_configFile));
            XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            parser.setContentHandler(settingsXMLHandler);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.parse(settingsIS);
        }
        catch (IOException x) {
            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)x, (int)500);
        }
        catch (Exception x) {
            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)x, (int)500);
        }
    }

    private void createDefaultSettingsXML() {
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(this.m_configFile));
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.println();
            pw.println("<tools>");
            pw.println("\t<mergetool path=\"\" />");
            pw.println();
            pw.println("\t<difftool path=\"\" />");
            pw.println();
            pw.println("\t<edittool path=\"\" />");
            pw.println();
            pw.println("</tools>");
            pw.close();
        }
        catch (FileNotFoundException e) {
            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
        }
    }

    public void setDiffToolPath(String path) {
        this.diffToolPath = path;
        this.m_isChanged = true;
    }

    public void setEditToolPath(String path) {
        this.editToolPath = path;
        this.m_isChanged = true;
    }

    public void setMergeToolPath(String path) {
        this.mergeToolPath = path;
        this.m_isChanged = true;
    }

    public void saveSettings() {
        try {
            this.persist();
        }
        catch (IOException exp) {
            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)exp, (int)500);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SettingsXMLHandler
    implements ContentHandler {
        private SettingsXMLHandler() {
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (localName.equalsIgnoreCase("mergetool")) {
                Settings.this.mergeToolPath = atts.getValue("path");
            }
            if (localName.equalsIgnoreCase("difftool")) {
                Settings.this.diffToolPath = atts.getValue("path");
            }
            if (localName.equalsIgnoreCase("edittool")) {
                Settings.this.editToolPath = atts.getValue("path");
            }
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void endDocument() throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void endPrefixMapping(String prefix) {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int end) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
        }
    }
}

