/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ISessionContextBag;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SessionContextBag
implements ISessionContextBag {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$config$impl$SessionContextBag == null ? (class$com$tssap$dtr$client$lib$vfs$config$impl$SessionContextBag = SessionContextBag.class$("com.tssap.dtr.client.lib.vfs.config.impl.SessionContextBag")) : class$com$tssap$dtr$client$lib$vfs$config$impl$SessionContextBag));
    private ISessionContext m_defaultSessionContext = null;
    private Map m_contextsByServerUrl = new HashMap();
    private static final String SESSIONSCONTEXTS = "accounts";
    private static final String SESSIONSCONTEXT = "account";
    private static final String DEFAULT = "default";
    private static final String SERVER = "serverUrl";
    private static final String USER = "username";
    private static final String PASSWORD = "password";
    private static final String TRUE = "true";
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$config$impl$SessionContextBag;

    public SessionContextBag() {
        LOCATION.debugT("Constructing session context bag ''{0}''.", new Object[]{this});
    }

    public void depersist(InputStream inputStream) {
        DepersistHandler handler = new DepersistHandler();
        try {
            InputSource inputSource = new InputSource(inputStream);
            XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            parser.setContentHandler(handler);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            LOCATION.pathT("Depersisting session contexts... into ''{0}''.", new Object[]{this});
            parser.parse(inputSource);
            LOCATION.pathT("Depersisting session contexts... done.", new Object[0]);
        }
        catch (Exception x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            LOCATION.pathT("Depersisting session contexts... done with problems.", new Object[0]);
        }
        ISessionContext defaultContext = handler.getDepersistedDefaultSessionContext();
        if (defaultContext != null) {
            this.setDefaultSessionContext(defaultContext);
        }
        this.m_contextsByServerUrl.putAll(handler.getDepersistedSessionContexts());
    }

    public void persist(OutputStream outputStream) throws IOException {
        LOCATION.pathT("Persisting session contexts... from ''{0}''.", new Object[]{this});
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            bufferedWriter.newLine();
            bufferedWriter.write("<accounts>");
            bufferedWriter.newLine();
            ISessionContext defaultContext = this.m_defaultSessionContext;
            if (defaultContext != null) {
                this.persistContext(defaultContext, bufferedWriter, null, true);
            }
            Iterator iterator = this.m_contextsByServerUrl.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String serverUrl = (String)entry.getKey();
                ISessionContext context = (ISessionContext)entry.getValue();
                this.persistContext(context, bufferedWriter, serverUrl, false);
            }
            bufferedWriter.newLine();
            bufferedWriter.write("</accounts>");
            bufferedWriter.close();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            LOCATION.pathT("Persisting session contexts... done.", new Object[0]);
            throw throwable;
        }
        LOCATION.pathT("Persisting session contexts... done.", new Object[0]);
    }

    private void persistContext(ISessionContext context, BufferedWriter bufferedWriter, String serverUrl, boolean isDefault) throws IOException {
        if (context == null) {
            return;
        }
        LOCATION.pathT("Persisting session contexts... {0}session context ''{1}''", new Object[]{isDefault ? "default " : "", context.getUser()});
        if (context.getUser() != null) {
            bufferedWriter.newLine();
            bufferedWriter.write("\t<account");
            bufferedWriter.newLine();
            if (isDefault) {
                bufferedWriter.write("\t\tdefault=\"true\"");
            } else {
                bufferedWriter.write("\t\tserverUrl=\"" + serverUrl + "\"");
            }
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tusername=\"" + context.getUser() + "\"");
            bufferedWriter.newLine();
            if (context.getPassword() != null) {
                bufferedWriter.write("\t\tpassword=\"" + context.getPassword() + "\"");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t/>");
            bufferedWriter.newLine();
        }
    }

    public ISessionContext getDefaultSessionContext() {
        return this.m_defaultSessionContext;
    }

    public ISessionContext getSessionContextForServer(String serverUrl) {
        return (ISessionContext)this.m_contextsByServerUrl.get(SessionContextBag.assureTrailingSlash(serverUrl));
    }

    public ISessionContext getSessionContextForServerWithFallback(String serverUrl) {
        ISessionContext sessionContext = this.getSessionContextForServer(serverUrl);
        if (sessionContext == null && (sessionContext = this.getDefaultSessionContext()) == null) {
            sessionContext = new SessionContext();
            try {
                this.setSessionContextForServer(serverUrl, sessionContext);
            }
            catch (MalformedURLException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
        return sessionContext;
    }

    public ISessionContext createSessionContext(String username, String password) {
        LOCATION.debugT("Creating session context for user ''{0}''.", new Object[]{username});
        return new SessionContext(username, password);
    }

    public void setDefaultSessionContext(ISessionContext context) {
        LOCATION.debugT("Setting default session context ''{0}''.", new Object[]{context.getUser()});
        this.m_defaultSessionContext = context;
    }

    public void setSessionContextForServer(String serverUrl, ISessionContext context) throws MalformedURLException {
        LOCATION.debugT("Setting session context ''{0}'' for URL ''{1}''.", new Object[]{context.getUser(), serverUrl});
        if (serverUrl == null) {
            throw new IllegalArgumentException("Parameter 'serverUrl' must be non-null.");
        }
        new URL(serverUrl);
        if (context == null) {
            throw new IllegalArgumentException("Parameter 'context' must be non-null.");
        }
        this.m_contextsByServerUrl.put(SessionContextBag.assureTrailingSlash(serverUrl), context);
    }

    public String getServerUrlForSessionContext(ISessionContext context) {
        if (context == null) {
            return null;
        }
        LOCATION.debugT("O(n): Getting server URL from session context ''{0}''.", new Object[]{context.getUser()});
        Iterator iterator = this.m_contextsByServerUrl.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(context)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public ISessionContext removeSessionContextForServer(String serverUrl) {
        LOCATION.debugT("Removing session context for URL ''{0}''.", new Object[]{serverUrl});
        return (ISessionContext)this.m_contextsByServerUrl.remove(SessionContextBag.assureTrailingSlash(serverUrl));
    }

    /*
     * Unable to fully structure code
     */
    public static String assureTrailingSlash(String url) {
        if (url != null) ** GOTO lbl4
        return url;
lbl-1000:
        // 1 sources

        {
            url = url.concat("/");
lbl4:
            // 2 sources

            ** while (!url.endsWith((String)"/"))
        }
lbl5:
        // 1 sources

        return url;
    }

    public Iterator sessionContexts() {
        return Collections.unmodifiableMap(this.m_contextsByServerUrl).values().iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DepersistHandler
    extends DefaultHandler {
        private final int START_STATE = 0;
        private final int SESSIONSCONTEXTS_STATE = 1;
        private int m_state = 0;
        private Map m_depersistedSessionContexts = new HashMap();
        private ISessionContext m_depersistedDefaultSessionContext = null;

        private DepersistHandler() {
        }

        public ISessionContext getDepersistedDefaultSessionContext() {
            return this.m_depersistedDefaultSessionContext;
        }

        public Map getDepersistedSessionContexts() {
            return this.m_depersistedSessionContexts;
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes attributes) {
            switch (this.m_state) {
                case 0: {
                    if (localName.equalsIgnoreCase(SessionContextBag.SESSIONSCONTEXTS)) {
                        LOCATION.pathT("Depersisting session contexts... found ''{0}''", new Object[]{SessionContextBag.SESSIONSCONTEXTS});
                        this.m_state = 1;
                        break;
                    }
                    LOCATION.warningT("Invalid XML detected: expected ''{0}'', found ''{1}''.", new Object[]{SessionContextBag.SESSIONSCONTEXTS, localName});
                    break;
                }
                case 1: {
                    if (localName.equalsIgnoreCase(SessionContextBag.SESSIONSCONTEXT)) {
                        String defaultString = attributes.getValue(SessionContextBag.DEFAULT);
                        boolean isDefault = defaultString != null && defaultString.equalsIgnoreCase(SessionContextBag.TRUE);
                        String serverUrl = SessionContextBag.assureTrailingSlash(attributes.getValue(SessionContextBag.SERVER));
                        String userName = attributes.getValue(SessionContextBag.USER);
                        String password = attributes.getValue(SessionContextBag.PASSWORD);
                        LOCATION.pathT("Depersisting session contexts... found ''{0}'' for server ''{1}''", new Object[]{SessionContextBag.SESSIONSCONTEXT, serverUrl});
                        SessionContext context = new SessionContext(userName, password);
                        if (serverUrl != null) {
                            this.m_depersistedSessionContexts.put(serverUrl, context);
                        }
                        if (!isDefault) break;
                        this.m_depersistedDefaultSessionContext = context;
                        break;
                    }
                    LOCATION.warningT("Invalid XML detected: expected ''{0}'', found ''{1}''.", new Object[]{SessionContextBag.SESSIONSCONTEXT, localName});
                }
            }
        }
    }
}

