/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.requests.http.OptionsRequest;
import com.tssap.dtr.client.lib.protocol.templates.ConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IServer;
import com.tssap.dtr.client.lib.vfs.config.impl.Configuration;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmClientProperty;
import java.util.HashMap;
import java.util.Map;

class Server
implements IServer {
    private ILogicalSystem m_logicalSystem;
    private IConnectionTemplate m_connectionTemplate;
    private int m_connectionTemplateId;
    private final int MINIMUM_TIMEOUT = 10;
    private final int DEFAULT_PING_TIMEOUT = 10000;
    private final int DEFAULT_PING_REPETITIONS = 1;
    private final boolean DEFAULT_COMPRESSION_SETTING = false;
    private int m_transientPingTimeout = 10000;
    private int m_transientPingRepetitions = 1;
    long _lastPingTime;
    boolean _lastPingState;
    long _lastHttpPingTime;
    int _lastHttpPingState;
    private Map _propertyValueByQualifiedName;
    private boolean _propertiesInitialized;

    Server(ILogicalSystem logicalSystem, int connectionTemplateId) {
        this._initLogicalSystem(logicalSystem);
        this._initConnectionTemplateId(connectionTemplateId);
    }

    private void _initConnectionTemplateId(int connectionTemplateId) {
        this.m_connectionTemplateId = connectionTemplateId;
        try {
            this.m_connectionTemplate = Configuration.getTemplateProvider().getConnectionTemplate(connectionTemplateId);
        }
        catch (InvalidTemplateIDException ex) {
            throw new IllegalArgumentException("Parameter 'connectionTemplateId'='" + connectionTemplateId + "' has no corresponding connection template.");
        }
    }

    private void _initLogicalSystem(ILogicalSystem logicalSystem) {
        if (logicalSystem == null) {
            throw new IllegalArgumentException("Parameter 'logicalSystem' must be non-null.");
        }
        this.m_logicalSystem = logicalSystem;
    }

    public String toString() {
        return "Server<" + this.getUrl() + ">";
    }

    public String getUrl() {
        return this.m_connectionTemplate.getUrl();
    }

    public int getConnectionTemplateId() {
        return this.m_connectionTemplateId;
    }

    public String getPath() {
        return this.m_connectionTemplate.getBasePath();
    }

    public IVfsRemoteLocator getRemoteLocator() {
        return new IVfsRemoteLocator(){

            public int getConnectionTemplateId() {
                return Server.this.getConnectionTemplateId();
            }

            public String getAbsoluteRemotePath() {
                return Server.this.getPath();
            }

            public String getCanonicalAbsoluteRemotePath() {
                return Server.this.getPath();
            }
        };
    }

    public String getWebLocator() {
        return this.getUrl().substring(0, this.getUrl().length() - this.getPath().length());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Server)) {
            return false;
        }
        return this.m_connectionTemplateId == ((Server)o).m_connectionTemplateId;
    }

    public int hashCode() {
        return this.m_connectionTemplateId;
    }

    public ILogicalSystem getLogicalSystem() {
        return this.m_logicalSystem;
    }

    IConnectionTemplate getConnectionTemplate() {
        return this.m_connectionTemplate;
    }

    public boolean ping(int maxRepeats, int millisToWaitForResponse, int acceptLastPingIfNoOlderThanMillis) {
        return this.ping(acceptLastPingIfNoOlderThanMillis);
    }

    public boolean ping(int acceptLastPingIfNoOlderThanMillis) {
        long pingTime = System.currentTimeMillis();
        if (pingTime - this._lastPingTime >= (long)acceptLastPingIfNoOlderThanMillis) {
            this._lastPingTime = pingTime;
            try {
                this._lastPingState = this.httpPing() == 200;
            }
            catch (Exception e) {
                this._lastPingState = false;
            }
        }
        return this._lastPingState;
    }

    public int httpPing(int maxRepeats, int millisToWaitForResponse, int acceptLastPingIfNoOlderThanMillis) {
        return this.httpPing(acceptLastPingIfNoOlderThanMillis);
    }

    public int httpPing(int acceptLastPingIfNoOlderThanMillis) {
        long pingTime = System.currentTimeMillis();
        if (pingTime - this._lastHttpPingTime >= (long)acceptLastPingIfNoOlderThanMillis) {
            this._lastHttpPingTime = pingTime;
            try {
                this._lastHttpPingState = this.httpPing();
            }
            catch (Exception e) {
                this._lastHttpPingState = -1;
            }
        }
        return this._lastHttpPingState;
    }

    public int httpPing(int maxRepeats, int millisToWaitForResponse) throws ConfigurationException {
        return this.httpPing();
    }

    public int httpPing() throws ConfigurationException {
        long start = System.currentTimeMillis();
        try {
            this.getConnectionTemplate().getSessionContext().cookies().removeAll();
            OptionsRequest optionsRequest = new OptionsRequest(this.getPath());
            Connection connection = new Connection(this.getConnectionTemplate());
            connection.setSocketReadTimeout(this.m_transientPingTimeout);
            connection.setRequestRepetitions(this.m_transientPingRepetitions, true);
            start = System.currentTimeMillis();
            IResponse optionsResponse = optionsRequest.perform((IConnection)connection, true);
            long end = System.currentTimeMillis();
            Logbook.getInfoChapter(2).println("OPTIONS request to " + this.getUrl() + " in " + (end - start) + " ms.");
            if (optionsResponse.getStatus() != 200) {
                Logbook.getWarnChapter().println("Ping on server " + this.getUrl() + " returned: " + optionsResponse.getStatus() + " " + optionsResponse.getStatusDescription());
            }
            return optionsResponse.getStatus();
        }
        catch (Exception e) {
            long end = System.currentTimeMillis();
            Logbook.getInfoChapter(2).println("Caught exception (" + e.getMessage() + ") in ping to " + this.getUrl() + " after " + (end - start) + " ms.");
            Logbook.getWarnChapter().println("Ping on server " + this.getUrl() + " failed (maybe server not available) - " + e.getMessage() + ".");
            throw new ConfigurationException("Options request failed.", e);
        }
    }

    public String getProperty(String qualifiedName) throws ConfigurationException {
        this.initializeProperties();
        return (String)this._propertyValueByQualifiedName.get(qualifiedName);
    }

    public int getReadTimeout() {
        return this.m_connectionTemplate.getSocketReadTimeout();
    }

    public int getDefaultReadTimeout() {
        return 300000;
    }

    public int getConnectTimeout() {
        return this.m_connectionTemplate.getSocketConnectTimeout();
    }

    public int getDefaultConnectTimeout() {
        return 10000;
    }

    public boolean getCompressionSetting() {
        return this.m_connectionTemplate.isCompressionEnabled();
    }

    public boolean getDefaultCompressionSetting() {
        return false;
    }

    public int getTransientPingTimeout() {
        return this.m_transientPingTimeout;
    }

    public int getDefaultTransientPingTimeout() {
        return 10000;
    }

    public int getDefaultTransientPingRepetitions() {
        return 1;
    }

    public int getTransientPingRepetitions() {
        return this.m_transientPingRepetitions;
    }

    public void setReadTimeout(int timeout) {
        if (timeout <= 10) {
            throw new IllegalArgumentException("Read timeout must be at least 10 milliseconds");
        }
        ((ConnectionTemplate)this.m_connectionTemplate).setSocketReadTimeout(timeout);
    }

    public void setProxyPort(int proxyPort) {
        ((ConnectionTemplate)this.m_connectionTemplate).setProxyPort(proxyPort);
    }

    public void setProxyHost(String proxyHost) {
        ((ConnectionTemplate)this.m_connectionTemplate).setProxyHost(proxyHost);
    }

    public void setUseProxy(boolean useProxy) {
        ((ConnectionTemplate)this.m_connectionTemplate).setUseProxy(useProxy);
    }

    public int getProxyPort() {
        return this.m_connectionTemplate.getProxyPort();
    }

    public String getProxyHost() {
        return this.m_connectionTemplate.getProxyHost();
    }

    public boolean isUsingProxy() {
        return this.m_connectionTemplate.isUsingProxy();
    }

    public void setConnectTimeout(int timeout) {
        if (timeout <= 10) {
            throw new IllegalArgumentException("Connect timeout must be at least 10 milliseconds");
        }
        ((ConnectionTemplate)this.m_connectionTemplate).setSocketConnectTimeout(timeout);
    }

    public void setCompression(boolean on) {
        ((ConnectionTemplate)this.m_connectionTemplate).enableCompression(on);
    }

    public void setTransientPingTimeout(int timeout) {
        if (timeout <= 10) {
            throw new IllegalArgumentException("Ping timeout must be at least 10 milliseconds");
        }
        this.m_transientPingTimeout = timeout;
    }

    public void setTransientPingRepetitions(int repetitions) {
        if (repetitions < 0) {
            throw new IllegalArgumentException("Ping repetitions must be a non-negative number");
        }
        this.m_transientPingRepetitions = repetitions;
    }

    private void initializeProperties() throws ConfigurationException {
        if (!this._propertiesInitialized) {
            String MIN_VERSION = VfsXcmClientProperty.MIN_CLIENT_VERSION.getCompletePropertyName();
            String MAX_VERSION = VfsXcmClientProperty.MAX_CLIENT_VERSION.getCompletePropertyName();
            String EXCLUDE_LIST = VfsXcmClientProperty.EXCLUDED_CLIENT_VERSIONS.getCompletePropertyName();
            String INCLUDE_LIST = VfsXcmClientProperty.INCLUDED_CLIENT_VERSIONS.getCompletePropertyName();
            String BROWSE_ROOT_SET = XCM.WORKSPACE_ROOT_SET.qualifiedName;
            String[] propertyNames = new String[]{MIN_VERSION, MAX_VERSION, EXCLUDE_LIST, INCLUDE_LIST, BROWSE_ROOT_SET};
            IVfsRemoteLocator rootLocator = this.getRemoteLocator();
            IProperty[] properties = new IProperty[]{};
            try {
                IResource resource = ResourceFactoryManager.getInstance().getProxyFactory().createResource(rootLocator.getConnectionTemplateId(), rootLocator.getAbsoluteRemotePath());
                properties = resource.getPropertySet(propertyNames);
            }
            catch (VcmFailure vcmFailure) {
                throw new ConfigurationException(vcmFailure.getMessage(), vcmFailure);
            }
            this._propertyValueByQualifiedName = new HashMap();
            int i = 0;
            while (i < properties.length) {
                IProperty property = properties[i];
                if (BROWSE_ROOT_SET.equals(property.getQualifiedName())) {
                    this._propertyValueByQualifiedName.put(property.getQualifiedName(), property.getFirstChild().getValue());
                } else {
                    this._propertyValueByQualifiedName.put(property.getQualifiedName(), property.getValue());
                }
                ++i;
            }
            this._propertiesInitialized = true;
        }
    }

    public String getUsername() {
        return this.m_connectionTemplate.getSessionContext().getUser();
    }
}

