/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.IActivityCollection;
import com.tssap.dtr.client.lib.deltavlib.ICheckedOutResource;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IPersistentResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IRepositoryOptions;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.RepositoryOptionsAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICheckinCollision;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.exceptions.ExceptionCategory;
import com.tssap.dtr.client.lib.exceptions.ExceptionSeverity;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.session.Certificates;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.util.LogUtil;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.util.Platform;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFilterType;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.impl.Client;
import com.tssap.dtr.client.lib.vfs.config.impl.Configuration;
import com.tssap.dtr.client.lib.vfs.config.impl.FilterManager;
import com.tssap.dtr.client.lib.vfs.config.impl.FolderFilter;
import com.tssap.dtr.client.lib.vfs.config.impl.LogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.impl.Server;
import com.tssap.dtr.client.lib.vfs.config.impl.WorkspaceFilter;
import com.tssap.dtr.client.lib.vfs.impl.VfsRemoteLocator;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;

class RepositoryServer
extends Server
implements IRepositoryServer {
    private String _absoluteRemoteRoot;
    private final FilterManager _filterManager = new FilterManager();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$config$impl$RepositoryServer == null ? (class$com$tssap$dtr$client$lib$vfs$config$impl$RepositoryServer = RepositoryServer.class$("com.tssap.dtr.client.lib.vfs.config.impl.RepositoryServer")) : class$com$tssap$dtr$client$lib$vfs$config$impl$RepositoryServer));
    private String _decodedRemoteActivityPath;
    private HashSet m_workspaceFilters = new HashSet();
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$config$impl$RepositoryServer;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$config$impl$FolderFilter;

    RepositoryServer(ILogicalSystem logicalSystem, int connectionTemplateId) {
        super(logicalSystem, connectionTemplateId);
        this._initAbsoluteRemoteRoot();
    }

    private void _initAbsoluteRemoteRoot() {
        this._absoluteRemoteRoot = Encoder.decodePath((String)this.getPath());
    }

    public String getAbsoluteRemoteRoot() {
        return this._absoluteRemoteRoot;
    }

    FilterManager getFilterManager() {
        return this._filterManager;
    }

    public Iterator filters() {
        return this._filterManager.filters();
    }

    public void removeFilter(String relativeRemotePrefix) {
        throw new UnsupportedOperationException();
    }

    public void setFilter(String relativeRemoteFolderPath, VfsFilterType type) {
        if (this.m_workspaceFilters.size() > 0) {
            LOCATION.warningT("Ignoring new folder filter ({0}: {1}) as there are already workspace filters defined.", new Object[]{type, relativeRemoteFolderPath});
            return;
        }
        if (relativeRemoteFolderPath.startsWith("/")) {
            relativeRemoteFolderPath = relativeRemoteFolderPath.substring(1);
        }
        this._filterManager.add(new FolderFilter(this._absoluteRemoteRoot + relativeRemoteFolderPath, type));
    }

    public VfsFilterType getFilterType(String absoluteRemoteFolderPath) {
        return this._filterManager.getAccessType(absoluteRemoteFolderPath);
    }

    public void setPassword(String userName, String oldPassword, String newPassword) throws ConfigurationException {
        IConnectionTemplate template;
        block8: {
            template = this.getConnectionTemplate();
            if (template == null) {
                throw new ConfigurationException("Could not find connection template for server \"" + this.getUrl() + "\".");
            }
            String user = template.getSessionContext().getUser();
            String oldPwd = template.getSessionContext().getPassword();
            if (user == null || oldPwd == null || !user.equals(userName) || !oldPwd.equals(oldPassword)) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new ConfigurationException("User unauthorized on server \"" + this.getUrl() + "\".");
            }
            IResourceFactory proxyFactory = ResourceFactoryManager.getInstance().getProxyFactory();
            String remotePath = template.getBasePath() + "principals/" + userName;
            IMutableProperty dvProperty = PropertyFactoryAccess.getFactory().createProperty(XCM.NAMESPACE_PREFIX, "password");
            dvProperty.setValue(newPassword);
            try {
                ICollection dvCollection = proxyFactory.createCollection(this.getConnectionTemplateId(), remotePath);
                dvCollection.setProperties(new IProperty[]{dvProperty});
            }
            catch (VcmFailure x) {
                template.getSessionContext().setPassword(newPassword);
                int status = this.httpPing(2, 2000);
                if (status == 200) break block8;
                template.getSessionContext().setPassword(oldPassword);
                throw new ConfigurationException("Setting password on server failed: " + x.getMessage());
            }
        }
        template.getSessionContext().setPassword(newPassword);
        try {
            com.tssap.dtr.client.lib.vfs.config.Configuration.getConfiguration().saveAll();
        }
        catch (IOException x) {
            throw new ConfigurationException("Setting password on client failed: " + x.getMessage());
        }
    }

    public void assureRemotePathExists(String serverRelativeRemoteRoot) throws ConfigurationException {
        String completeRemotePath = this.getAbsoluteRemoteRoot() + serverRelativeRemoteRoot;
        ICollection collection = this.getLowestExistingCollection(completeRemotePath);
        if (collection.getDecodedPath().startsWith(completeRemotePath)) {
            return;
        }
        try {
            IActivity activity = this.createNewActivity();
            if (!collection.isVersioned()) {
                if (!collection.isWorkspace()) {
                    throw new ConfigurationException(ExceptionSeverity.ERROR, ExceptionCategory.NO_WORKSPACE_FOR_REMOTE_PATH, new Object[]{serverRelativeRemoteRoot}, null);
                }
                IPersistentResourceFactory persistenceFactory = ResourceFactoryManager.getInstance().getPersistenceFactory();
                int index = completeRemotePath.indexOf(47, collection.getDecodedPath().length());
                String decodedPath = completeRemotePath.substring(0, index);
                collection = persistenceFactory.createCollection(this.getConnectionTemplateId(), decodedPath);
            }
            String workingPath = this.checkOutAndGetWorkingPath(collection, activity);
            this.createMissingPath(collection.getDecodedPath(), completeRemotePath, workingPath);
            this.checkInActivity(activity, completeRemotePath);
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 403) {
                throw new ConfigurationException(ExceptionSeverity.ERROR, ExceptionCategory.FORBIDDEN, new Object[]{completeRemotePath}, new Throwable[]{vcmFailure});
            }
            throw new ConfigurationException("Could not create remote path " + completeRemotePath + " (" + vcmFailure.getMessage() + ").", vcmFailure);
        }
    }

    public void assureEmptyRemotePathNotExists(String serverRelativeRemoteRoot) throws ConfigurationException {
        try {
            String completeRemotePath = this.getAbsoluteRemoteRoot() + serverRelativeRemoteRoot;
            ICollection mountPointCollection = this.getDvCollection(completeRemotePath);
            if (this.getMemberCount(mountPointCollection) > 0) {
                return;
            }
            ICollection parentCollectionToCheckout = this.getTopmostCollectionContainingOtherItemsUnderWorkspace(mountPointCollection);
            IActivity activity = this.createNewActivity();
            String workingPath = this.checkOutAndGetWorkingPath(parentCollectionToCheckout, activity);
            String name = this.getNextPart(parentCollectionToCheckout.getDecodedPath(), mountPointCollection.getDecodedPath());
            String resourcePathToDelete = PathUtilities.assureTrailingSeparator(workingPath, PathUtilities.REMOTE_FILESERVICE) + name;
            ICollection collectionToDelete = this.getDvCollection(resourcePathToDelete);
            collectionToDelete.remove();
            this.checkInActivity(activity, "Parent of deletion: " + parentCollectionToCheckout.getDecodedPath());
            if (this.getMemberCount(parentCollectionToCheckout) <= 1 && this.isDvCollectionDirectlyUnderWorkspace(parentCollectionToCheckout)) {
                parentCollectionToCheckout.remove();
            }
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logException(LOCATION, vcmFailure);
            throw new ConfigurationException("Deleting remote mount point path failed (" + vcmFailure.getMessage() + ").", vcmFailure);
        }
    }

    public IVfsRemoteLocator[] getWorkspaceFilters() {
        return ((AbstractCollection)this.m_workspaceFilters).toArray(new IVfsRemoteLocator[this.m_workspaceFilters.size()]);
    }

    public void setWorkspaceFilter(String relativeRemoteFolderPath, VfsFilterType type) {
        if (type == VfsFilterType.EXCLUDE) {
            LOCATION.warningT("setWorkspaceFilter() with EXCLUDE makes no sense... ignoring.");
            return;
        }
        if (this._filterManager.getFilterCount() > this.m_workspaceFilters.size()) {
            LOCATION.warningT("Removing all folder filters as we now switch to workspace filter mode.");
            this._filterManager.removeFilters(class$com$tssap$dtr$client$lib$vfs$config$impl$FolderFilter == null ? (class$com$tssap$dtr$client$lib$vfs$config$impl$FolderFilter = RepositoryServer.class$("com.tssap.dtr.client.lib.vfs.config.impl.FolderFilter")) : class$com$tssap$dtr$client$lib$vfs$config$impl$FolderFilter);
        }
        if (this._filterManager.getFilterCount() == 0) {
            this._filterManager.add(new WorkspaceFilter(this._absoluteRemoteRoot + "ws/", VfsFilterType.EXCLUDE));
        }
        if (relativeRemoteFolderPath.startsWith("/")) {
            relativeRemoteFolderPath = relativeRemoteFolderPath.substring(1);
        }
        this._filterManager.add(new WorkspaceFilter(this._absoluteRemoteRoot + relativeRemoteFolderPath, type));
        if (relativeRemoteFolderPath.startsWith("/")) {
            relativeRemoteFolderPath = relativeRemoteFolderPath.substring(1);
        }
        String absoluteRemoteFolderPath = this._absoluteRemoteRoot + relativeRemoteFolderPath;
        this.m_workspaceFilters.add(new VfsRemoteLocator(this.getConnectionTemplateId(), absoluteRemoteFolderPath, absoluteRemoteFolderPath));
    }

    private void createMissingPath(String startPath, String completeRemotePath, String workingPath) throws VcmFailure {
        int connectionTemplateId = this.getConnectionTemplateId();
        IPersistentResourceFactory persistenceFactory = ResourceFactoryManager.getInstance().getPersistenceFactory();
        startPath = PathUtilities.assureTrailingSeparator(startPath, PathUtilities.REMOTE_FILESERVICE);
        completeRemotePath = PathUtilities.assureTrailingSeparator(completeRemotePath, PathUtilities.REMOTE_FILESERVICE);
        workingPath = PathUtilities.assureTrailingSeparator(workingPath, PathUtilities.REMOTE_FILESERVICE);
        int index = startPath.length();
        while (index < completeRemotePath.length()) {
            int nextIndex = completeRemotePath.indexOf(47, index);
            String nextPart = completeRemotePath.substring(index, nextIndex + 1);
            index = nextIndex + 1;
            workingPath = workingPath + nextPart;
            persistenceFactory.createCollection(connectionTemplateId, Encoder.encodePath((String)workingPath));
        }
    }

    private String getDecodedRemoteActivityPath() throws VfsException {
        if (this._decodedRemoteActivityPath == null) {
            IActivityCollection[] dvActivityCollections;
            IRepositoryOptions dvRepositoryOptions = RepositoryOptionsAccess.getInstance();
            try {
                dvActivityCollections = dvRepositoryOptions.getActivityCollectionSet(this.getConnectionTemplateId(), Encoder.encodePath((String)this.getAbsoluteRemoteRoot()));
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get folders containing activities failed", vcmFailure);
            }
            if (dvActivityCollections == null || dvActivityCollections.length == 0) {
                throw new VfsException("No folders containing activities found.");
            }
            this._decodedRemoteActivityPath = dvActivityCollections[0].getDecodedPath();
        }
        return this._decodedRemoteActivityPath;
    }

    private IActivity createNewActivity() throws VcmFailure {
        IPersistentResourceFactory persistenceFactory = ResourceFactoryManager.getInstance().getPersistenceFactory();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss-z", Locale.getDefault());
        Calendar gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        String formattedDate = dateFormat.format(gmtCalendar.getTime());
        String userName = this.getConnectionTemplate().getSessionContext().getUser();
        String path = "act/config__u_" + userName + "_t_" + formattedDate + "_" + Platform.getPlatform().createGuid();
        String decodedPath = this.getAbsoluteRemoteRoot() + path;
        IActivity activity = persistenceFactory.createActivity(this.getConnectionTemplateId(), decodedPath);
        return activity;
    }

    private String checkOutAndGetWorkingPath(ICollection collection, IActivity activity) throws VcmFailure {
        ICheckedOutResource checkedOutResource = collection.getAsVersionControlled().checkout(new IActivity[]{activity}, 2);
        String workingPath = checkedOutResource.getDecodedPath();
        return PathUtilities.assureTrailingSeparator(workingPath, PathUtilities.REMOTE_FILESERVICE);
    }

    private void checkInActivity(IActivity activity, String completeRemotePath) throws VcmFailure, ConfigurationException {
        ICheckinCollision[] collisions = activity.checkin(2);
        if (collisions != null && collisions.length > 0) {
            throw new ConfigurationException("Check-in collisions when create remote path " + completeRemotePath);
        }
    }

    private ICollection getLowestExistingCollection(String completeRemotePath) throws ConfigurationException {
        String absoluteRemotePath = completeRemotePath;
        ICollection collection = this.getRemoteCollection(absoluteRemotePath);
        while (collection == null) {
            int index = absoluteRemotePath.lastIndexOf(47);
            if (index < 1) {
                throw new ConfigurationException("Could not create remote path " + completeRemotePath);
            }
            absoluteRemotePath = absoluteRemotePath.substring(0, index);
            collection = this.getRemoteCollection(absoluteRemotePath);
        }
        return collection;
    }

    private ICollection getRemoteCollection(String absoluteRemotePath) throws ConfigurationException {
        IResourceFactory factory = ResourceFactoryManager.getInstance().getLocatorFactory();
        try {
            return factory.createCollection(this.getConnectionTemplateId(), absoluteRemotePath, PathEncodingFlag.DECODED);
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() != 404) {
                throw new ConfigurationException("Checking existence failed for " + absoluteRemotePath + "(" + vcmFailure.getMessage() + ")", vcmFailure);
            }
            return null;
        }
    }

    private ICollection getTopmostCollectionContainingOtherItemsUnderWorkspace(ICollection dvCollection) throws VcmFailure {
        while (this.getMemberCount(dvCollection) <= 1) {
            ICollection tmp = this.getParentCollection(dvCollection);
            if (!tmp.isVersioned()) break;
            dvCollection = tmp;
        }
        return dvCollection;
    }

    private int getMemberCount(ICollection dvCollection) throws VcmFailure {
        return dvCollection.listMemberNames().length;
    }

    private ICollection getParentCollection(ICollection dvCollection) throws VcmFailure {
        String parentPath = PathUtilities.getParentPath(dvCollection.getDecodedPath(), PathUtilities.REMOTE_FILESERVICE, false);
        return this.getDvCollection(parentPath);
    }

    private ICollection getDvCollection(String absoluteRemotePath) throws VcmFailure {
        return ResourceFactoryManager.getInstance().getProxyFactory().createCollection(this.getConnectionTemplateId(), absoluteRemotePath, PathEncodingFlag.DECODED);
    }

    private boolean isDvCollectionDirectlyUnderWorkspace(ICollection dvCollectionUnderWorkspace) throws ConfigurationException, VcmFailure {
        if (!dvCollectionUnderWorkspace.isVersioned()) {
            throw new ConfigurationException("Collection not versioned i.e. not under workspace.");
        }
        IWorkspace dvWorkspace = dvCollectionUnderWorkspace.getWorkspace();
        ICollection dvParentCollection = this.getParentCollection(dvCollectionUnderWorkspace);
        return dvWorkspace.getPersistentURL().equals(dvParentCollection.getPersistentURL());
    }

    private String getNextPart(String shortPath, String longPath) {
        shortPath = PathUtilities.assureTrailingSeparator(shortPath, PathUtilities.REMOTE_FILESERVICE);
        if (!(longPath = PathUtilities.assureTrailingSeparator(longPath, PathUtilities.REMOTE_FILESERVICE)).startsWith(shortPath)) {
            throw new IllegalArgumentException("Path \"" + longPath + "\" not below path \"" + shortPath + "\".");
        }
        String additionalPath = longPath.substring(shortPath.length());
        int nextSlash = additionalPath.indexOf(47);
        if (nextSlash < 0) {
            throw new IllegalArgumentException("Both paths are equal.");
        }
        return additionalPath.substring(0, nextSlash);
    }

    public void setLoginData(String username, String password, KeyStore serverCerts, KeyStore clientCerts) throws KeyStoreException {
        IConnectionTemplate template = this.getConnectionTemplate();
        ISessionContext sessionContext = template.getSessionContext();
        Certificates certificates = sessionContext.certificates();
        KeyStore serverCertificates = certificates.getServerCertificates();
        KeyStore clientCertificates = certificates.getClientCertificates();
        boolean credentialsChanged = true;
        if (LogicalSystem.sameStrings(username, sessionContext.getUser()) && LogicalSystem.sameStrings(password, sessionContext.getPassword()) && (serverCerts == null && serverCertificates == null || serverCerts != null && serverCerts.equals(serverCertificates)) && (clientCerts == null && clientCertificates == null || clientCerts != null && clientCerts.equals(clientCertificates))) {
            credentialsChanged = false;
        }
        Configuration configuration = (Configuration)this.getLogicalSystem().getConfiguration();
        configuration.setDontUseUserXml();
        sessionContext.setUser(username);
        sessionContext.setPassword(password);
        if (serverCerts != null) {
            sessionContext.certificates().setServerCertificates(serverCerts);
            sessionContext.certificates().setAuthenticateThem(true);
        }
        if (clientCerts != null) {
            sessionContext.certificates().setClientCertificates(clientCerts, password);
            sessionContext.certificates().setAuthenticateMe(true);
        }
        if (credentialsChanged && username != null) {
            Iterator clientsIterator = this.getLogicalSystem().getConfiguration().clients();
            while (clientsIterator.hasNext()) {
                Client client = (Client)clientsIterator.next();
                if (!client.getLogicalSystem().equals(this.getLogicalSystem())) continue;
                try {
                    if (!VersionedFileSystemFactory.hasVersionedFileSystemManager(client.getContext())) continue;
                    IVersionedFileSystemManager vfsManager = VersionedFileSystemFactory.getVersionedFileSystemManager(client.getContext());
                    VersionedFileSystemFactory.releaseVersionedFileSystemManager(vfsManager);
                }
                catch (VfsException e) {
                    LogUtil.logException(LOCATION, e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

