/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.impl.WrongCaseOfFoldernameManager;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncDb;
import java.io.File;
import java.io.IOException;

final class MountPoint
implements IMountPoint {
    private IClient m_client;
    private IRepositoryServer m_repositoryServer;
    private String m_relativeRemoteRoot;
    private String m_relativeLocalRoot;
    private String m_completeLocalRoot;
    private String m_completeRemoteRoot;
    private String m_completeLocalRootNoTrailingFileSeparator;
    private String m_completeRemoteRootNoTrailingSlash;
    private SyncDB m_syncDB = null;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$config$impl$MountPoint == null ? (class$com$tssap$dtr$client$lib$vfs$config$impl$MountPoint = MountPoint.class$("com.tssap.dtr.client.lib.vfs.config.impl.MountPoint")) : class$com$tssap$dtr$client$lib$vfs$config$impl$MountPoint));
    private WrongCaseOfFoldernameManager _wrongCaseOfFoldernameManager;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$config$impl$MountPoint;

    void detachSyncDb() {
        this.m_syncDB = null;
    }

    static String canonicalizeRelativeRemoteRoot(String relativeRemoteRoot) {
        if (relativeRemoteRoot == null) {
            relativeRemoteRoot = "";
        }
        if (relativeRemoteRoot.startsWith("/")) {
            relativeRemoteRoot = relativeRemoteRoot.substring(1);
        }
        if (relativeRemoteRoot.length() > 0 & !relativeRemoteRoot.endsWith("/")) {
            relativeRemoteRoot = relativeRemoteRoot + "/";
        }
        return relativeRemoteRoot;
    }

    static String canonicalizeRelativeLocalRoot(String relativeLocalRoot) {
        if (relativeLocalRoot == null) {
            relativeLocalRoot = "";
        }
        if ((relativeLocalRoot = relativeLocalRoot.replace('/', File.separatorChar)).startsWith(File.separator)) {
            relativeLocalRoot = relativeLocalRoot.substring(File.separator.length());
        }
        if (relativeLocalRoot.length() > 0 & !relativeLocalRoot.endsWith(File.separator)) {
            relativeLocalRoot = relativeLocalRoot + File.separator;
        }
        if (new File(relativeLocalRoot).isAbsolute()) {
            throw new IllegalArgumentException("Parameter 'relativeLocalRoot' must not be absolute.");
        }
        return relativeLocalRoot;
    }

    MountPoint(IClient client, IRepositoryServer repositoryServer, String relativeRemoteRoot, String relativeLocalRoot) {
        this._initClient(client);
        this._initRepositoryServer(repositoryServer);
        this._initRelativeRemoteRoot(relativeRemoteRoot);
        this._initRelativeLocalRoot(relativeLocalRoot);
    }

    private void _initRelativeLocalRoot(String relativeLocalRoot) {
        this.m_relativeLocalRoot = relativeLocalRoot = MountPoint.canonicalizeRelativeLocalRoot(relativeLocalRoot);
        this.m_completeLocalRoot = this.getClient().getAbsoluteLocalRoot() + relativeLocalRoot;
        this.m_completeLocalRootNoTrailingFileSeparator = this.m_completeLocalRoot.substring(0, this.m_completeLocalRoot.length() - 1);
    }

    private void _initRelativeRemoteRoot(String relativeRemoteRoot) {
        this.m_relativeRemoteRoot = relativeRemoteRoot = MountPoint.canonicalizeRelativeRemoteRoot(relativeRemoteRoot);
        this.m_completeRemoteRoot = this.getRepositoryServer().getAbsoluteRemoteRoot() + relativeRemoteRoot;
        this.m_completeRemoteRootNoTrailingSlash = this.m_completeRemoteRoot.substring(0, this.m_completeRemoteRoot.length() - 1);
    }

    private void _initRepositoryServer(IRepositoryServer repositoryServer) {
        if (repositoryServer == null) {
            throw new IllegalArgumentException("Parameter 'repositoryServer' must be non-null.");
        }
        this.m_repositoryServer = repositoryServer;
    }

    private void _initClient(IClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Parameter 'client' must be non-null.");
        }
        this.m_client = client;
    }

    public String toString() {
        return "MountPoint<" + this.m_completeLocalRoot + ">[" + this.getRepositoryServer().getUrl() + ", " + this.getRelativeRemoteRoot() + ", " + this.getRelativeLocalRoot() + "]";
    }

    public IClient getClient() {
        return this.m_client;
    }

    public void assureLocalPathExists() throws ConfigurationException {
        new File(this.m_completeLocalRoot).mkdirs();
    }

    public void assureRemotePathExists() throws ConfigurationException {
        this.getRepositoryServer().assureRemotePathExists(this.m_relativeRemoteRoot);
    }

    public void assureEmptyRemotePathNotExists() throws ConfigurationException {
        this.getRepositoryServer().assureEmptyRemotePathNotExists(this.m_relativeRemoteRoot);
    }

    public String getAbsoluteLocalPath(String absoluteRemotePath) {
        if (!MountPoint.isResponsibleForRemotePath(this, absoluteRemotePath)) {
            return null;
        }
        String relativeRemotePath = "";
        if (absoluteRemotePath.length() > this.m_completeRemoteRootNoTrailingSlash.length()) {
            relativeRemotePath = absoluteRemotePath.substring(this.m_completeRemoteRoot.length());
        }
        String relativeLocalPath = relativeRemotePath.replace('/', File.separatorChar);
        return this.m_completeLocalRoot.concat(relativeLocalPath);
    }

    public String getAbsoluteRemotePath(String absoluteLocalPath) {
        if (!MountPoint.isResponsibleForLocalPath(this, absoluteLocalPath)) {
            return null;
        }
        String relativeLocalPath = "";
        if (absoluteLocalPath.length() > this.m_completeLocalRootNoTrailingFileSeparator.length()) {
            relativeLocalPath = absoluteLocalPath.substring(this.m_completeLocalRoot.length());
        }
        String relativeRemotePath = relativeLocalPath.replace(File.separatorChar, '/');
        return this.m_completeRemoteRoot.concat(relativeRemotePath);
    }

    String getCompleteRemoteRoot() {
        return this.m_completeRemoteRoot;
    }

    String getCompleteLocalRoot() {
        return this.m_completeLocalRoot;
    }

    static boolean isResponsibleForRemotePath(MountPoint mountPoint, String absoluteRemotePath) {
        return absoluteRemotePath.length() == mountPoint.m_completeRemoteRootNoTrailingSlash.length() ? absoluteRemotePath.startsWith(mountPoint.m_completeRemoteRootNoTrailingSlash) : absoluteRemotePath.startsWith(mountPoint.m_completeRemoteRoot);
    }

    static boolean isResponsibleForLocalPath(MountPoint mountPoint, String absoluteLocalPath) {
        return absoluteLocalPath.length() == mountPoint.m_completeLocalRootNoTrailingFileSeparator.length() ? absoluteLocalPath.startsWith(mountPoint.m_completeLocalRootNoTrailingFileSeparator) : absoluteLocalPath.startsWith(mountPoint.m_completeLocalRoot);
    }

    public String getRelativeLocalRoot() {
        return this.m_relativeLocalRoot;
    }

    public String getRelativeRemoteRoot() {
        return this.m_relativeRemoteRoot;
    }

    public IRepositoryServer getRepositoryServer() {
        return this.m_repositoryServer;
    }

    public SyncDB getSyncDb() {
        if (this.m_syncDB == null) {
            this.m_syncDB = SyncDb.open(this.getClient().getConfiguration().getConfigFolder(), this.m_completeLocalRoot, this.getRepositoryServer().getUrl());
            Runtime.getRuntime().addShutdownHook(new Thread("VfsSyncDbOnShutdownPersister"){

                public void run() {
                    MountPoint.this.closeSyncDb();
                }
            });
        }
        return this.m_syncDB;
    }

    void closeSyncDb() {
        if (this.m_syncDB != null) {
            SyncDB syncDB = this.m_syncDB;
            this.m_syncDB = null;
            try {
                syncDB.close();
            }
            catch (IOException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    String resolveWrongAbsoluteLocalFolderpath(String wrongPathToResolve) {
        return this.getWrongCaseOfFoldernameManager().resolveWrongAbsoluteLocalFolderpath(wrongPathToResolve);
    }

    void storeWrongAbsoluteLocalFolderpath(String wrongPathToResolve, String correctMountedPath) {
        this.getWrongCaseOfFoldernameManager().storeWrongAbsoluteLocalFolderpath(wrongPathToResolve, correctMountedPath);
    }

    WrongCaseOfFoldernameManager getWrongCaseOfFoldernameManager() {
        if (this._wrongCaseOfFoldernameManager == null) {
            String mountPointId = SyncDb.getMountPointId(this.getCompleteLocalRoot());
            String filename = mountPointId + ".casefix";
            IVirtualFile configFolder = this.getClient().getConfiguration().getConfigFolder();
            IVirtualFile casefixesFolder = configFolder.getFileService().constructFile(configFolder, ".casefixes");
            IVirtualFile casefixFile = configFolder.getFileService().constructFile(casefixesFolder, filename);
            this._wrongCaseOfFoldernameManager = new WrongCaseOfFoldernameManager(casefixFile);
        }
        return this._wrongCaseOfFoldernameManager;
    }

    public void persistSyncData() throws ConfigurationException {
        try {
            this.getSyncDb().persist();
        }
        catch (IOException e) {
            throw new ConfigurationException("Persisting SyncDB for Mountpoint '" + this.getCompleteLocalRoot() + "' failed: " + e.getMessage(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

