/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.tssap.dtr.client.lib.deltavlib.TemplateProvider;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.templates.ConnectionTemplate;
import com.tssap.dtr.client.lib.vfs.config.IBuildServer;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.impl.BuildServer;
import com.tssap.dtr.client.lib.vfs.config.impl.Configuration;
import com.tssap.dtr.client.lib.vfs.config.impl.RepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.impl.SessionContextBag;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class LogicalSystem
implements ILogicalSystem {
    private Configuration m_configuration;
    private String m_name;
    private Map m_repositoryServersByUrl = new HashMap();
    private Map m_buildServersByUrl = new HashMap();

    LogicalSystem(Configuration configuration, String name) {
        this._initConfiguration(configuration);
        this._initName(name);
    }

    private void _initName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 'name' must be non-null.");
        }
        this.m_name = name;
    }

    private void _initConfiguration(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Parameter 'configuration' must be non-null.");
        }
        this.m_configuration = configuration;
    }

    public String toString() {
        return "LogicalSystem<" + this.getName() + ">";
    }

    public IRepositoryServer addRepositoryServer(IConnectionTemplate template) {
        String serverUrl = template.getUrl();
        if (this.m_repositoryServersByUrl.size() >= 1) {
            throw new IllegalStateException("Only 1 repository server per logical system supported.");
        }
        if (this.m_repositoryServersByUrl.containsKey(SessionContextBag.assureTrailingSlash(serverUrl))) {
            throw new IllegalStateException("Cannot create repository server. Another one with the same URL '" + serverUrl + "' already exists.");
        }
        TemplateProvider templateProvider = Configuration.getTemplateProvider();
        int connectionTemplateId = templateProvider.addConnectionTemplate(template);
        RepositoryServer repositoryServer = new RepositoryServer(this, connectionTemplateId);
        this.m_repositoryServersByUrl.put(serverUrl, repositoryServer);
        return repositoryServer;
    }

    public IRepositoryServer addRepositoryServer(String serverUrl, String userName, String password) throws MalformedURLException {
        KeyStore keyStore;
        if (this.m_repositoryServersByUrl.size() >= 1) {
            throw new IllegalStateException("Only 1 repository server per logical system supported.");
        }
        if (this.m_repositoryServersByUrl.containsKey(SessionContextBag.assureTrailingSlash(serverUrl))) {
            throw new IllegalStateException("Cannot create repository server. Another one with the same URL '" + serverUrl + "' already exists.");
        }
        Configuration configuration = (Configuration)this.getConfiguration();
        if (configuration.isMasterLoginMode()) {
            userName = configuration.getMasterUsername();
            password = configuration.getMasterPassword();
        }
        serverUrl = SessionContextBag.assureTrailingSlash(serverUrl);
        TemplateProvider templateProvider = Configuration.getTemplateProvider();
        SessionContextBag sessionContexts = this.m_configuration.getSessionContexts();
        ISessionContext sessionContext = sessionContexts.createSessionContext(userName, password);
        sessionContext.setUser(userName);
        sessionContext.setPassword(password);
        if (configuration.isMasterLoginMode() && (keyStore = configuration.getServerCerts()) != null) {
            try {
                sessionContext.certificates().setServerCertificates(keyStore);
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException(e.getMessage());
            }
            sessionContext.certificates().setAuthenticateThem(true);
        }
        sessionContexts.setSessionContextForServer(serverUrl, sessionContext);
        IConnectionTemplate connectionTemplate = templateProvider.getConnectionTemplate(serverUrl);
        if (connectionTemplate == null) {
            connectionTemplate = new ConnectionTemplate(serverUrl, sessionContext);
            templateProvider.addConnectionTemplate(connectionTemplate);
        } else if (!LogicalSystem.sameStrings(userName, connectionTemplate.getSessionContext().getUser()) || !LogicalSystem.sameStrings(password, connectionTemplate.getSessionContext().getPassword())) {
            ConnectionTemplate newConnectionTemplate = new ConnectionTemplate(serverUrl, sessionContext);
            templateProvider.replaceConnectionTemplate(connectionTemplate, (IConnectionTemplate)newConnectionTemplate);
        }
        int connectionTemplateId = templateProvider.searchTemplate(connectionTemplate.getUrl())[0];
        RepositoryServer repositoryServer = new RepositoryServer(this, connectionTemplateId);
        this.m_repositoryServersByUrl.put(serverUrl, repositoryServer);
        return repositoryServer;
    }

    static boolean sameStrings(String first, String second) {
        if (first == second) {
            return true;
        }
        if (first == null) {
            return second.equals(first);
        }
        return first.equals(second);
    }

    public String getName() {
        return this.m_name;
    }

    public IRepositoryServer getRepositoryServer(int connectionTemplateId) {
        Iterator iterator = this.m_repositoryServersByUrl.values().iterator();
        while (iterator.hasNext()) {
            IRepositoryServer repositoryServer = (IRepositoryServer)iterator.next();
            if (repositoryServer.getConnectionTemplateId() != connectionTemplateId) continue;
            return repositoryServer;
        }
        return null;
    }

    public IRepositoryServer getRepositoryServer(String serverUrl) {
        return (IRepositoryServer)this.m_repositoryServersByUrl.get(SessionContextBag.assureTrailingSlash(serverUrl));
    }

    public IRepositoryServer removeRepositoryServer(String serverUrl) {
        return (IRepositoryServer)this.m_repositoryServersByUrl.remove(SessionContextBag.assureTrailingSlash(serverUrl));
    }

    public Iterator repositoryServers() {
        return Collections.unmodifiableMap(this.m_repositoryServersByUrl).values().iterator();
    }

    public IBuildServer addBuildServer(String serverUrl, String userName, String password) throws MalformedURLException {
        KeyStore keyStore;
        if (this.m_buildServersByUrl.containsKey(SessionContextBag.assureTrailingSlash(serverUrl))) {
            throw new IllegalStateException("Cannot create build server. Another one with the same URL '" + serverUrl + "' already exists.");
        }
        Configuration configuration = (Configuration)this.getConfiguration();
        if (configuration.isMasterLoginMode()) {
            userName = configuration.getMasterUsername();
            password = configuration.getMasterPassword();
        }
        serverUrl = SessionContextBag.assureTrailingSlash(serverUrl);
        TemplateProvider templateProvider = Configuration.getTemplateProvider();
        SessionContextBag sessionContexts = this.m_configuration.getSessionContexts();
        ISessionContext sessionContext = sessionContexts.createSessionContext(userName, password);
        sessionContext.setUser(userName);
        sessionContext.setPassword(password);
        if (configuration.isMasterLoginMode() && (keyStore = configuration.getServerCerts()) != null) {
            try {
                sessionContext.certificates().setServerCertificates(keyStore);
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException(e.getMessage());
            }
            sessionContext.certificates().setAuthenticateThem(true);
        }
        sessionContexts.setSessionContextForServer(serverUrl, sessionContext);
        IConnectionTemplate connectionTemplate = templateProvider.getConnectionTemplate(serverUrl);
        if (connectionTemplate == null) {
            connectionTemplate = new ConnectionTemplate(serverUrl, sessionContext);
            templateProvider.addConnectionTemplate(connectionTemplate);
        } else if (!LogicalSystem.sameStrings(userName, connectionTemplate.getSessionContext().getUser()) || !LogicalSystem.sameStrings(password, connectionTemplate.getSessionContext().getPassword())) {
            ConnectionTemplate newConnectionTemplate = new ConnectionTemplate(serverUrl, sessionContext);
            templateProvider.replaceConnectionTemplate(connectionTemplate, (IConnectionTemplate)newConnectionTemplate);
        }
        int connectionTemplateId = templateProvider.searchTemplate(connectionTemplate.getUrl())[0];
        BuildServer buildServer = new BuildServer(this, connectionTemplateId);
        this.m_buildServersByUrl.put(serverUrl, buildServer);
        return buildServer;
    }

    public Iterator buildServers() {
        return Collections.unmodifiableMap(this.m_buildServersByUrl).values().iterator();
    }

    public IBuildServer getBuildServer(int connectionTemplateId) {
        Iterator iterator = this.m_buildServersByUrl.values().iterator();
        while (iterator.hasNext()) {
            IBuildServer buildServer = (IBuildServer)iterator.next();
            if (buildServer.getConnectionTemplateId() != connectionTemplateId) continue;
            return buildServer;
        }
        return null;
    }

    public IBuildServer getBuildServer(String serverUrl) {
        return (IBuildServer)this.m_buildServersByUrl.get(SessionContextBag.assureTrailingSlash(serverUrl));
    }

    public IBuildServer removeBuildServer(String serverUrl) {
        return (IBuildServer)this.m_buildServersByUrl.remove(SessionContextBag.assureTrailingSlash(serverUrl));
    }

    public IConfiguration getConfiguration() {
        return this.m_configuration;
    }
}

