/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.VfsFilterType;
import com.tssap.dtr.client.lib.vfs.config.IFilter;

class FolderFilter
implements IFilter {
    final String filterPath;
    final VfsFilterType filterType;

    public String getFilterPath() {
        return PathUtilities.preventTrailingSeparator(this.filterPath, PathUtilities.REMOTE_FILESERVICE);
    }

    public VfsFilterType getFilterType() {
        return this.filterType;
    }

    FolderFilter(String filterPath, VfsFilterType type) {
        if (filterPath == null || type == null) {
            throw new IllegalArgumentException("Filterpath and filter type must be non-null");
        }
        this.filterPath = PathUtilities.assureTrailingSeparator(filterPath, PathUtilities.REMOTE_FILESERVICE);
        this.filterType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FolderFilter)) {
            return false;
        }
        FolderFilter filter = (FolderFilter)o;
        return this.filterPath.equals(filter.filterPath);
    }

    public int hashCode() {
        return this.filterPath.hashCode();
    }

    public String toString() {
        return this.filterType.toString() + " " + this.filterPath;
    }
}

