/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.VfsFilterType;
import com.tssap.dtr.client.lib.vfs.config.impl.FolderFilter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

class FilterManager {
    private final Comparator _comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private final SortedMap _includes = new TreeMap(this._comparator);
    private final SortedMap _readonlies = new TreeMap(this._comparator);
    private final SortedMap _excludes = new TreeMap(this._comparator);
    private final Map _folderFiltersByPath = new HashMap();

    FilterManager() {
    }

    void add(FolderFilter filter) {
        SortedMap target;
        if (filter.filterType == VfsFilterType.INCLUDE) {
            target = this._includes;
        } else if (filter.filterType == VfsFilterType.READONLY) {
            target = this._readonlies;
        } else if (filter.filterType == VfsFilterType.EXCLUDE) {
            target = this._excludes;
        } else {
            throw new IllegalArgumentException("Unknown filter type");
        }
        this._folderFiltersByPath.clear();
        target.put(PathUtilities.assureTrailingSeparator(filter.filterPath, PathUtilities.REMOTE_FILESERVICE), filter);
    }

    VfsFilterType getAccessType(String remoteFolderPath) {
        FolderFilter[] filters = this.getFolderFilters(remoteFolderPath);
        switch (filters.length) {
            case 0: {
                return VfsFilterType.INCLUDE;
            }
            case 1: {
                return filters[0].filterType;
            }
        }
        return VfsFilterType.READONLY;
    }

    private FolderFilter[] getFolderFilters(String remoteFolderPath) {
        if (remoteFolderPath == null) {
            return new FolderFilter[0];
        }
        FolderFilter[] filters = (FolderFilter[])this._folderFiltersByPath.get(remoteFolderPath = PathUtilities.assureTrailingSeparator(remoteFolderPath, PathUtilities.REMOTE_FILESERVICE));
        if (filters == null) {
            FolderFilter include = (FolderFilter)this._includes.get(remoteFolderPath);
            FolderFilter readonly = (FolderFilter)this._readonlies.get(remoteFolderPath);
            FolderFilter exclude = (FolderFilter)this._excludes.get(remoteFolderPath);
            if (include != null) {
                filters = new FolderFilter[]{};
            } else if (readonly != null) {
                filters = new FolderFilter[]{readonly};
            } else if (exclude != null) {
                ArrayList<FolderFilter> mixed = new ArrayList<FolderFilter>();
                mixed.add(exclude);
                mixed.addAll(this._includes.subMap(remoteFolderPath, remoteFolderPath + "\uffff").values());
                mixed.addAll(this._readonlies.subMap(remoteFolderPath, remoteFolderPath + "\uffff").values());
                filters = mixed.toArray(new FolderFilter[mixed.size()]);
            } else {
                filters = this.getFolderFilters(PathUtilities.getParentPath(remoteFolderPath, PathUtilities.REMOTE_FILESERVICE, false));
                ArrayList<FolderFilter> matching = new ArrayList<FolderFilter>(filters.length);
                int i = 0;
                while (i < filters.length) {
                    FolderFilter filter = filters[i];
                    if (filter.filterType == VfsFilterType.EXCLUDE) {
                        matching.add(filter);
                    } else if (filter.filterPath.startsWith(remoteFolderPath)) {
                        matching.add(filter);
                    } else if (filter.filterType == VfsFilterType.READONLY && remoteFolderPath.startsWith(filter.filterPath)) {
                        matching.add(filter);
                    }
                    ++i;
                }
                filters = matching.toArray(new FolderFilter[matching.size()]);
            }
            this._folderFiltersByPath.put(remoteFolderPath, filters);
        }
        return filters;
    }

    Iterator filters() {
        ArrayList list = new ArrayList(this._excludes.size() + this._readonlies.size() + this._includes.size());
        list.addAll(this._excludes.values());
        list.addAll(this._readonlies.values());
        list.addAll(this._includes.values());
        return ((AbstractList)list).iterator();
    }

    int getFilterCount() {
        return this._excludes.size() + this._readonlies.size() + this._includes.size();
    }

    void removeFilters(Class filterClass) {
        this.removeFilters(filterClass, this._includes);
        this.removeFilters(filterClass, this._readonlies);
        this.removeFilters(filterClass, this._excludes);
    }

    private void removeFilters(Class filterClass, Map fromMap) {
        Iterator iterator = fromMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().getClass().equals(filterClass)) continue;
            iterator.remove();
        }
    }
}

