/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.deltavlib.ISessionContextBag;
import com.tssap.dtr.client.lib.deltavlib.TemplateProvider;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.exceptions.ExceptionCategory;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.EnvironmentVariables;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsExceptionCategory;
import com.tssap.dtr.client.lib.vfs.VfsFilterType;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.IBuildServer;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IConfigurationListener;
import com.tssap.dtr.client.lib.vfs.config.IFilter;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.ISettings;
import com.tssap.dtr.client.lib.vfs.config.impl.Client;
import com.tssap.dtr.client.lib.vfs.config.impl.LogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.impl.MountPoint;
import com.tssap.dtr.client.lib.vfs.config.impl.RepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.impl.SessionContextBag;
import com.tssap.dtr.client.lib.vfs.config.impl.Settings;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.fileservice.LocalFileService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class Configuration
implements IConfiguration {
    private static final Location LOCATION;
    private static final IClient[] EMPTY_CLIENT_ARRAY;
    private IFileService _fileService = new LocalFileService();
    private SessionContextBag _sessionContextBag = new SessionContextBag();
    private IVirtualFile m_configFolder;
    private IClient m_activeClient = null;
    private IClient m_defaultClient = null;
    private Map m_clientsByName = new HashMap();
    private Map m_logicalSystemsByName = new HashMap();
    private ISettings m_settings = null;
    private boolean m_isMasterLoginMode = false;
    boolean m_isClientLoginMode = false;
    private String m_masterUsername;
    private String m_masterPassword;
    private KeyStore m_serverCerts;
    private Set m_listeners = new HashSet();
    private static final String LAST_USED_CLIENT_FILENAME = "lastused.client";
    private static final String DEFAULT_SAT_ID = "SAP-SAT";
    private static final String DEFAULT_SAT_LEVEL = "high";
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$config$impl$Configuration;

    String getMasterUsername() {
        return this.m_masterUsername;
    }

    String getMasterPassword() {
        return this.m_masterPassword;
    }

    boolean isMasterLoginMode() {
        return this.m_isMasterLoginMode;
    }

    KeyStore getServerCerts() {
        return this.m_serverCerts;
    }

    public static TemplateProvider getTemplateProvider() {
        return ConnectionPool.getTemplateProvider();
    }

    public SessionContextBag getSessionContexts() {
        return this._sessionContextBag;
    }

    public ISessionContextBag getSessionContextBag() {
        return this._sessionContextBag;
    }

    public Configuration(final IVirtualFile configFolder) {
        this._initConfigFolder(configFolder);
        String METHOD = "<init>";
        LOCATION.debugT("<init>", "Creating new configuration instance ''{0}'' using config folder ''{1}''.", new Object[]{this, configFolder});
        this._depersistAll();
        final BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new ByteArrayOutputStream(1));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                boolean b = bufferedOutputStream.equals(null);
                IClient activeClient = Configuration.this.m_activeClient;
                try {
                    IVirtualFile file = Configuration.this._fileService.constructFile(configFolder, Configuration.LAST_USED_CLIENT_FILENAME);
                    if (activeClient != null) {
                        BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(Configuration.this._fileService.constructFileOutputStream(file));
                        bufferedOutputStream2.write(activeClient.getName().getBytes());
                        bufferedOutputStream2.flush();
                    } else {
                        file.delete();
                    }
                }
                catch (IOException e) {
                    LOCATION.errorT("<init>", "Failed to persist last used client (only name) using config folder ''{1}''.", new Object[]{configFolder});
                }
            }
        });
    }

    private void _depersistAll() {
        SessionContextBag sessionContexts = this._sessionContextBag;
        this.depersistSessionContexts(sessionContexts);
        this.depersistConnectionTemplates();
        this.depersistLogicalSystems(sessionContexts);
        ClientPersistance clientPersistance = new ClientPersistance(this, this.m_configFolder);
        clientPersistance.depersist();
        IClient[] depersistedClients = this.getClients();
        int i = 0;
        while (i < depersistedClients.length) {
            IClient client = depersistedClients[i];
            try {
                Client.checkClientFilter(client.getClientFilter());
            }
            catch (ConfigurationException e) {
                new VfsRuntimeException((ExceptionCategory)VfsExceptionCategory.CLIENT_FILTER_TOO_LONG, new Object[]{new Integer(client.getClientFilter().length()), client.getName(), new Integer(255)}, new Throwable[]{e});
                this.deleteClient(client.getName());
            }
            ++i;
        }
        try {
            String clientName;
            IClient client;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this._fileService.constructFileInputStream(this._fileService.constructFile(this.m_configFolder, LAST_USED_CLIENT_FILENAME)));
            byte[] clientNameAsBytes = new byte[1024];
            int length = bufferedInputStream.read(clientNameAsBytes);
            if (length > 0 && (client = this.getClient(clientName = new String(clientNameAsBytes, 0, length).trim())) != null) {
                this.setActiveClient(client);
            }
        }
        catch (IOException ignore) {
            String METHOD = "_depersistAll";
            LOCATION.warningT("_depersistAll", "Could not depersist last used client name (only name)");
        }
    }

    private void _initConfigFolder(IVirtualFile configFolder) {
        if (configFolder == null) {
            throw new IllegalArgumentException("Parameter 'configFolder' must be non-null.");
        }
        if (!configFolder.exists() || !configFolder.isDirectory()) {
            throw new IllegalArgumentException("Parameter 'configFolder' must be an existing folder.");
        }
        this.m_configFolder = configFolder;
        this._fileService = configFolder.getFileService();
    }

    public String toString() {
        return "Configuration<" + this.getConfigFolder() + ">";
    }

    private void depersistLogicalSystems(SessionContextBag sessionContexts) {
        LogicalSystemPersistance logicalSystemPersistance = new LogicalSystemPersistance(this, this.m_configFolder, sessionContexts);
        ILogicalSystem[] logicalSystems = logicalSystemPersistance.depersist();
        int i = 0;
        while (i < logicalSystems.length) {
            ILogicalSystem logicalSystem = logicalSystems[i];
            this.m_logicalSystemsByName.put(logicalSystem.getName(), logicalSystem);
            ++i;
        }
    }

    private void depersistConnectionTemplates() {
        IVirtualFile persistedConnectionTemplates = this._fileService.constructFile(this.m_configFolder, "servers.xml");
        try {
            LOCATION.pathT("Depersisting connection templates using file ''{0}''.", new Object[]{persistedConnectionTemplates});
            Configuration.getTemplateProvider().depersist(this._fileService.constructFileInputStream(persistedConnectionTemplates), this.getSessionContexts());
        }
        catch (FileNotFoundException e) {
            LOCATION.infoT("No servers.xml found.");
        }
    }

    private void depersistSessionContexts(SessionContextBag sessionContexts) {
        IVirtualFile persistedSessionContexts = this._fileService.constructFile(this.m_configFolder, "user.xml");
        try {
            LOCATION.pathT("Depersisting session contexts using file ''{0}''.", new Object[]{persistedSessionContexts});
            sessionContexts.depersist(this._fileService.constructFileInputStream(persistedSessionContexts));
        }
        catch (FileNotFoundException e) {
            LOCATION.infoT("No user.xml found. OK, when working with master login.");
        }
    }

    public IVirtualFile getConfigFolder() {
        return this.m_configFolder;
    }

    public Iterator clients() {
        return Collections.unmodifiableMap(this.m_clientsByName).values().iterator();
    }

    private IClient[] getClients() {
        return this.m_clientsByName.values().toArray(EMPTY_CLIENT_ARRAY);
    }

    public synchronized IClient createClient(String name, String absoluteLocalRoot, ILogicalSystem logicalSystem) {
        LOCATION.debugT("Creating client with name ''{0}'' using local root ''{1}'' and logical system ''{2}''.", new Object[]{name, absoluteLocalRoot, logicalSystem});
        if (this.m_clientsByName.containsKey(name)) {
            throw new IllegalStateException("Cannot create client, another client with the same name '" + name + "' already exists.");
        }
        Client client = new Client(this, name, absoluteLocalRoot, logicalSystem);
        this.m_clientsByName.put(name, client);
        return client;
    }

    public synchronized void deleteClientForcedWithNoMercy(String name) {
        Client clientToDelete = (Client)this.getClient(name);
        if (clientToDelete == null) {
            throw new IllegalArgumentException("No such client");
        }
        String METHOD = "deleteClientForcedWithNoMercy";
        LOCATION.debugT("deleteClientForcedWithNoMercy", "Deleting client \"{0}\".", new Object[]{name});
        MountPoint[] mountPoints = clientToDelete.getMountPoints();
        int i = 0;
        while (i < mountPoints.length) {
            MountPoint mountPoint = mountPoints[i];
            clientToDelete.deleteMountPoints(new IMountPoint[]{mountPoint}, true, true);
            ++i;
        }
        ILogicalSystem logicalSystem = clientToDelete.getLogicalSystem();
        this.removeLogicalSystem(logicalSystem);
        this.deleteClient(name);
    }

    public synchronized IClient deleteClient(String name) {
        String METHOD = "deleteClient";
        LOCATION.debugT("deleteClient", "Deleting client \"{0}\".", new Object[]{name});
        IClient client = (IClient)this.m_clientsByName.remove(name);
        if (this.m_activeClient != null && this.m_activeClient.getName().equals(name)) {
            this.setActiveClient(null);
        }
        if (this.m_defaultClient != null && this.m_defaultClient.getName().equals(name)) {
            this.setDefaultClient(null);
        }
        return client;
    }

    public IClient getActiveClient() {
        if (this.m_activeClient == null) {
            if (this.m_defaultClient != null) {
                this.setActiveClient(this.m_defaultClient);
            } else if (this.m_clientsByName.size() > 0) {
                this.setActiveClient((IClient)this.m_clientsByName.values().iterator().next());
            }
        }
        return this.m_activeClient;
    }

    public IClient getClient(String name) {
        return (IClient)this.m_clientsByName.get(name);
    }

    public void setActiveClient(IClient client) {
        LOCATION.debugT("Setting active client from ''{0}'' to ''{1}''.", new Object[]{this.m_activeClient, client});
        if (this.m_activeClient == client) {
            return;
        }
        IClient oldClient = this.m_activeClient;
        this.m_activeClient = client;
        Iterator iterator = this.m_listeners.iterator();
        while (iterator.hasNext()) {
            IConfigurationListener listener = (IConfigurationListener)iterator.next();
            try {
                listener.onActiveClientChanged(client, oldClient);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    public synchronized ILogicalSystem createLogicalSystem(String name) {
        LOCATION.debugT("Creating logical system with name ''{0}''.", new Object[]{name});
        if (this.m_logicalSystemsByName.containsKey(name)) {
            throw new IllegalStateException("Cannot create logical system, another logical system with the same name '" + name + "' already exists.");
        }
        LogicalSystem logicalSystem = new LogicalSystem(this, name);
        this.m_logicalSystemsByName.put(name, logicalSystem);
        return logicalSystem;
    }

    public ILogicalSystem getLogicalSystem(String name) {
        return (ILogicalSystem)this.m_logicalSystemsByName.get(name);
    }

    public Iterator logicalSystems() {
        return Collections.unmodifiableMap(this.m_logicalSystemsByName).values().iterator();
    }

    public void saveAll() throws IOException {
        long start = System.currentTimeMillis();
        try {
            this._persistConnectionTemplates();
            this._persistSessionContexts();
            this._persistLogicalSystems();
            this._persistClients();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            long elapsed = System.currentTimeMillis() - start;
            LogUtil.logElapsedTime((long)elapsed, (String)"Configuration.saveAll()");
            throw throwable;
        }
        long elapsed = System.currentTimeMillis() - start;
        LogUtil.logElapsedTime((long)elapsed, (String)"Configuration.saveAll()");
    }

    private void _persistClients() throws IOException {
        ClientPersistance persistance = new ClientPersistance(this, this.getConfigFolder());
        persistance.persist(this.m_clientsByName.values().iterator());
    }

    private void _persistLogicalSystems() {
        LogicalSystemPersistance persistance = new LogicalSystemPersistance(this, this.getConfigFolder(), this.getSessionContexts());
        persistance.persist(this.m_logicalSystemsByName.values());
    }

    private void _persistSessionContexts() {
        if (this.m_isMasterLoginMode) {
            LOCATION.infoT("Master login mode switched on - skipping persisting of session contexts.");
            return;
        }
        try {
            this.getSessionContexts().persist(this._fileService.constructFileOutputStream(this._fileService.constructFile(this.getConfigFolder(), "user.xml")));
        }
        catch (IOException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    private void _persistConnectionTemplates() {
        try {
            Configuration.getTemplateProvider().persist(this._fileService.constructFileOutputStream(this._fileService.constructFile(this.getConfigFolder(), "servers.xml")));
        }
        catch (IOException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    public synchronized ILogicalSystem removeLogicalSystem(ILogicalSystem logicalSystem) {
        String METHOD = "removeLogicalSystem";
        LOCATION.debugT("removeLogicalSystem", "Deleting logical system \"{0}\".", new Object[]{logicalSystem});
        return (ILogicalSystem)this.m_logicalSystemsByName.remove(logicalSystem.getName());
    }

    public ISettings getSettings() {
        if (this.m_settings == null) {
            this.m_settings = new Settings(this);
        }
        return this.m_settings;
    }

    public boolean isMasterLogin() {
        return this.m_isMasterLoginMode;
    }

    public boolean isClientLogin() {
        return this.m_isClientLoginMode;
    }

    public void setMasterLogin(String username, String password) {
        try {
            this.setMasterLogin(username, password, null, null);
        }
        catch (KeyStoreException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    void setDontUseUserXml() {
        this.m_isMasterLoginMode = true;
    }

    public void setMasterLogin(String username, String password, KeyStore serverCerts, KeyStore clientCerts) throws KeyStoreException {
        if (this.m_isClientLoginMode) {
            throw new IllegalStateException("VFS currently operates in client-login mode. Use IClient.setCredentials().");
        }
        boolean credentialsChanged = true;
        if (this.m_isMasterLoginMode && LogicalSystem.sameStrings(username, this.m_masterUsername) && LogicalSystem.sameStrings(password, this.m_masterPassword) && (serverCerts == null && this.m_serverCerts == null || serverCerts != null && serverCerts.equals(this.m_serverCerts))) {
            credentialsChanged = false;
        }
        this.m_isMasterLoginMode = true;
        this.m_masterUsername = username;
        this.m_masterPassword = password;
        this.m_serverCerts = serverCerts;
        TemplateProvider provider = Configuration.getTemplateProvider();
        Iterator iter = provider.iterator();
        while (iter.hasNext()) {
            ISessionContext ctx = ((IConnectionTemplate)iter.next()).getSessionContext();
            ctx.setUser(this.m_masterUsername);
            ctx.setPassword(this.m_masterPassword);
            if (serverCerts != null) {
                ctx.certificates().setServerCertificates(serverCerts);
                ctx.certificates().setAuthenticateThem(true);
            }
            if (clientCerts == null) continue;
            ctx.certificates().setClientCertificates(clientCerts, password);
            ctx.certificates().setAuthenticateMe(true);
        }
        if (credentialsChanged && username != null) {
            Iterator clientsIterator = this.clients();
            while (clientsIterator.hasNext()) {
                Client client = (Client)clientsIterator.next();
                try {
                    if (!VersionedFileSystemFactory.hasVersionedFileSystemManager(client.getContext())) continue;
                    IVersionedFileSystemManager vfsManager = VersionedFileSystemFactory.getVersionedFileSystemManager(client.getContext());
                    VersionedFileSystemFactory.releaseVersionedFileSystemManager(vfsManager);
                }
                catch (VfsException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            }
        }
    }

    public IClient getDefaultClient() {
        return this.m_defaultClient;
    }

    public void setDefaultClient(IClient client) {
        this.m_defaultClient = client;
    }

    public void addConfigurationListener(IConfigurationListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeConfigurationListener(IConfigurationListener listener) {
        this.m_listeners.remove(listener);
    }

    public Object repositoryServers() {
        throw new UnsupportedOperationException();
    }

    public void setSingleActivityTrace(boolean on) {
        if (on) {
            Iterator logicalSystemsIterator = this.logicalSystems();
            while (logicalSystemsIterator.hasNext()) {
                LogicalSystem logicalSystem = (LogicalSystem)logicalSystemsIterator.next();
                Iterator repositoryServerIterator = logicalSystem.repositoryServers();
                while (repositoryServerIterator.hasNext()) {
                    RepositoryServer repositoryServer = (RepositoryServer)repositoryServerIterator.next();
                    try {
                        ConnectionPool.enableSingleActivityTrace(repositoryServer.getConnectionTemplateId(), DEFAULT_SAT_ID, DEFAULT_SAT_LEVEL);
                    }
                    catch (VcmFailure e) {
                        LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
                    }
                }
            }
        } else {
            Iterator logicalSystemsIterator = this.logicalSystems();
            while (logicalSystemsIterator.hasNext()) {
                LogicalSystem logicalSystem = (LogicalSystem)logicalSystemsIterator.next();
                Iterator repositoryServerIterator = logicalSystem.repositoryServers();
                while (repositoryServerIterator.hasNext()) {
                    RepositoryServer repositoryServer = (RepositoryServer)repositoryServerIterator.next();
                    try {
                        ConnectionPool.disableSingleActivityTrace(repositoryServer.getConnectionTemplateId());
                    }
                    catch (VcmFailure e) {
                        LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        File logProperties;
        LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$config$impl$Configuration == null ? (class$com$tssap$dtr$client$lib$vfs$config$impl$Configuration = Configuration.class$("com.tssap.dtr.client.lib.vfs.config.impl.Configuration")) : class$com$tssap$dtr$client$lib$vfs$config$impl$Configuration));
        EMPTY_CLIENT_ARRAY = new IClient[0];
        String loggingPropertiesFile = EnvironmentVariables.LOGGING_PROPERTIES_FILE;
        if (loggingPropertiesFile != null && (logProperties = new File(loggingPropertiesFile)).exists() && logProperties.isFile()) {
            PropertiesConfigurator p = new PropertiesConfigurator(new File(loggingPropertiesFile));
            p.configure();
        }
    }

    private static class ClientPersistance {
        private static final String CLIENTS = "clients";
        private static final String CLIENT = "client";
        private static final String MOUNTPOINTS = "mountPoints";
        private static final String MOUNTPOINT = "mountPoint";
        private static final String NAME = "name";
        private static final String ABSOLUTE_LOCAL_ROOT = "absoluteLocalRoot";
        private static final String LOGICAL_SYSTEM = "logicalSystem";
        private static final String CLIENT_FILTER = "clientFilter";
        private static final String ACTIVE = "active";
        private static final String URL = "repositoryServerUrl";
        private static final String RELATIVE_REMOTE_ROOT = "relativeRemoteRoot";
        private static final String RELATIVE_LOCAL_ROOT = "relativeLocalRoot";
        private Configuration m_configuration;
        private IVirtualFile m_configFolder;

        ClientPersistance(Configuration configuration, IVirtualFile configFolder) {
            this._initConfiguration(configuration);
            this._initConfigFolder(configFolder);
        }

        private void _initConfigFolder(IVirtualFile configFolder) {
            if (configFolder == null) {
                throw new IllegalArgumentException("Parameter 'configFolder' must be non-null.");
            }
            if (!configFolder.exists() || !configFolder.isDirectory()) {
                throw new IllegalArgumentException("Parameter 'configFolder' must be an existing folder.");
            }
            this.m_configFolder = configFolder;
        }

        private void _initConfiguration(Configuration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException("Parameter 'configuration' must be non-null.");
            }
            this.m_configuration = configuration;
        }

        IClient[] depersist() {
            IVirtualFile clientsFile = this.m_configFolder.getFileService().constructFile(this.m_configFolder, "clients.xml");
            DepersistHandler handler = new DepersistHandler(this.m_configuration);
            try {
                InputSource inputSource = new InputSource(this.m_configFolder.getFileService().constructFileInputStream(clientsFile));
                XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                parser.setContentHandler(handler);
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                LOCATION.pathT("Depersisting clients... from file ''{0}''.", new Object[]{clientsFile});
                parser.parse(inputSource);
                LOCATION.pathT("Depersisting clients... done.", new Object[0]);
            }
            catch (FileNotFoundException x) {
                LogUtil.infoLogException((Location)LOCATION, (Throwable)x, (boolean)false);
                LOCATION.infoT("Depersisting clients skipped (''{0}'' file not found).", new Object[]{"clients.xml"});
            }
            catch (Exception x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
                LOCATION.pathT("Depersisting clients... done with problems.", new Object[0]);
            }
            return handler.getDepersistedClients();
        }

        void persist(Iterator clients) throws IOException {
            IVirtualFile clientsFile = this.m_configFolder.getFileService().constructFile(this.m_configFolder, "clients.xml");
            LOCATION.pathT("Persisting clients... from ''{0}'' to ''{1}''.", new Object[]{this.m_configuration, clientsFile});
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.m_configFolder.getFileService().constructFileOutputStream(clientsFile)));
                bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bufferedWriter.newLine();
                bufferedWriter.write("<clients>");
                bufferedWriter.newLine();
                boolean defaultClientDone = false;
                while (clients.hasNext()) {
                    IClient client = (IClient)clients.next();
                    defaultClientDone = this._persistClient(bufferedWriter, client, defaultClientDone);
                }
                if (!defaultClientDone && this.m_configuration.getDefaultClient() != null) {
                    this._persistClient(bufferedWriter, this.m_configuration.getDefaultClient(), defaultClientDone);
                }
                bufferedWriter.newLine();
                bufferedWriter.write("</clients>");
                bufferedWriter.close();
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                LOCATION.pathT("Persisting clients... done.", new Object[0]);
                throw throwable;
            }
            LOCATION.pathT("Persisting clients... done.", new Object[0]);
        }

        private boolean _persistClient(BufferedWriter bufferedWriter, IClient client, boolean defaultClientDone) throws IOException {
            bufferedWriter.newLine();
            bufferedWriter.write("\t<client");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tname=\"" + client.getName() + "\"");
            bufferedWriter.newLine();
            String clientFilter = client.getClientFilter();
            if (clientFilter == null) {
                clientFilter = "";
            }
            bufferedWriter.write("\t\tclientFilter=\"" + clientFilter + "\"");
            bufferedWriter.newLine();
            if (!defaultClientDone && this.m_configuration.getDefaultClient() == client) {
                bufferedWriter.write("\t\tactive=\"true\"");
                defaultClientDone = true;
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t\tabsoluteLocalRoot=\"" + client.getAbsoluteLocalRoot() + "\"");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tlogicalSystem=\"" + client.getLogicalSystem().getName() + "\" >");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t<mountPoints>");
            bufferedWriter.newLine();
            Iterator mountPoints = client.mountPoints();
            while (mountPoints.hasNext()) {
                IMountPoint mountPoint = (IMountPoint)mountPoints.next();
                bufferedWriter.newLine();
                bufferedWriter.write("\t\t\t<mountPoint");
                bufferedWriter.newLine();
                bufferedWriter.write("\t\t\t\trepositoryServerUrl=\"" + mountPoint.getRepositoryServer().getUrl() + "\"");
                bufferedWriter.newLine();
                bufferedWriter.write("\t\t\t\trelativeRemoteRoot=\"" + mountPoint.getRelativeRemoteRoot() + "\"");
                bufferedWriter.newLine();
                bufferedWriter.write("\t\t\t\trelativeLocalRoot=\"" + mountPoint.getRelativeLocalRoot() + "\" />");
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t</mountPoints>");
            bufferedWriter.newLine();
            bufferedWriter.write("\t</client>");
            bufferedWriter.newLine();
            return defaultClientDone;
        }

        private class DepersistHandler
        extends DefaultHandler {
            private static final int START_STATE = 0;
            private static final int CLIENTS_STATE = 1;
            private static final int CLIENT_STATE = 2;
            private static final int MOUNTPOINTS_STATE = 3;
            private static final int MOUNTPOINT_STATE = 4;
            private static final int END_STATE = 5;
            private int m_state = 0;
            private Configuration m_configuration;
            private LinkedList m_depersistedClients = new LinkedList();
            private IClient m_currentlyParsedClient = null;

            DepersistHandler(Configuration configuration) {
                this._initConfiguration(configuration);
            }

            private void _initConfiguration(Configuration configuration) {
                if (configuration == null) {
                    throw new IllegalArgumentException("Parameter 'configuration' must be non-null.");
                }
                this.m_configuration = configuration;
            }

            IClient[] getDepersistedClients() {
                return this.m_depersistedClients.toArray(new IClient[this.m_depersistedClients.size()]);
            }

            public void startElement(String namespaceURI, String localName, String rawName, Attributes attributes) {
                try {
                    switch (this.m_state) {
                        case 0: {
                            if (localName.equalsIgnoreCase(ClientPersistance.CLIENTS)) {
                                LOCATION.pathT("Depersisting clients... found ''{0}''.", new Object[]{ClientPersistance.CLIENTS});
                                this.m_state = 1;
                                break;
                            }
                            LOCATION.warningT("Invalid XML detected: expected ''{0}'', found ''{1}''.", new Object[]{ClientPersistance.CLIENTS, localName});
                            break;
                        }
                        case 1: {
                            if (localName.equalsIgnoreCase(ClientPersistance.CLIENT)) {
                                IClient client;
                                String logicalSystemName;
                                String clientName = attributes.getValue(ClientPersistance.NAME);
                                if (clientName == null || clientName.length() == 0) {
                                    LOCATION.warningT("Invalid XML detected: no attribute ''{0}'' found.", new Object[]{ClientPersistance.NAME});
                                    break;
                                }
                                LOCATION.pathT("Depersisting clients... found ''{0}'' with name ''{1}''.", new Object[]{ClientPersistance.CLIENT, clientName});
                                String absoluteLocalRoot = attributes.getValue(ClientPersistance.ABSOLUTE_LOCAL_ROOT);
                                if (absoluteLocalRoot == null || absoluteLocalRoot.length() == 0) {
                                    LOCATION.warningT("Invalid XML detected: no attribute ''{0}'' found.", new Object[]{ClientPersistance.ABSOLUTE_LOCAL_ROOT});
                                    break;
                                }
                                String separator = ClientPersistance.this.m_configFolder.getFileService().getSeparator();
                                if (absoluteLocalRoot.length() > 0 & !absoluteLocalRoot.endsWith(separator)) {
                                    absoluteLocalRoot = absoluteLocalRoot + separator;
                                }
                                if ((logicalSystemName = attributes.getValue(ClientPersistance.LOGICAL_SYSTEM)) == null || logicalSystemName.length() == 0) {
                                    LOCATION.warningT("Invalid XML detected: no attribute ''{0}'' found.", new Object[]{ClientPersistance.LOGICAL_SYSTEM});
                                    break;
                                }
                                ILogicalSystem logicalSystem = this.m_configuration.getLogicalSystem(logicalSystemName);
                                if (logicalSystem == null) {
                                    LOCATION.warningT("No logical system found with name ''{0}''.", new Object[]{logicalSystemName});
                                    break;
                                }
                                String clientFilter = attributes.getValue(ClientPersistance.CLIENT_FILTER);
                                if (clientFilter == null || clientFilter.trim().length() == 0) {
                                    LOCATION.debugT("No clientFilter specified, OK.");
                                    clientFilter = null;
                                } else {
                                    clientFilter = clientFilter.trim();
                                    LOCATION.debugT("Found clientFilter with name ''{0}''.", new Object[]{clientFilter});
                                }
                                try {
                                    client = this.m_configuration.createClient(clientName, absoluteLocalRoot, logicalSystem);
                                }
                                catch (IllegalArgumentException e) {
                                    Logbook.getErrorChapter().println(e.getMessage());
                                    throw e;
                                }
                                catch (IllegalStateException e) {
                                    Logbook.getWarnChapter().println(e.getMessage());
                                    Logbook.getWarnChapter().println("Using existing client.");
                                    client = this.m_configuration.getClient(clientName);
                                }
                                this.m_currentlyParsedClient = client;
                                ((Client)client).pureSetClientFilter(clientFilter);
                                String active = attributes.getValue(ClientPersistance.ACTIVE);
                                if (Boolean.valueOf(active).booleanValue()) {
                                    this.m_configuration.setDefaultClient(client);
                                } else if (this.m_configuration.getDefaultClient() == null) {
                                    this.m_configuration.setDefaultClient(client);
                                }
                                this.m_state = 2;
                                break;
                            }
                            LOCATION.warningT("Invalid XML detected: expected ''{0}'', found ''{1}''.", new Object[]{ClientPersistance.CLIENT, localName});
                            break;
                        }
                        case 2: {
                            if (localName.equalsIgnoreCase(ClientPersistance.MOUNTPOINTS)) {
                                LOCATION.pathT("Depersisting clients... found ''{0}''.", new Object[]{ClientPersistance.MOUNTPOINTS});
                                this.m_state = 3;
                                break;
                            }
                            LOCATION.warningT("Invalid XML detected: expected ''{0}'', found ''{1}''.", new Object[]{ClientPersistance.MOUNTPOINTS, localName});
                            break;
                        }
                        case 3: {
                            if (localName.equalsIgnoreCase(ClientPersistance.MOUNTPOINT)) {
                                String serverUrl = SessionContextBag.assureTrailingSlash(attributes.getValue(ClientPersistance.URL));
                                if (serverUrl == null || serverUrl.length() == 0) {
                                    LOCATION.warningT("Invalid XML detected: no attribute ''{0}'' found.", new Object[]{ClientPersistance.URL});
                                    break;
                                }
                                String relativeRemoteRoot = MountPoint.canonicalizeRelativeRemoteRoot(attributes.getValue(ClientPersistance.RELATIVE_REMOTE_ROOT));
                                String relativeLocalRoot = MountPoint.canonicalizeRelativeLocalRoot(attributes.getValue(ClientPersistance.RELATIVE_LOCAL_ROOT));
                                LOCATION.pathT("Depersisting clients... found ''{0}'' for server ''{1}'' relatively mapping remote ''{2}'' to local ''{3}''.", new Object[]{ClientPersistance.MOUNTPOINT, serverUrl, relativeRemoteRoot, relativeLocalRoot});
                                ILogicalSystem logicalSystem = this.m_currentlyParsedClient.getLogicalSystem();
                                IRepositoryServer repositoryServer = logicalSystem.getRepositoryServer(serverUrl);
                                if (repositoryServer == null) {
                                    LOCATION.pathT("Depersisting clients... requested repository server ''{0}'' not contained in logical system ''{1}''.", new Object[]{serverUrl, logicalSystem});
                                    break;
                                }
                                IMountPoint mountPoint = this.m_currentlyParsedClient.getMountPointForLocalPath(this.m_currentlyParsedClient.getAbsoluteLocalRoot() + relativeLocalRoot);
                                if (mountPoint != null) {
                                    if (!(mountPoint.getRepositoryServer().getUrl().equals(repositoryServer.getUrl()) && mountPoint.getRelativeRemoteRoot().equals(relativeRemoteRoot) && mountPoint.getRelativeLocalRoot().equals(relativeLocalRoot))) {
                                        LOCATION.warningT("A mountpoint with different properties already exists. Cannot modify existing.", new Object[0]);
                                    }
                                } else {
                                    try {
                                        this.m_currentlyParsedClient.createMountPoint(repositoryServer, relativeRemoteRoot, relativeLocalRoot);
                                    }
                                    catch (IllegalStateException e) {
                                        LOCATION.warningT("Another mount point exists that covers the one to create while depersisting. Skipping creation of mount point.", new Object[0]);
                                    }
                                }
                                this.m_state = 4;
                                break;
                            }
                            LOCATION.warningT("Invalid XML detected: expected ''{0}'', found ''{1}''.", new Object[]{ClientPersistance.MOUNTPOINT, localName});
                        }
                    }
                }
                catch (Exception e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            }

            public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
                switch (this.m_state) {
                    case 1: {
                        if (localName.equalsIgnoreCase(ClientPersistance.CLIENTS)) {
                            this.m_state = 5;
                            break;
                        }
                        LOCATION.warningT("Invalid closing XML detected: expected ''{0}'', found ''{1}''.", new Object[]{ClientPersistance.CLIENTS, localName});
                        break;
                    }
                    case 2: {
                        if (localName.equalsIgnoreCase(ClientPersistance.CLIENT)) {
                            this.m_state = 1;
                            break;
                        }
                        LOCATION.warningT("Invalid closing XML detected: expected ''{0}'', found ''{1}''.", new Object[]{ClientPersistance.CLIENT, localName});
                        break;
                    }
                    case 3: {
                        if (localName.equalsIgnoreCase(ClientPersistance.MOUNTPOINTS)) {
                            this.m_state = 2;
                            break;
                        }
                        LOCATION.warningT("Invalid closing XML detected: expected ''{0}'', found ''{1}''.", new Object[]{ClientPersistance.MOUNTPOINTS, localName});
                        break;
                    }
                    case 4: {
                        if (localName.equalsIgnoreCase(ClientPersistance.MOUNTPOINT)) {
                            this.m_state = 3;
                            break;
                        }
                        LOCATION.warningT("Invalid closing XML detected: expected ''{0}'', found ''{1}''.", new Object[]{ClientPersistance.MOUNTPOINT, localName});
                    }
                }
            }
        }
    }

    private static class LogicalSystemPersistance {
        private static final String SYSTEM = "system";
        private static final String REPOSITORY_SERVERS = "repositoryServers";
        private static final String REPOSITORY_SERVER = "repositoryServer";
        private static final String BUILD_SERVERS = "buildServers";
        private static final String BUILD_SERVER = "buildServer";
        private static final String FILTERS = "filters";
        private static final String INCLUDE = "include";
        private static final String READONLY = "readonly";
        private static final String EXCLUDE = "exclude";
        private static final String NAME = "name";
        private static final String URL = "url";
        private static final String FOLDER = "folder";
        private static final String WORKSPACE = "workspace";
        private IConfiguration m_configuration;
        private IVirtualFile m_configFolder;
        private SessionContextBag m_sessionContexts;
        static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$config$impl$WorkspaceFilter;

        LogicalSystemPersistance(IConfiguration configuration, IVirtualFile configFolder, SessionContextBag sessionContexts) {
            this._initConfiguration(configuration);
            this._initConfigFolder(configFolder);
            this._initSessionContexts(sessionContexts);
        }

        private void _initSessionContexts(SessionContextBag sessionContexts) {
            if (sessionContexts == null) {
                throw new IllegalArgumentException("Parameter 'sessionContexts' must be non-null.");
            }
            this.m_sessionContexts = sessionContexts;
        }

        private void _initConfigFolder(IVirtualFile configFolder) {
            if (configFolder == null) {
                throw new IllegalArgumentException("Parameter 'configFolder' must be non-null.");
            }
            if (!configFolder.exists() || !configFolder.isDirectory()) {
                throw new IllegalArgumentException("Parameter 'configFolder' must be an existing folder.");
            }
            this.m_configFolder = configFolder;
        }

        private void _initConfiguration(IConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException("Parameter 'configuration' must be non-null.");
            }
            this.m_configuration = configuration;
        }

        ILogicalSystem[] depersist() {
            LOCATION.pathT("Depersisting all logical systems from folder ''{0}''.", new Object[]{this.m_configFolder});
            IVirtualFile[] files = this.m_configFolder.listFiles();
            ArrayList<ILogicalSystem> logicalSystems = new ArrayList<ILogicalSystem>(files.length);
            int i = 0;
            while (i < files.length) {
                ILogicalSystem logicalSystem;
                IVirtualFile systemFile = files[i];
                if (systemFile.getName().endsWith(".system") && (logicalSystem = this.depersistLogicalSystemFile(systemFile)) != null) {
                    logicalSystems.add(logicalSystem);
                }
                ++i;
            }
            return logicalSystems.toArray(new ILogicalSystem[logicalSystems.size()]);
        }

        void persist(Collection logicalSystems) {
            LOCATION.pathT("Persisting logical systems... from ''{0}'' to ''{1}''.", new Object[]{this.m_configuration, this.m_configFolder});
            IVirtualFile[] files = this.m_configFolder.listFiles();
            HashMap<String, IVirtualFile> persistedLogicalSystems = new HashMap<String, IVirtualFile>(files.length);
            int i = 0;
            while (i < files.length) {
                IVirtualFile systemFile = files[i];
                if (systemFile.getName().endsWith(".system")) {
                    persistedLogicalSystems.put(systemFile.getName(), systemFile);
                }
                ++i;
            }
            Iterator systems = logicalSystems.iterator();
            while (systems.hasNext()) {
                ILogicalSystem system = (ILogicalSystem)systems.next();
                String fileName = system.getName() + ".system";
                if (!persistedLogicalSystems.containsKey(fileName)) continue;
                persistedLogicalSystems.remove(fileName);
            }
            Iterator systemsToDelete = persistedLogicalSystems.values().iterator();
            while (systemsToDelete.hasNext()) {
                IVirtualFile systemToDelete = (IVirtualFile)systemsToDelete.next();
                systemToDelete.delete();
            }
            Iterator systems2 = logicalSystems.iterator();
            while (systems2.hasNext()) {
                ILogicalSystem logicalSystem = (ILogicalSystem)systems2.next();
                this._persistLogicalSystem(logicalSystem);
            }
            LOCATION.pathT("Persisting logical systems... done.", new Object[0]);
        }

        private void _persistLogicalSystem(ILogicalSystem logicalSystem) {
            IVirtualFile logicalSystemFile = this.m_configFolder.getFileService().constructFile(this.m_configFolder, logicalSystem.getName() + ".system");
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.m_configFolder.getFileService().constructFileOutputStream(logicalSystemFile)));
                bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bufferedWriter.newLine();
                bufferedWriter.write("<system name=\"" + logicalSystem.getName() + "\">");
                bufferedWriter.newLine();
                bufferedWriter.write("\t<repositoryServers>");
                bufferedWriter.newLine();
                Iterator repositoryServers = logicalSystem.repositoryServers();
                while (repositoryServers.hasNext()) {
                    IRepositoryServer repositoryServer = (IRepositoryServer)repositoryServers.next();
                    bufferedWriter.newLine();
                    bufferedWriter.write("\t\t<repositoryServer url=\"" + repositoryServer.getUrl() + "\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("\t\t\t<filters>");
                    bufferedWriter.newLine();
                    Iterator filters = repositoryServer.filters();
                    while (filters.hasNext()) {
                        boolean isWorkspaceFilter;
                        IFilter filter = (IFilter)filters.next();
                        String relativeRemoteFilterPath = filter.getFilterPath().substring(repositoryServer.getAbsoluteRemoteRoot().length());
                        boolean bl = isWorkspaceFilter = filter.getClass() == (class$com$tssap$dtr$client$lib$vfs$config$impl$WorkspaceFilter == null ? LogicalSystemPersistance.class$("com.tssap.dtr.client.lib.vfs.config.impl.WorkspaceFilter") : class$com$tssap$dtr$client$lib$vfs$config$impl$WorkspaceFilter);
                        if (filter.getFilterType() == VfsFilterType.EXCLUDE) {
                            if (isWorkspaceFilter) {
                                LOCATION.warningT("Skipped to persist workspace filter of type EXCLUDE ({0}).", new Object[]{filter.getFilterPath()});
                                continue;
                            }
                            bufferedWriter.write("\t\t\t\t<exclude " + (isWorkspaceFilter ? WORKSPACE : FOLDER) + "=\"" + relativeRemoteFilterPath + "\" />");
                        } else if (filter.getFilterType() == VfsFilterType.READONLY) {
                            bufferedWriter.write("\t\t\t\t<readonly " + (isWorkspaceFilter ? WORKSPACE : FOLDER) + "=\"" + relativeRemoteFilterPath + "\" />");
                        } else if (filter.getFilterType() == VfsFilterType.INCLUDE) {
                            bufferedWriter.write("\t\t\t\t<include " + (isWorkspaceFilter ? WORKSPACE : FOLDER) + "=\"" + relativeRemoteFilterPath + "\" />");
                        } else {
                            throw new IllegalStateException("Unknown filter type: " + filter.getFilterType());
                        }
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.write("\t\t\t</filters>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("\t\t</repositoryServer>");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
                bufferedWriter.write("\t</repositoryServers>");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                bufferedWriter.write("\t<buildServers>");
                bufferedWriter.newLine();
                Iterator buildServers = logicalSystem.buildServers();
                while (buildServers.hasNext()) {
                    IBuildServer buildServer = (IBuildServer)buildServers.next();
                    bufferedWriter.newLine();
                    bufferedWriter.write("\t\t<buildServer url=\"" + buildServer.getUrl() + "\"/>");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
                bufferedWriter.write("\t</buildServers>");
                bufferedWriter.newLine();
                bufferedWriter.write("</system>");
                bufferedWriter.newLine();
                bufferedWriter.close();
            }
            catch (IOException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }

        private ILogicalSystem depersistLogicalSystemFile(IVirtualFile logicalSystemFile) {
            DepersistHandler handler = new DepersistHandler(this.m_configuration, this.m_sessionContexts);
            try {
                InputSource inputSource = new InputSource(this.m_configFolder.getFileService().constructFileInputStream(logicalSystemFile));
                XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                parser.setContentHandler(handler);
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                LOCATION.pathT("Depersisting logical system... from file ''{0}''.", new Object[]{logicalSystemFile});
                parser.parse(inputSource);
                LOCATION.pathT("Depersisting logical system... done.", new Object[0]);
            }
            catch (Exception x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
                LOCATION.pathT("Depersisting logical system... done with problems.", new Object[0]);
            }
            ILogicalSystem logicalSystem = handler.getDepersistedLogicalSystem();
            if (logicalSystem == null) {
                LOCATION.warningT("Skipped logical system file ''{0}'' (problem while depersisting, maybe invalid XML).", new Object[]{logicalSystemFile.getName()});
                return null;
            }
            if (!logicalSystem.getName().concat(".system").equalsIgnoreCase(logicalSystemFile.getName())) {
                LOCATION.warningT("Skipped logical system file ''{0}'' (system name in XML doesn't match filename).", new Object[]{logicalSystemFile.getName()});
                return null;
            }
            return handler.getDepersistedLogicalSystem();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private static class DepersistHandler
        extends DefaultHandler {
            private static final int START_STATE = 0;
            private static final int SYSTEM_STATE = 1;
            private static final int REPOSITORY_SERVERS_STATE = 2;
            private static final int REPOSITORY_SERVER_STATE = 3;
            private static final int FILTERS_STATE = 4;
            private static final int BUILD_SERVERS_STATE = 5;
            private static final int BUILD_SERVER_STATE = 6;
            private static final int FILTER_STATE = 7;
            private int m_state = 0;
            private IConfiguration m_configuration;
            private SessionContextBag m_sessionContexts;
            private ILogicalSystem m_depersistedLogicalSystem = null;
            private IRepositoryServer m_depersistedRepositoryServer = null;

            DepersistHandler(IConfiguration configuration, SessionContextBag sessionContexts) {
                this._initConfiguration(configuration);
                this._initSessionContexts(sessionContexts);
            }

            private void _initSessionContexts(SessionContextBag sessionContexts) {
                if (sessionContexts == null) {
                    throw new IllegalArgumentException("Parameter 'sessionContexts' must be non-null.");
                }
                this.m_sessionContexts = sessionContexts;
            }

            private void _initConfiguration(IConfiguration configuration) {
                if (configuration == null) {
                    throw new IllegalArgumentException("Parameter 'configuration' must be non-null.");
                }
                this.m_configuration = configuration;
            }

            ILogicalSystem getDepersistedLogicalSystem() {
                return this.m_depersistedLogicalSystem;
            }

            public void startElement(String namespaceURI, String localName, String rawName, Attributes attributes) {
                try {
                    switch (this.m_state) {
                        case 0: {
                            if (localName.equalsIgnoreCase(LogicalSystemPersistance.SYSTEM)) {
                                String systemName = attributes.getValue(LogicalSystemPersistance.NAME);
                                if (systemName == null || systemName.length() == 0) {
                                    LOCATION.warningT("Invalid XML detected: no attribute ''{0}'' found.", new Object[]{LogicalSystemPersistance.NAME});
                                    break;
                                }
                                LOCATION.pathT("Depersisting logical system... found ''{0}'' with name ''{1}''.", new Object[]{LogicalSystemPersistance.SYSTEM, systemName});
                                try {
                                    this.m_depersistedLogicalSystem = this.m_configuration.createLogicalSystem(systemName);
                                }
                                catch (IllegalStateException e) {
                                    this.m_depersistedLogicalSystem = this.m_configuration.getLogicalSystem(systemName);
                                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                                }
                                this.m_state = 1;
                                break;
                            }
                            LOCATION.warningT("Invalid XML detected: expected ''{0}'', found ''{1}''.", new Object[]{LogicalSystemPersistance.SYSTEM, localName});
                            break;
                        }
                        case 1: {
                            if (localName.equalsIgnoreCase(LogicalSystemPersistance.REPOSITORY_SERVERS)) {
                                LOCATION.pathT("Depersisting logical system... found ''{0}''", new Object[]{LogicalSystemPersistance.REPOSITORY_SERVERS});
                                this.m_state = 2;
                                break;
                            }
                            if (localName.equalsIgnoreCase(LogicalSystemPersistance.BUILD_SERVERS)) {
                                LOCATION.pathT("Depersisting logical system... found ''{0}''", new Object[]{LogicalSystemPersistance.BUILD_SERVERS});
                                this.m_state = 5;
                                break;
                            }
                            LOCATION.warningT("Invalid XML detected: expected ''{0}'' or ''{1}'', found ''{2}''.", new Object[]{LogicalSystemPersistance.REPOSITORY_SERVERS, LogicalSystemPersistance.BUILD_SERVERS, localName});
                            break;
                        }
                        case 2: {
                            if (localName.equalsIgnoreCase(LogicalSystemPersistance.REPOSITORY_SERVER)) {
                                String serverUrl = SessionContextBag.assureTrailingSlash(attributes.getValue(LogicalSystemPersistance.URL));
                                if (serverUrl == null) {
                                    LOCATION.warningT("Invalid XML detected: no attribute ''{0}'' found.", new Object[]{LogicalSystemPersistance.URL});
                                    break;
                                }
                                LOCATION.pathT("Depersisting logical system... found ''{0}'' with URL ''{1}''.", new Object[]{LogicalSystemPersistance.REPOSITORY_SERVER, serverUrl});
                                ISessionContext sessionContext = this.m_sessionContexts.getSessionContextForServerWithFallback(serverUrl);
                                try {
                                    this.m_depersistedRepositoryServer = this.m_depersistedLogicalSystem.addRepositoryServer(serverUrl, sessionContext.getUser(), sessionContext.getPassword());
                                }
                                catch (MalformedURLException e) {
                                    LOCATION.warningT("Malformed URL detected: ''{0}''.", new Object[]{serverUrl});
                                    break;
                                }
                                catch (IllegalStateException e) {
                                    LOCATION.warningT("Server already exists: ''{0}''.", new Object[]{serverUrl});
                                    break;
                                }
                                this.m_state = 3;
                                break;
                            }
                            LOCATION.warningT("Invalid XML detected: expected ''{0}'', found ''{1}''.", new Object[]{LogicalSystemPersistance.REPOSITORY_SERVER, localName});
                            break;
                        }
                        case 5: {
                            if (localName.equalsIgnoreCase(LogicalSystemPersistance.BUILD_SERVER)) {
                                String serverUrl = SessionContextBag.assureTrailingSlash(attributes.getValue(LogicalSystemPersistance.URL));
                                if (serverUrl == null) {
                                    LOCATION.warningT("Invalid XML detected: no attribute ''{0}'' found.", new Object[]{LogicalSystemPersistance.URL});
                                    break;
                                }
                                LOCATION.pathT("Depersisting logical system... found ''{0}'' with URL ''{1}''.", new Object[]{LogicalSystemPersistance.BUILD_SERVER, serverUrl});
                                ISessionContext sessionContext = this.m_sessionContexts.getSessionContextForServerWithFallback(serverUrl);
                                try {
                                    this.m_depersistedLogicalSystem.addBuildServer(serverUrl, sessionContext.getUser(), sessionContext.getPassword());
                                }
                                catch (MalformedURLException e) {
                                    LOCATION.warningT("Malformed URL detected: ''{0}''.", new Object[]{serverUrl});
                                    break;
                                }
                                catch (IllegalStateException e) {
                                    LOCATION.warningT("Server already exists: ''{0}''.", new Object[]{serverUrl});
                                    break;
                                }
                                this.m_state = 6;
                                break;
                            }
                            LOCATION.warningT("Invalid XML detected: expected ''{0}'', found ''{1}''.", new Object[]{LogicalSystemPersistance.BUILD_SERVER, localName});
                            break;
                        }
                        case 3: {
                            if (localName.equalsIgnoreCase(LogicalSystemPersistance.FILTERS)) {
                                LOCATION.pathT("Depersisting logical system... found ''{0}''.", new Object[]{LogicalSystemPersistance.FILTERS});
                                this.m_state = 4;
                                break;
                            }
                            LOCATION.warningT("Invalid XML detected: expected ''{0}'', found ''{1}''.", new Object[]{LogicalSystemPersistance.FILTERS, localName});
                            break;
                        }
                        case 4: {
                            String relativeRemoteFolderPath = DepersistHandler.getFilterPath(attributes);
                            if (localName.equalsIgnoreCase(LogicalSystemPersistance.INCLUDE)) {
                                LOCATION.pathT("Depersisting logical system... found ''{0}''.", new Object[]{LogicalSystemPersistance.INCLUDE});
                                if (DepersistHandler.isWorkspaceFilter(attributes)) {
                                    this.m_depersistedRepositoryServer.setWorkspaceFilter(relativeRemoteFolderPath, VfsFilterType.INCLUDE);
                                } else {
                                    this.m_depersistedRepositoryServer.setFilter(relativeRemoteFolderPath, VfsFilterType.INCLUDE);
                                }
                                this.m_state = 7;
                                break;
                            }
                            if (localName.equalsIgnoreCase(LogicalSystemPersistance.READONLY)) {
                                LOCATION.pathT("Depersisting logical system... found ''{0}''.", new Object[]{LogicalSystemPersistance.READONLY});
                                if (DepersistHandler.isWorkspaceFilter(attributes)) {
                                    this.m_depersistedRepositoryServer.setWorkspaceFilter(relativeRemoteFolderPath, VfsFilterType.READONLY);
                                } else {
                                    this.m_depersistedRepositoryServer.setFilter(relativeRemoteFolderPath, VfsFilterType.READONLY);
                                }
                                this.m_state = 7;
                                break;
                            }
                            if (localName.equalsIgnoreCase(LogicalSystemPersistance.EXCLUDE)) {
                                LOCATION.pathT("Depersisting logical system... found ''{0}''.", new Object[]{LogicalSystemPersistance.EXCLUDE});
                                this.m_depersistedRepositoryServer.setFilter(relativeRemoteFolderPath, VfsFilterType.EXCLUDE);
                                this.m_state = 7;
                                break;
                            }
                            LOCATION.warningT("Invalid XML detected: found ''{0}''.", new Object[]{localName});
                        }
                    }
                }
                catch (Exception e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            }

            private static String getFilterPath(Attributes attributes) {
                if (DepersistHandler.isWorkspaceFilter(attributes)) {
                    return attributes.getValue(LogicalSystemPersistance.WORKSPACE);
                }
                return attributes.getValue(LogicalSystemPersistance.FOLDER);
            }

            private static boolean isWorkspaceFilter(Attributes attributes) {
                if (attributes.getValue(LogicalSystemPersistance.FOLDER) != null) {
                    return false;
                }
                if (attributes.getValue(LogicalSystemPersistance.WORKSPACE) != null) {
                    return true;
                }
                throw new IllegalArgumentException();
            }

            public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
                switch (this.m_state) {
                    case 2: {
                        if (localName.equalsIgnoreCase(LogicalSystemPersistance.REPOSITORY_SERVERS)) {
                            this.m_state = 1;
                            break;
                        }
                        LOCATION.warningT("Invalid closing XML detected: expected ''{0}'', found ''{1}''.", new Object[]{LogicalSystemPersistance.REPOSITORY_SERVERS, localName});
                        break;
                    }
                    case 3: {
                        if (localName.equalsIgnoreCase(LogicalSystemPersistance.REPOSITORY_SERVER)) {
                            this.m_state = 2;
                            break;
                        }
                        LOCATION.warningT("Invalid closing XML detected: expected ''{0}'', found ''{1}''.", new Object[]{LogicalSystemPersistance.REPOSITORY_SERVER, localName});
                        break;
                    }
                    case 4: {
                        if (localName.equalsIgnoreCase(LogicalSystemPersistance.FILTERS)) {
                            this.m_state = 3;
                            break;
                        }
                        LOCATION.warningT("Invalid closing XML detected: expected ''{0}'', found ''{1}''.", new Object[]{LogicalSystemPersistance.FILTERS, localName});
                        break;
                    }
                    case 7: {
                        this.m_state = 4;
                        break;
                    }
                    case 5: {
                        if (localName.equalsIgnoreCase(LogicalSystemPersistance.BUILD_SERVERS)) {
                            this.m_state = 1;
                            break;
                        }
                        LOCATION.warningT("Invalid closing XML detected: expected ''{0}'', found ''{1}''.", new Object[]{LogicalSystemPersistance.BUILD_SERVERS, localName});
                        break;
                    }
                    case 6: {
                        if (localName.equalsIgnoreCase(LogicalSystemPersistance.BUILD_SERVER)) {
                            this.m_state = 5;
                            break;
                        }
                        LOCATION.warningT("Invalid closing XML detected: expected ''{0}'', found ''{1}''.", new Object[]{LogicalSystemPersistance.BUILD_SERVER, localName});
                    }
                }
            }
        }
    }
}

