/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.exceptions.ExceptionCategory;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.EnvironmentVariables;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsBasicProgressMonitor;
import com.tssap.dtr.client.lib.vfs.IVfsBatchedEventRunnable;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsExceptionCategory;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.impl.Configuration;
import com.tssap.dtr.client.lib.vfs.config.impl.LogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.impl.MountPoint;
import com.tssap.dtr.client.lib.vfs.config.impl.Server;
import com.tssap.dtr.client.lib.vfs.config.impl.VfsContext;
import com.tssap.dtr.client.lib.vfs.fileservice.LocalFileService;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

final class Client
implements IClient {
    private static Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$config$impl$Client == null ? (class$com$tssap$dtr$client$lib$vfs$config$impl$Client = Client.class$("com.tssap.dtr.client.lib.vfs.config.impl.Client")) : class$com$tssap$dtr$client$lib$vfs$config$impl$Client));
    static final boolean DO_RELEASE_MANAGER = true;
    static final boolean DONT_RELEASE_MANAGER = false;
    static final MountPoint[] EMPTY_MOUNT_POINTS = new MountPoint[0];
    static final int MAX_CLIENT_ID_LENGTH = 255;
    private IConfiguration _configuration;
    private String _name;
    private String _absoluteLocalRoot;
    private ILogicalSystem _logicalSystem;
    private Map _mountPointsByCompleteLocalRoot = new HashMap();
    private LruMountPointCache _lruMountPointCache = new LruMountPointCache();
    private IVfsContext _context = null;
    private String _clientFilter;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$config$impl$Client;

    public String getClientFilter() {
        return this._clientFilter;
    }

    public void setClientFilter(String clientFilter) throws ConfigurationException {
        Client.checkClientFilter(clientFilter);
        this.pureSetClientFilter(clientFilter);
    }

    void pureSetClientFilter(String clientFilter) {
        this._clientFilter = clientFilter;
    }

    static void checkClientFilter(String clientFilter) throws ConfigurationException {
        if (clientFilter != null && clientFilter.length() > 255) {
            throw new ConfigurationException("Try to set client filter with " + clientFilter.length() + " characters (max. 255 allowed).");
        }
    }

    Client(IConfiguration configuration, String name, String absoluteLocalRoot, ILogicalSystem logicalSystem) {
        this._initConfiguration(configuration);
        this._initName(name);
        this._initAbsoluteLocalRoot(absoluteLocalRoot);
        this._initLogicalSystem(logicalSystem);
    }

    private void _initLogicalSystem(ILogicalSystem logicalSystem) {
        if (logicalSystem == null) {
            throw new IllegalArgumentException("Parameter 'logicalSystem' must be non-null.");
        }
        this._logicalSystem = logicalSystem;
    }

    private void _initAbsoluteLocalRoot(String absoluteLocalRoot) {
        File file = new File(absoluteLocalRoot);
        if (absoluteLocalRoot != null && absoluteLocalRoot.length() > 0 && file.isAbsolute()) {
            try {
                this._absoluteLocalRoot = Util.assureTrailingFileSeparator(file.getCanonicalPath(), File.separator);
                if (this.isAbsoluteLocalRootCoveredByOtherClientsAbsoluteLocalRoot(this._absoluteLocalRoot)) {
                    throw new IllegalArgumentException("Client " + this.getName() + ": absoluteLocalRoot (='" + absoluteLocalRoot + "') is already used by another client.");
                }
                return;
            }
            catch (IOException e) {
                String METHOD = "_initAbsoluteLocalRoot";
                LOCATION.warningT("_initAbsoluteLocalRoot", "Could not get canonical path for {0}", new Object[]{absoluteLocalRoot});
            }
        }
        throw new IllegalArgumentException("Parameter 'absoluteLocalRoot'='" + absoluteLocalRoot + "' is invalid.");
    }

    private void _initName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 'name' must be non-null.");
        }
        this._name = name;
    }

    private void _initConfiguration(IConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Parameter 'configuration' must be non-null.");
        }
        this._configuration = configuration;
    }

    public String toString() {
        return "Client<" + this.getName() + ">[" + this.getAbsoluteLocalRoot() + ", " + this.getLogicalSystem().getName() + "]";
    }

    public synchronized IMountPoint createMountPoint(IRepositoryServer repositoryServer, String relativeRemoteRoot, String relativeLocalRoot) {
        MountPoint mountPoint = new MountPoint(this, repositoryServer, relativeRemoteRoot, relativeLocalRoot);
        String completeLocalRoot = mountPoint.getCompleteLocalRoot();
        if (this._mountPointsByCompleteLocalRoot.containsKey(completeLocalRoot)) {
            throw new IllegalStateException("Cannot create mount point. Another mount point with the same complete local root '" + completeLocalRoot + "' already exists.");
        }
        if (this.isMountPointCoveredByExistingMountPointRegardingLocalPath(mountPoint)) {
            throw new IllegalStateException("Cannot create mount point. Another mount point that covers the same local path '" + completeLocalRoot + "' already exists.");
        }
        if (this.isMountPointCoveredByExistingMountPointRegardingRemotePath(mountPoint)) {
            throw new IllegalStateException("Cannot create mount point. Another mount point that covers the same remote path '" + mountPoint.getCompleteRemoteRoot() + "' on same repository server '" + mountPoint.getRepositoryServer() + "' already exists.");
        }
        this._mountPointsByCompleteLocalRoot.put(completeLocalRoot, mountPoint);
        IVfsContext context = this.getContext();
        if (VersionedFileSystemFactory.hasVersionedFileSystemManager(context)) {
            VersionedFileSystemManager manager = null;
            try {
                manager = (VersionedFileSystemManager)VersionedFileSystemFactory.getVersionedFileSystemManager(context);
                manager.mountPointCreated(mountPoint.getCompleteLocalRoot());
            }
            catch (VfsException x) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        return mountPoint;
    }

    public void deleteMountPoint(IMountPoint mountPoint) {
        this.checkNullMountPoints(new IMountPoint[]{mountPoint});
        this.checkForeignMountPoints(new IMountPoint[]{mountPoint});
        Client.internalDeleteMountPoints(new IMountPoint[]{mountPoint}, false, false);
    }

    public void deleteMountPoints(IMountPoint[] mountPoints) {
        this.checkNullMountPoints(mountPoints);
        this.checkForeignMountPoints(mountPoints);
        Client.internalDeleteMountPoints(mountPoints, false, false);
    }

    public void deleteMountPoint(IMountPoint mountPoint, boolean forcedWithNoMercy) {
        this.checkNullMountPoints(new IMountPoint[]{mountPoint});
        this.checkForeignMountPoints(new IMountPoint[]{mountPoint});
        Client.internalDeleteMountPoints(new IMountPoint[]{mountPoint}, forcedWithNoMercy, false);
    }

    public void deleteMountPoints(IMountPoint[] mountPoints, boolean forcedWithNoMercy) {
        this.checkNullMountPoints(mountPoints);
        this.checkForeignMountPoints(mountPoints);
        Client.internalDeleteMountPoints(mountPoints, forcedWithNoMercy, false);
    }

    void deleteMountPoints(IMountPoint[] mountPoints, boolean forcedWithNoMercy, boolean doReleaseManager) {
        this.checkNullMountPoints(mountPoints);
        this.checkForeignMountPoints(mountPoints);
        Client.internalDeleteMountPoints(mountPoints, forcedWithNoMercy, doReleaseManager);
    }

    private void checkNullMountPoints(IMountPoint[] mountPoints) {
        if (mountPoints == null) {
            throw new IllegalArgumentException("Illegal argument: mount point array is null, for details see trace file.");
        }
        int i = 0;
        while (i < mountPoints.length) {
            if (mountPoints[i] == null) {
                throw new IllegalArgumentException("Illegal argument: null value in mount point array, for details see trace file.");
            }
            ++i;
        }
    }

    private void checkForeignMountPoints(IMountPoint[] mountPoints) throws VfsRuntimeException {
        if (!EnvironmentVariables.FORCE_CLASSIC_DELETE_MOUNTPOINT) {
            int i = 0;
            while (i < mountPoints.length) {
                IMountPoint mountPoint = mountPoints[i];
                if (!mountPoint.getClient().equals(this)) {
                    throw new VfsRuntimeException((ExceptionCategory)VfsExceptionCategory.MOUNTPOINT_BELONGS_TO_DIFFERENT_CLIENT, new Object[]{"\"" + mountPoint.getRelativeRemoteRoot() + "\"", "\"" + this.getName() + "\""}, null);
                }
                ++i;
            }
        }
    }

    private static synchronized void internalDeleteMountPoints(IMountPoint[] mountPoints, boolean forcedWithNoMercy, boolean doReleaseVfsManager) throws VfsRuntimeException {
        VfsRuntimeException caughtException = null;
        if (!doReleaseVfsManager && !EnvironmentVariables.FORCE_CLASSIC_DELETE_MOUNTPOINT) {
            Map vfsManagersForMountPoints = Client.getVfsManagersFor(mountPoints);
            try {
                Client.internalDeleteMountPointsWithAdaptingVfsManagers(vfsManagersForMountPoints, forcedWithNoMercy);
            }
            catch (VfsRuntimeException e) {
                caughtException = e;
            }
        } else {
            HashSet<IVfsContext> contexts = new HashSet<IVfsContext>();
            try {
                int i = 0;
                while (i < mountPoints.length) {
                    IMountPoint mountPoint = mountPoints[i];
                    ((Client)mountPoint.getClient()).internalDeleteMountPointWithoutReleasingManager(mountPoint, forcedWithNoMercy);
                    contexts.add(mountPoint.getClient().getContext());
                    ++i;
                }
            }
            catch (VfsRuntimeException e) {
                caughtException = e;
            }
            Iterator iterator = contexts.iterator();
            while (iterator.hasNext()) {
                IVfsContext context = (IVfsContext)iterator.next();
                if (!VersionedFileSystemFactory.hasVersionedFileSystemManager(context)) continue;
                try {
                    IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager(context);
                    VersionedFileSystemFactory.releaseVersionedFileSystemManager(manager);
                }
                catch (VfsException e) {
                    // empty catch block
                }
            }
        }
        if (caughtException != null) {
            throw caughtException;
        }
    }

    private static Map getVfsManagersFor(IMountPoint[] mountPoints) {
        HashMap<IVersionedFileSystemManager, ArrayList<MountPoint>> vfsManagers = new HashMap<IVersionedFileSystemManager, ArrayList<MountPoint>>(mountPoints.length);
        int i = 0;
        while (i < mountPoints.length) {
            MountPoint mountPoint = (MountPoint)mountPoints[i];
            IVfsContext context = mountPoint.getClient().getContext();
            try {
                if (VersionedFileSystemFactory.hasVersionedFileSystemManager(context)) {
                    IVersionedFileSystemManager vfsManager = VersionedFileSystemFactory.getVersionedFileSystemManager(context);
                    ArrayList<MountPoint> mountPointsForVfsManager = (ArrayList<MountPoint>)vfsManagers.get(vfsManager);
                    if (mountPointsForVfsManager == null) {
                        mountPointsForVfsManager = new ArrayList<MountPoint>();
                    }
                    mountPointsForVfsManager.add(mountPoint);
                    vfsManagers.put(vfsManager, mountPointsForVfsManager);
                }
            }
            catch (VfsException e) {
                // empty catch block
            }
            ++i;
        }
        return vfsManagers;
    }

    private static void internalDeleteMountPointsWithAdaptingVfsManagers(Map vfsManagersForMountPoints, final boolean forcedWithNoMercy) throws VfsRuntimeException {
        Iterator vfsManagerIterator = vfsManagersForMountPoints.keySet().iterator();
        while (vfsManagerIterator.hasNext()) {
            final VersionedFileSystemManager vfsManager = (VersionedFileSystemManager)vfsManagerIterator.next();
            final ArrayList mountPoints = (ArrayList)vfsManagersForMountPoints.get(vfsManager);
            try {
                vfsManager.getEventManager().run(new IVfsBatchedEventRunnable(){

                    public void run(IVfsBasicProgressMonitor vfsProgressMonitor) throws InvocationTargetException {
                        try {
                            Client.internalDeleteMountPointsWithAdaptingVfsManager(mountPoints, vfsManager, forcedWithNoMercy);
                        }
                        catch (VfsRuntimeException e) {
                            LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)500);
                            throw e;
                        }
                        catch (InvocationTargetException e) {
                            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
                            throw e;
                        }
                    }
                }, IVfsBasicProgressMonitor.BasicProgressMonitorAdaptor);
            }
            catch (VfsException e) {
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
                if (e.getCategory() != VfsExceptionCategory.OPERATION_ABORTED_BY_EXCEPTION || !(e.getCause() instanceof VfsRuntimeException)) break;
                throw (VfsRuntimeException)e.getCause();
            }
        }
    }

    private static void internalDeleteMountPointsWithAdaptingVfsManager(ArrayList mountPoints, VersionedFileSystemManager vfsManager, boolean forcedWithNoMercy) throws VfsRuntimeException, InvocationTargetException {
        int i = 0;
        while (i < mountPoints.size()) {
            MountPoint mountPoint = (MountPoint)mountPoints.get(i);
            Client.checkPreconditionsForDeleteMountPoint(mountPoint, forcedWithNoMercy);
            ++i;
        }
        int i2 = 0;
        while (i2 < mountPoints.size()) {
            MountPoint mountPoint = (MountPoint)mountPoints.get(i2);
            try {
                vfsManager.prepareActionsForMountPointDeletion(mountPoint.getCompleteLocalRoot());
                ((Client)mountPoint.getClient()).internalDeleteMountPointWithoutReleasingManager(mountPoint, forcedWithNoMercy);
            }
            catch (VfsException e) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)500);
                try {
                    VersionedFileSystemFactory.releaseVersionedFileSystemManager(vfsManager);
                }
                catch (Exception e1) {
                    LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e1, (int)500);
                    throw new InvocationTargetException(e1, e1.getMessage());
                }
                throw new InvocationTargetException(e, e.getMessage());
            }
            catch (VfsRuntimeException e) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)500);
                if (e.getCategory() == VfsExceptionCategory.CANT_DELETE_MOUNTPOINT_IF_THERE_ARE_STILL_FILES_SYNCED) {
                    try {
                        VersionedFileSystemFactory.releaseVersionedFileSystemManager(vfsManager);
                    }
                    catch (Exception e1) {
                        LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e1, (int)500);
                        throw new InvocationTargetException(e1, e1.getMessage());
                    }
                }
                throw e;
            }
            ++i2;
        }
    }

    private synchronized void internalDeleteMountPointWithoutReleasingManager(IMountPoint mountPoint, boolean forcedWithNoMercy) {
        String METHOD = "deleteMountPoint";
        LOCATION.infoT("deleteMountPoint", "mountpoint=\"{0}\", mode={1}", new Object[]{mountPoint, forcedWithNoMercy ? "forced" : "withChecks"});
        Client.checkPreconditionsForDeleteMountPoint(mountPoint, forcedWithNoMercy);
        this._mountPointsByCompleteLocalRoot.remove(((MountPoint)mountPoint).getCompleteLocalRoot());
        this._lruMountPointCache.removeMountPointFromCache(mountPoint);
        SyncDB syncDB = mountPoint.getSyncDb();
        if (syncDB != null) {
            syncDB.delete();
            ((MountPoint)mountPoint).detachSyncDb();
        }
    }

    private static void checkPreconditionsForDeleteMountPoint(IMountPoint mountPoint, boolean forcedWithNoMercy) {
        SyncDB syncDB = mountPoint.getSyncDb();
        if (!forcedWithNoMercy && syncDB != null) {
            LocalFileService fileService = new LocalFileService();
            Iterator iterator = syncDB.resourcePaths();
            while (iterator.hasNext()) {
                String resourcePath = (String)iterator.next();
                if (!fileService.constructFile(resourcePath).isFile()) continue;
                throw new VfsRuntimeException((ExceptionCategory)VfsExceptionCategory.CANT_DELETE_MOUNTPOINT_IF_THERE_ARE_STILL_FILES_SYNCED, new Object[]{resourcePath}, null);
            }
        }
    }

    public String getAbsoluteLocalRoot() {
        return this._absoluteLocalRoot;
    }

    public IConfiguration getConfiguration() {
        return this._configuration;
    }

    public IVfsContext getContext() {
        if (this._context == null) {
            this._context = new VfsContext(this);
        }
        return this._context;
    }

    public ILogicalSystem getLogicalSystem() {
        return this._logicalSystem;
    }

    public IMountPoint getMountPointForLocalPath(String absoluteLocalPath) {
        return this._lruMountPointCache.getMountPoint(absoluteLocalPath, this);
    }

    MountPoint getMountPointForMaybeWrongCasedLocalPath(String maybeWrongPath) {
        Iterator iterator = this._lruMountPointCache.m_lruMountPoints.iterator();
        while (iterator.hasNext()) {
            MountPoint mountPoint = (MountPoint)iterator.next();
            if (!this.isResponsibleForMaybeWrongCasedLocalPath(mountPoint, maybeWrongPath)) continue;
            return mountPoint;
        }
        Iterator iterator2 = this._mountPointsByCompleteLocalRoot.values().iterator();
        while (iterator2.hasNext()) {
            MountPoint mountPoint = (MountPoint)iterator2.next();
            if (!this.isResponsibleForMaybeWrongCasedLocalPath(mountPoint, maybeWrongPath)) continue;
            return mountPoint;
        }
        return null;
    }

    private boolean isResponsibleForMaybeWrongCasedLocalPath(MountPoint mountPoint, String maybeWrongPath) {
        String mountPointLocalPath = mountPoint.getCompleteLocalRoot();
        if (maybeWrongPath.length() < mountPointLocalPath.length()) {
            return false;
        }
        String truncatedAbsoluteLocalPath = maybeWrongPath.substring(0, mountPointLocalPath.length());
        return mountPointLocalPath.equalsIgnoreCase(truncatedAbsoluteLocalPath);
    }

    private boolean isMountPointCoveredByExistingMountPointRegardingLocalPath(MountPoint mountPoint) {
        LOCATION.debugT("O(n): isMountPointCoveredByExistingMountPointRegardingLocalPath using mount point ''{0}''", new Object[]{mountPoint});
        Iterator mountPoints = this.mountPoints();
        while (mountPoints.hasNext()) {
            MountPoint existingMountPoint = (MountPoint)mountPoints.next();
            if (!(existingMountPoint.getCompleteLocalRoot().length() > mountPoint.getCompleteLocalRoot().length() ? existingMountPoint.getCompleteLocalRoot().startsWith(mountPoint.getCompleteLocalRoot()) : mountPoint.getCompleteLocalRoot().startsWith(existingMountPoint.getCompleteLocalRoot()))) continue;
            return true;
        }
        return false;
    }

    private boolean isMountPointCoveredByExistingMountPointRegardingRemotePath(MountPoint mountPoint) {
        LOCATION.debugT("O(n): isMountPointCoveredByExistingMountPointRegardingRemotePath using mount point ''{0}''", new Object[]{mountPoint});
        Iterator mountPoints = this.mountPoints();
        while (mountPoints.hasNext()) {
            MountPoint existingMountPoint = (MountPoint)mountPoints.next();
            if (existingMountPoint.getRepositoryServer().getConnectionTemplateId() != mountPoint.getRepositoryServer().getConnectionTemplateId() || !(existingMountPoint.getCompleteRemoteRoot().length() > mountPoint.getCompleteRemoteRoot().length() ? existingMountPoint.getCompleteRemoteRoot().startsWith(mountPoint.getCompleteRemoteRoot()) : mountPoint.getCompleteRemoteRoot().startsWith(existingMountPoint.getCompleteRemoteRoot()))) continue;
            return true;
        }
        return false;
    }

    private boolean isAbsoluteLocalRootCoveredByOtherClientsAbsoluteLocalRoot(String absoluteLocalRoot) {
        LOCATION.debugT("O(n): isAbsoluteLocalRootCoveredByOtherClientsAbsoluteLocalRoot using absoluteLocalRoot ''{0}''", new Object[]{absoluteLocalRoot});
        Iterator clients = this.getConfiguration().clients();
        while (clients.hasNext()) {
            Client existingClient = (Client)clients.next();
            if (!(existingClient.getAbsoluteLocalRoot().length() > absoluteLocalRoot.length() ? existingClient.getAbsoluteLocalRoot().startsWith(absoluteLocalRoot) : absoluteLocalRoot.startsWith(existingClient.getAbsoluteLocalRoot()))) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    MountPoint[] getMountPoints() {
        return this._mountPointsByCompleteLocalRoot.values().toArray(EMPTY_MOUNT_POINTS);
    }

    public Iterator mountPoints() {
        return Collections.unmodifiableMap(this._mountPointsByCompleteLocalRoot).values().iterator();
    }

    public void setCredentials(String username, String password, KeyStore serverCerts, KeyStore clientCerts) throws KeyStoreException {
        if (this.getConfiguration().isMasterLogin()) {
            throw new IllegalStateException("VFS currently operates in master-login mode. Use IConfiguration.setMasterLogin().");
        }
        ((Configuration)this.getConfiguration()).m_isClientLoginMode = true;
        ArrayList<ISessionContext> sessionContexts = new ArrayList<ISessionContext>();
        Iterator iter = this.getLogicalSystem().repositoryServers();
        while (iter.hasNext()) {
            Server server = (Server)iter.next();
            sessionContexts.add(server.getConnectionTemplate().getSessionContext());
        }
        Iterator iter2 = this.getLogicalSystem().buildServers();
        while (iter2.hasNext()) {
            Server server = (Server)iter2.next();
            sessionContexts.add(server.getConnectionTemplate().getSessionContext());
        }
        boolean credentialsChanged = false;
        Iterator iter3 = ((AbstractList)sessionContexts).iterator();
        while (iter3.hasNext()) {
            boolean sameServerCerts;
            SessionContext sessionContext = (SessionContext)iter3.next();
            boolean sameUser = LogicalSystem.sameStrings(username, sessionContext.getUser());
            boolean samePassword = LogicalSystem.sameStrings(password, sessionContext.getPassword());
            boolean serverCertsBothNull = serverCerts == null && sessionContext.certificates().getServerCertificates() == null;
            boolean bl = sameServerCerts = serverCertsBothNull || serverCerts != null && serverCerts.equals(sessionContext.certificates().getServerCertificates());
            if (sameUser && samePassword && sameServerCerts) continue;
            credentialsChanged = true;
            break;
        }
        Iterator iter4 = ((AbstractList)sessionContexts).iterator();
        while (iter4.hasNext()) {
            SessionContext sessionContext = (SessionContext)iter4.next();
            sessionContext.setUser(username);
            sessionContext.setPassword(password);
            if (serverCerts != null) {
                sessionContext.certificates().setServerCertificates(serverCerts);
                sessionContext.certificates().setAuthenticateThem(true);
            }
            if (clientCerts == null) continue;
            sessionContext.certificates().setClientCertificates(clientCerts, password);
            sessionContext.certificates().setAuthenticateMe(true);
        }
        if (credentialsChanged && username != null) {
            Client client = this;
            try {
                if (VersionedFileSystemFactory.hasVersionedFileSystemManager(client.getContext())) {
                    IVersionedFileSystemManager vfsManager = VersionedFileSystemFactory.getVersionedFileSystemManager(client.getContext());
                    VersionedFileSystemFactory.releaseVersionedFileSystemManager(vfsManager);
                }
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LruMountPointCache {
        private LinkedList m_lruMountPoints = new LinkedList();
        private final int CACHE_SIZE = EnvironmentVariables.NUMBER_OF_OPEN_SYNCDBS;
        private int[] m_statistics = new int[this.CACHE_SIZE + 1];
        private int _mountPointAccesses;

        private LruMountPointCache() {
        }

        private void putToFront(IMountPoint mountPoint) {
            this.m_lruMountPoints.addFirst(mountPoint);
            if (this.m_lruMountPoints.size() > this.CACHE_SIZE) {
                MountPoint removedMountPoint = (MountPoint)this.m_lruMountPoints.removeLast();
                removedMountPoint.closeSyncDb();
            }
        }

        private void updateStatistics(int index) {
            this.m_statistics[index] = this.m_statistics[index] + 1;
            if (++this._mountPointAccesses % 1024 == 0) {
                this._mountPointAccesses = 0;
                StringBuffer msg = new StringBuffer("MP-Cache statistics: ");
                int i = 0;
                while (i < this.m_statistics.length) {
                    msg.append(this.m_statistics[i]);
                    msg.append(" ");
                    ++i;
                }
                LOCATION.debugT(msg.toString());
            }
        }

        IMountPoint getMountPoint(String absoluteLocalPath, Client client) {
            int index = 0;
            Iterator iterator = this.m_lruMountPoints.iterator();
            while (iterator.hasNext()) {
                MountPoint mountPoint = (MountPoint)iterator.next();
                if (MountPoint.isResponsibleForLocalPath(mountPoint, absoluteLocalPath)) {
                    iterator.remove();
                    this.updateStatistics(index);
                    this.putToFront(mountPoint);
                    return mountPoint;
                }
                ++index;
            }
            this.updateStatistics(this.CACHE_SIZE);
            Iterator iterator2 = client._mountPointsByCompleteLocalRoot.values().iterator();
            while (iterator2.hasNext()) {
                MountPoint mountPoint = (MountPoint)iterator2.next();
                if (!MountPoint.isResponsibleForLocalPath(mountPoint, absoluteLocalPath)) continue;
                this.putToFront(mountPoint);
                return mountPoint;
            }
            return null;
        }

        void removeMountPointFromCache(IMountPoint mountPointToRemove) {
            Iterator iterator = this.m_lruMountPoints.iterator();
            while (iterator.hasNext()) {
                MountPoint mountPoint = (MountPoint)iterator.next();
                if (!mountPoint.equals(mountPointToRemove)) continue;
                iterator.remove();
                mountPoint.closeSyncDb();
                return;
            }
        }
    }
}

