/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.config;

import com.tssap.dtr.client.lib.protocol.requests.RequestBase;
import com.tssap.dtr.client.lib.util.EnvironmentVariables;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.fileservice.LocalFileService;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public final class Configuration {
    private static Map g_configurationsByConfigFolder;
    private static IVirtualFile m_default_config_folder;
    private static final String NAME_OF_DEFAULT_CONFIG_FOLDER = ".dtr";

    public static IConfiguration getConfiguration() {
        IVirtualFile configFolder = Configuration.getConfigFolder();
        return Configuration.getConfiguration(configFolder);
    }

    public static IConfiguration getConfiguration(IVirtualFile configFolder) {
        IConfiguration configuration = (IConfiguration)g_configurationsByConfigFolder.get(configFolder);
        if (configuration == null) {
            configuration = new com.tssap.dtr.client.lib.vfs.config.impl.Configuration(configFolder);
            g_configurationsByConfigFolder.put(configFolder, configuration);
        }
        return configuration;
    }

    private static IVirtualFile getConfigFolder() {
        String overrideFolder = EnvironmentVariables.VFS_CONFIGFOLDER;
        if (overrideFolder != null) {
            Configuration.setDefaultConfigFolder(new LocalFileService().constructFile(overrideFolder));
        } else if (m_default_config_folder == null) {
            String userHome = Configuration.getUserHome();
            Configuration.setDefaultConfigFolder(new LocalFileService().constructFile(userHome, NAME_OF_DEFAULT_CONFIG_FOLDER));
        }
        return m_default_config_folder;
    }

    private static String getUserHome() {
        String userHome = System.getProperty("user.home", null);
        if (userHome == null || userHome.length() == 0) {
            throw new IllegalArgumentException("system property <user.home> must be a non empty string");
        }
        return userHome;
    }

    private static void setDefaultConfigFolder(IVirtualFile defaultConfigFolder) {
        m_default_config_folder = defaultConfigFolder;
        m_default_config_folder.mkdirs();
    }

    public static void setParentOfDefaultConfigFolder(IVirtualFile parentFolder) {
        Configuration.setDefaultConfigFolder(parentFolder.getFileService().constructFile(parentFolder, NAME_OF_DEFAULT_CONFIG_FOLDER));
    }

    public static IVirtualFile getParentOfDefaultConfigFolder() {
        return m_default_config_folder.getParentFile();
    }

    static {
        RequestBase.setLogStream((PrintStream)Logbook.getInfoChapter());
        g_configurationsByConfigFolder = new HashMap();
    }
}

