/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.actions.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsActionListener;
import com.tssap.dtr.client.lib.vfs.actions.IVfsActionManager;
import com.tssap.dtr.client.lib.vfs.actions.impl.ActionQueue;
import com.tssap.dtr.client.lib.vfs.actions.impl.WorkerThread;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class VfsActionManagerImpl
implements IVfsActionManager {
    ActionQueue m_queue = new ActionQueue();
    WorkerThread m_workerThread = new WorkerThread(this.m_queue, this);
    private Set m_actionListeners = new HashSet();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$actions$impl$VfsActionManagerImpl == null ? (class$com$tssap$dtr$client$lib$vfs$actions$impl$VfsActionManagerImpl = VfsActionManagerImpl.class$("com.tssap.dtr.client.lib.vfs.actions.impl.VfsActionManagerImpl")) : class$com$tssap$dtr$client$lib$vfs$actions$impl$VfsActionManagerImpl));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$actions$impl$VfsActionManagerImpl;

    public VfsActionManagerImpl() {
        this.m_workerThread.setDaemon(true);
        this.m_workerThread.start();
    }

    public void doAsynchronously(IVfsAction vfsAction) {
        if (!this.m_queue.isIdle()) {
            throw new IllegalStateException("Worker thread is still processing an action.");
        }
        this.fireOnBusy(vfsAction.getVersionedFileSystemManager());
        this.m_queue.nq(vfsAction);
    }

    public void doSynchronously(IVfsAction vfsAction) {
        this.doAsynchronously(vfsAction);
        IVfsAction iVfsAction = vfsAction;
        synchronized (iVfsAction) {
            try {
                if (!vfsAction.hasFinished()) {
                    vfsAction.wait();
                }
            }
            catch (InterruptedException x) {
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)x, (int)300);
            }
        }
    }

    public boolean idle() {
        return this.m_queue.isIdle();
    }

    public void interrupt() {
        this.m_workerThread.interrupt();
    }

    public void addActionListener(IVfsActionListener listener) {
        this.m_actionListeners.add(listener);
    }

    public void removeActionListener(IVfsActionListener listener) {
        this.m_actionListeners.remove(listener);
    }

    public void fireOnIdle(IVersionedFileSystemManager[] managers) {
        Iterator iterator = this.m_actionListeners.iterator();
        while (iterator.hasNext()) {
            IVfsActionListener listener = (IVfsActionListener)iterator.next();
            try {
                if (!this.idle()) continue;
                listener.onIdle(managers);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    public void fireOnBusy(IVersionedFileSystemManager manager) {
        Iterator iterator = this.m_actionListeners.iterator();
        while (iterator.hasNext()) {
            IVfsActionListener listener = (IVfsActionListener)iterator.next();
            try {
                if (!this.idle()) continue;
                listener.onBusy(manager);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

