/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.BaseAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;

public class UploadAction
extends BaseAction {
    IVfsActivity m_activity;
    IVfsActivity[] m_activities;
    IVfsActivityRecordedFolderItem m_folderItem;
    IVfsActivityRecordedFolderItem[] m_folderItems;
    IVfsProgressMonitor m_progressMonitor;
    boolean m_forced;
    volatile boolean m_hasFinished;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$actions$UploadAction == null ? (class$com$tssap$dtr$client$lib$vfs$actions$UploadAction = UploadAction.class$("com.tssap.dtr.client.lib.vfs.actions.UploadAction")) : class$com$tssap$dtr$client$lib$vfs$actions$UploadAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$actions$UploadAction;

    public UploadAction(IVfsActivityRecordedFolderItem folderItem, boolean forced) {
        this(folderItem, forced, null);
    }

    public UploadAction(IVfsActivityRecordedFolderItem folderItem, boolean forced, IVfsProgressMonitor progressMonitor) {
        super(folderItem.getVersionedFileSystemManager());
        this.m_folderItem = folderItem;
        this.m_forced = forced;
        this.m_progressMonitor = progressMonitor;
    }

    public UploadAction(IVfsActivityRecordedFolderItem[] folderItems, boolean forced) {
        this(folderItems, forced, null);
    }

    public UploadAction(IVfsActivityRecordedFolderItem[] folderItems, boolean forced, IVfsProgressMonitor progressMonitor) {
        super(folderItems != null && folderItems.length > 0 ? folderItems[0].getVersionedFileSystemManager() : null);
        this.m_folderItems = folderItems;
        this.m_forced = forced;
        this.m_progressMonitor = progressMonitor;
    }

    public UploadAction(IVfsActivity activity, boolean forced) {
        this(activity, forced, null);
    }

    public UploadAction(IVfsActivity activity, boolean forced, IVfsProgressMonitor progressMonitor) {
        super(activity.getVersionedFileSystemManager());
        this.m_activity = activity;
        this.m_forced = forced;
        this.m_progressMonitor = progressMonitor;
    }

    public UploadAction(IVfsActivity[] activities, boolean forced) {
        this(activities, forced, null);
    }

    public UploadAction(IVfsActivity[] activities, boolean forced, IVfsProgressMonitor progressMonitor) {
        super(activities != null && activities.length > 0 ? activities[0].getVersionedFileSystemManager() : null);
        this.m_activities = activities;
        this.m_forced = forced;
        this.m_progressMonitor = progressMonitor;
    }

    public void execute() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onStart();
        }
        VfsActionRecorder.getRecorder().start();
        Exception throwable = null;
        try {
            if (this.m_activity != null) {
                if (this.m_forced) {
                    this.m_activity.forceUpload();
                } else {
                    this.m_activity.upload();
                }
            } else if (this.m_activities != null) {
                if (this.m_forced) {
                    int i = 0;
                    while (i < this.m_activities.length) {
                        this.m_activities[i].forceUpload();
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.m_activities.length) {
                        this.m_activities[i].upload();
                        ++i;
                    }
                }
            } else if (this.m_folderItem != null) {
                if (this.m_forced) {
                    this.m_folderItem.forceUpload();
                } else {
                    this.m_folderItem.upload();
                }
            } else if (this.m_folderItems != null) {
                if (this.m_forced) {
                    int i = 0;
                    while (i < this.m_folderItems.length) {
                        this.m_folderItems[i].forceUpload();
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.m_folderItems.length) {
                        this.m_folderItems[i].upload();
                        ++i;
                    }
                }
            }
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            throwable = x;
        }
        catch (Exception x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            throwable = x;
        }
        VfsActionRecorder.getRecorder().finish();
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onFinish(throwable);
        }
        this.m_hasFinished = true;
    }

    public boolean hasFinished() {
        return this.m_hasFinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

