/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.BaseAction;
import com.tssap.dtr.client.lib.vfs.actions.FolderItemAndActivityTuppel;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class UncheckoutAction
extends BaseAction {
    IVfsActivity m_activity = null;
    IVfsActivity[] m_activities = null;
    IVfsActivityRecordedFolderItem m_folderItem = null;
    IVfsActivityRecordedFolderItem[] m_folderItems = null;
    FolderItemAndActivityTuppel[] m_tupples = null;
    IVfsProgressMonitor m_progressMonitor;
    volatile boolean m_hasFinished = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$actions$UncheckoutAction == null ? (class$com$tssap$dtr$client$lib$vfs$actions$UncheckoutAction = UncheckoutAction.class$("com.tssap.dtr.client.lib.vfs.actions.UncheckoutAction")) : class$com$tssap$dtr$client$lib$vfs$actions$UncheckoutAction));
    private static final boolean DONT_REMOVE_FROM_CLIENT = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$actions$UncheckoutAction;

    public UncheckoutAction(IVfsActivity activity) {
        this(activity, null);
    }

    public UncheckoutAction(IVfsActivity activity, IVfsProgressMonitor progressMonitor) {
        super(activity.getVersionedFileSystemManager());
        this.m_activity = activity;
        this.m_progressMonitor = progressMonitor;
    }

    public UncheckoutAction(IVfsActivityRecordedFolderItem folderItem) {
        this(folderItem, (IVfsProgressMonitor)null);
    }

    public UncheckoutAction(IVfsActivityRecordedFolderItem folderItem, IVfsProgressMonitor progressMonitor) {
        super(folderItem.getVersionedFileSystemManager());
        this.m_folderItem = folderItem;
        this.m_progressMonitor = progressMonitor;
    }

    public UncheckoutAction(IVfsActivityRecordedFolderItem folderItem, IVfsActivity activity) {
        this(folderItem, activity, null);
    }

    public UncheckoutAction(IVfsActivityRecordedFolderItem folderItem, IVfsActivity activity, IVfsProgressMonitor progressMonitor) {
        super(activity.getVersionedFileSystemManager());
        this.m_folderItem = folderItem;
        this.m_activity = activity;
        this.m_progressMonitor = progressMonitor;
    }

    public UncheckoutAction(IVfsActivity[] activities) {
        this(activities, null);
    }

    public UncheckoutAction(IVfsActivity[] activities, IVfsProgressMonitor progressMonitor) {
        super(activities != null && activities.length > 0 ? activities[0].getVersionedFileSystemManager() : null);
        this.m_activities = activities;
        this.m_progressMonitor = progressMonitor;
    }

    public UncheckoutAction(IVfsActivityRecordedFolderItem[] folderItems) {
        this(folderItems, (IVfsProgressMonitor)null);
    }

    public UncheckoutAction(IVfsActivityRecordedFolderItem[] folderItems, IVfsProgressMonitor progressMonitor) {
        super(folderItems != null && folderItems.length > 0 ? folderItems[0].getVersionedFileSystemManager() : null);
        this.m_folderItems = folderItems;
        this.m_progressMonitor = progressMonitor;
    }

    public UncheckoutAction(FolderItemAndActivityTuppel[] tupples) {
        this(tupples, null);
    }

    public UncheckoutAction(FolderItemAndActivityTuppel[] tupples, IVfsProgressMonitor progressMonitor) {
        super(tupples != null && tupples.length > 0 ? tupples[0].activity.getVersionedFileSystemManager() : null);
        this.m_tupples = tupples;
        this.m_progressMonitor = progressMonitor;
    }

    public void execute() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onStart();
        }
        VfsActionRecorder.getRecorder().start();
        Exception throwable = null;
        boolean alreadyLoggedInActionLog = false;
        try {
            if (this.m_folderItem != null) {
                if (this.m_activity != null) {
                    this.m_folderItem.uncheckout(this.m_activity);
                } else {
                    this.m_folderItem.uncheckout();
                }
            } else if (this.m_activity != null) {
                this.m_activity.uncheckout();
            } else if (this.m_folderItems != null) {
                if (this.m_folderItems[0].asFile() != null) {
                    HashMap<IVfsActivity, ArrayList<IVfsActivityRecordedFolderItem>> activitiesMTFolderItems = new HashMap<IVfsActivity, ArrayList<IVfsActivityRecordedFolderItem>>();
                    boolean j = false;
                    int i = 0;
                    while (i < this.m_folderItems.length) {
                        IVfsActivity currentActivity = this.m_folderItems[i].getOpenActivities()[0];
                        ArrayList<IVfsActivityRecordedFolderItem> currentFolderItems = (ArrayList<IVfsActivityRecordedFolderItem>)activitiesMTFolderItems.get(currentActivity);
                        if (currentFolderItems == null) {
                            currentFolderItems = new ArrayList<IVfsActivityRecordedFolderItem>();
                            activitiesMTFolderItems.put(currentActivity, currentFolderItems);
                        }
                        currentFolderItems.add(this.m_folderItems[i]);
                        ++i;
                    }
                    Iterator activityIterator = activitiesMTFolderItems.keySet().iterator();
                    IVfsActivityRecordedFolderItem[] failedFolderItems = null;
                    while (activityIterator.hasNext()) {
                        IVfsActivity activity = (IVfsActivity)activityIterator.next();
                        IVfsActivityRecordedFolderItem[] folderItems = ((ArrayList)activitiesMTFolderItems.get(activity)).toArray(new IVfsActivityRecordedFolderItem[0]);
                        failedFolderItems = this.m_folderItems[0].getWorkspace().uncheckout(folderItems, activity, false);
                    }
                } else {
                    int i = 0;
                    while (i < this.m_folderItems.length) {
                        this.m_folderItems[i].uncheckout();
                        ++i;
                    }
                }
            } else if (this.m_activities != null) {
                int i = 0;
                while (i < this.m_activities.length) {
                    this.m_activities[i].uncheckout();
                    ++i;
                }
            } else if (this.m_tupples != null) {
                int i = 0;
                while (i < this.m_tupples.length) {
                    this.m_tupples[i].folderItem.uncheckout(this.m_tupples[i].activity);
                    ++i;
                }
            }
        }
        catch (VfsException ignoreAlreadyLogged) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
            throwable = ignoreAlreadyLogged;
            alreadyLoggedInActionLog = true;
        }
        catch (Exception x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            throwable = x;
        }
        VfsActionRecorder.getRecorder().finish();
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onFinish(throwable, alreadyLoggedInActionLog);
        }
        this.m_hasFinished = true;
    }

    public boolean hasFinished() {
        return this.m_hasFinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

