/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.exceptions.ExceptionCategory;
import com.tssap.dtr.client.lib.exceptions.ExceptionSeverity;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.BaseAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class SyncAction
extends BaseAction {
    IVfsFolderItem m_folderItem;
    IVfsFolderItem[] m_folderItems;
    IVfsProgressMonitor m_progressMonitor;
    volatile boolean m_hasFinished = false;
    boolean m_forceSync = false;
    boolean m_previewSync = false;
    private Date m_date;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$actions$SyncAction == null ? (class$com$tssap$dtr$client$lib$vfs$actions$SyncAction = SyncAction.class$("com.tssap.dtr.client.lib.vfs.actions.SyncAction")) : class$com$tssap$dtr$client$lib$vfs$actions$SyncAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$actions$SyncAction;

    public SyncAction(IVfsFolderItem folderItem) {
        this(folderItem, null);
    }

    public SyncAction(IVfsFolderItem folderItem, IVfsProgressMonitor progressMonitor) {
        this(folderItem, progressMonitor, false, false);
    }

    public SyncAction(IVfsFolderItem folderItem, boolean forceSync, boolean previewSync) {
        this(folderItem, null, forceSync, previewSync);
    }

    public SyncAction(IVfsFolderItem folderItem, IVfsProgressMonitor progressMonitor, boolean forceSync, boolean previewSync) {
        super(folderItem.getVersionedFileSystemManager());
        if (previewSync && forceSync) {
            throw new IllegalStateException("Cannot set both preview and force flags simultaneously");
        }
        this.m_folderItem = folderItem;
        this.m_progressMonitor = progressMonitor;
        this.m_forceSync = forceSync;
        this.m_previewSync = previewSync;
    }

    public SyncAction(IVfsFolderItem[] folderItems) {
        this(folderItems, null);
    }

    public SyncAction(IVfsFolderItem[] folderItems, IVfsProgressMonitor progressMonitor) {
        this(folderItems, progressMonitor, false, false);
    }

    public SyncAction(IVfsFolderItem[] folderItems, boolean forceSync, boolean previewSync) {
        this(folderItems, null, forceSync, previewSync);
    }

    public SyncAction(IVfsFolderItem[] folderItems, IVfsProgressMonitor progressMonitor, boolean forceSync, boolean previewSync) {
        super(folderItems != null && folderItems.length > 0 ? folderItems[0].getVersionedFileSystemManager() : null);
        if (previewSync && forceSync) {
            throw new IllegalStateException("Cannot set both preview and force flags simultaneously");
        }
        this.m_folderItems = folderItems;
        this.m_progressMonitor = progressMonitor;
        this.m_forceSync = forceSync;
        this.m_previewSync = previewSync;
    }

    public SyncAction(IVfsFolderItem[] folderItems, Date date, IVfsProgressMonitor progressMonitor) {
        super(folderItems != null && folderItems.length > 0 ? folderItems[0].getVersionedFileSystemManager() : null);
        this.m_date = date;
        this.m_folderItems = folderItems;
        this.m_progressMonitor = progressMonitor;
    }

    public void execute() {
        Exception throwable;
        block32: {
            if (this.m_progressMonitor != null) {
                this.m_progressMonitor.onStart();
            }
            VfsActionRecorder.getRecorder().start();
            throwable = null;
            try {
                if (this.m_folderItem != null) {
                    if (this.m_forceSync) {
                        this.m_folderItem.syncForce();
                    } else if (this.m_previewSync) {
                        this.m_folderItem.syncPreview();
                    } else {
                        this.m_folderItem.sync();
                    }
                    break block32;
                }
                if (this.m_folderItems == null) break block32;
                ArrayList<VfsException> collectedExceptions = new ArrayList<VfsException>(this.m_folderItems.length);
                if (this.m_forceSync) {
                    int i = 0;
                    while (i < this.m_folderItems.length) {
                        try {
                            this.m_folderItems[i].syncForce();
                        }
                        catch (VfsException e) {
                            collectedExceptions.add(e);
                        }
                        ++i;
                    }
                } else if (this.m_previewSync) {
                    int i = 0;
                    while (i < this.m_folderItems.length) {
                        try {
                            this.m_folderItems[i].syncPreview();
                        }
                        catch (VfsException e) {
                            collectedExceptions.add(e);
                        }
                        ++i;
                    }
                } else if (this.m_date != null) {
                    int i = 0;
                    while (i < this.m_folderItems.length) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(this.m_date);
                        try {
                            this.m_folderItems[i].syncToDate(calendar);
                        }
                        catch (VfsException e) {
                            collectedExceptions.add(e);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.m_folderItems.length) {
                        try {
                            this.m_folderItems[i].sync();
                        }
                        catch (VfsException e) {
                            collectedExceptions.add(e);
                        }
                        ++i;
                    }
                }
                switch (collectedExceptions.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw (VfsException)collectedExceptions.get(0);
                    }
                    default: {
                        throw new VfsException(ExceptionSeverity.ERROR, ExceptionCategory.ONE_ARGUMENT_PLACEHOLDER, new Object[]{"There were problems."}, collectedExceptions.toArray(new Throwable[collectedExceptions.size()]));
                    }
                }
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                throwable = e;
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                throwable = e;
            }
        }
        VfsActionRecorder.getRecorder().finish();
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onFinish(throwable);
        }
        this.m_hasFinished = true;
    }

    public boolean hasFinished() {
        return this.m_hasFinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

