/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.BaseAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;

public class RemoveAction
extends BaseAction {
    IVfsFolderItem m_folderItem;
    IVfsFolderItem[] m_folderItems;
    IVfsProgressMonitor m_progressMonitor;
    volatile boolean m_hasFinished = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$actions$RemoveAction == null ? (class$com$tssap$dtr$client$lib$vfs$actions$RemoveAction = RemoveAction.class$("com.tssap.dtr.client.lib.vfs.actions.RemoveAction")) : class$com$tssap$dtr$client$lib$vfs$actions$RemoveAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$actions$RemoveAction;

    public RemoveAction(IVfsFolderItem folderItem) {
        this(folderItem, null);
    }

    public RemoveAction(IVfsFolderItem folderItem, IVfsProgressMonitor progressMonitor) {
        super(folderItem.getVersionedFileSystemManager());
        this.m_folderItem = folderItem;
        this.m_progressMonitor = progressMonitor;
    }

    public RemoveAction(IVfsFolderItem[] folderItems) {
        this(folderItems, null);
    }

    public RemoveAction(IVfsFolderItem[] folderItems, IVfsProgressMonitor progressMonitor) {
        super(folderItems != null && folderItems.length > 0 ? folderItems[0].getVersionedFileSystemManager() : null);
        this.m_folderItems = folderItems;
        this.m_progressMonitor = progressMonitor;
    }

    public void execute() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onStart();
        }
        VfsActionRecorder.getRecorder().start();
        Exception throwable = null;
        try {
            if (this.m_folderItem != null) {
                this.m_folderItem.removeFromClient();
            }
            if (this.m_folderItems != null) {
                int i = 0;
                while (i < this.m_folderItems.length) {
                    this.m_folderItems[i].removeFromClient();
                    ++i;
                }
            }
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            throwable = x;
        }
        catch (Exception x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            throwable = x;
        }
        VfsActionRecorder.getRecorder().finish();
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onFinish(throwable);
        }
        this.m_hasFinished = true;
    }

    public boolean hasFinished() {
        return this.m_hasFinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

