/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.BaseAction;
import com.tssap.dtr.client.lib.vfs.actions.FolderItemAndActivityTuppel;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;

public class MoveAction
extends BaseAction {
    IVfsActivityRecordedFolderItem m_folderItem = null;
    FolderItemAndActivityTuppel[] m_tuppels = null;
    IVfsActivity m_sourceActivity = null;
    IVfsActivity m_destinationActivity = null;
    IVfsProgressMonitor m_progressMonitor;
    volatile boolean m_hasFinished = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$actions$MoveAction == null ? (class$com$tssap$dtr$client$lib$vfs$actions$MoveAction = MoveAction.class$("com.tssap.dtr.client.lib.vfs.actions.MoveAction")) : class$com$tssap$dtr$client$lib$vfs$actions$MoveAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$actions$MoveAction;

    public MoveAction(IVfsActivityRecordedFolderItem folderItem, IVfsActivity sourceActivity, IVfsActivity destinationActivity) {
        this(folderItem, sourceActivity, destinationActivity, null);
    }

    public MoveAction(IVfsActivityRecordedFolderItem folderItem, IVfsActivity sourceActivity, IVfsActivity destinationActivity, IVfsProgressMonitor progressMonitor) {
        super(destinationActivity.getVersionedFileSystemManager());
        this.m_folderItem = folderItem;
        this.m_sourceActivity = sourceActivity;
        this.m_destinationActivity = destinationActivity;
        this.m_progressMonitor = progressMonitor;
    }

    public MoveAction(FolderItemAndActivityTuppel[] folderItemWithSourceActivityTuppels, IVfsActivity destinationActivity) {
        this(folderItemWithSourceActivityTuppels, destinationActivity, null);
    }

    public MoveAction(FolderItemAndActivityTuppel[] folderItemWithSourceActivityTuppels, IVfsActivity destinationActivity, IVfsProgressMonitor progressMonitor) {
        super(destinationActivity.getVersionedFileSystemManager());
        this.m_tuppels = folderItemWithSourceActivityTuppels;
        this.m_destinationActivity = destinationActivity;
        this.m_progressMonitor = progressMonitor;
    }

    public void execute() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onStart();
        }
        VfsActionRecorder.getRecorder().start();
        Exception throwable = null;
        try {
            if (this.m_folderItem != null) {
                this.m_folderItem.move(this.m_sourceActivity, this.m_destinationActivity);
            } else if (this.m_tuppels != null) {
                int i = 0;
                while (i < this.m_tuppels.length) {
                    this.m_tuppels[i].folderItem.move(this.m_tuppels[i].activity, this.m_destinationActivity);
                    ++i;
                }
            }
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            throwable = x;
        }
        catch (Exception x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            throwable = x;
        }
        VfsActionRecorder.getRecorder().finish();
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onFinish(throwable);
        }
        this.m_hasFinished = true;
    }

    public boolean hasFinished() {
        return this.m_hasFinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

