/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.BaseAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;

public class ImmediateDeleteAction
extends BaseAction {
    IVfsActivityRecordedFolderItem m_folderItem;
    IVfsProgressMonitor m_progressMonitor;
    volatile boolean m_hasFinished = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$actions$ImmediateDeleteAction == null ? (class$com$tssap$dtr$client$lib$vfs$actions$ImmediateDeleteAction = ImmediateDeleteAction.class$("com.tssap.dtr.client.lib.vfs.actions.ImmediateDeleteAction")) : class$com$tssap$dtr$client$lib$vfs$actions$ImmediateDeleteAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$actions$ImmediateDeleteAction;

    public ImmediateDeleteAction(IVfsActivityRecordedFolderItem folderItem) {
        this(folderItem, null);
    }

    public ImmediateDeleteAction(IVfsActivityRecordedFolderItem folderItem, IVfsProgressMonitor progressMonitor) {
        super(folderItem.getVersionedFileSystemManager());
        this.m_folderItem = folderItem;
        this.m_progressMonitor = progressMonitor;
    }

    public void execute() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onStart();
        }
        VfsActionRecorder.getRecorder().start();
        Exception throwable = null;
        try {
            this.getVersionedFileSystemManager().immediateHierarchicalDelete(this.m_folderItem);
        }
        catch (VfsException ignoreAlreadyLogged) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
            throwable = ignoreAlreadyLogged;
        }
        catch (Exception x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            throwable = x;
        }
        VfsActionRecorder.getRecorder().finish();
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onFinish(throwable);
        }
        this.m_hasFinished = true;
    }

    public boolean hasFinished() {
        return this.m_hasFinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

