/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.BaseAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;

public class EditAction
extends BaseAction {
    IVfsFolder m_folder;
    IVfsActivityRecordedFolderItem[] m_folderItems;
    IVfsActivity m_activity;
    int m_depth;
    boolean m_exclusive = false;
    IVfsProgressMonitor m_progressMonitor;
    volatile boolean m_hasFinished = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$actions$EditAction == null ? (class$com$tssap$dtr$client$lib$vfs$actions$EditAction = EditAction.class$("com.tssap.dtr.client.lib.vfs.actions.EditAction")) : class$com$tssap$dtr$client$lib$vfs$actions$EditAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$actions$EditAction;

    public EditAction(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity, int depth, boolean exclusive, IVfsProgressMonitor progressMonitor) {
        super(folderItems[0].getVersionedFileSystemManager());
        this.m_folderItems = folderItems;
        this.m_activity = activity;
        this.m_depth = depth;
        this.m_exclusive = exclusive;
        this.m_progressMonitor = progressMonitor;
    }

    public EditAction(IVfsFolder folder, IVfsActivity activity, int depth, boolean exclusive, IVfsProgressMonitor progressMonitor) {
        super(folder.getVersionedFileSystemManager());
        this.m_folder = folder;
        this.m_activity = activity;
        this.m_depth = depth;
        this.m_exclusive = exclusive;
        this.m_progressMonitor = progressMonitor;
    }

    public EditAction(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity, int depth) {
        this(folderItems, activity, depth, false, null);
    }

    public EditAction(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity, int depth, IVfsProgressMonitor progressMonitor) {
        this(folderItems, activity, depth, false, progressMonitor);
    }

    public EditAction(IVfsFolder folder, IVfsActivity activity, int depth) {
        this(folder, activity, depth, false, null);
    }

    public EditAction(IVfsFolder folder, IVfsActivity activity, int depth, IVfsProgressMonitor progressMonitor) {
        this(folder, activity, depth, false, progressMonitor);
    }

    public void execute() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onStart();
        }
        VfsActionRecorder.getRecorder().start();
        Exception throwable = null;
        boolean alreadyLoggedInActionLog = false;
        try {
            if (this.m_folderItems != null && this.m_folderItems[0] != null) {
                if (this.m_activity == null) {
                    this.m_activity = this.m_folderItems[0].getWorkspace().getDefaultActivity();
                }
                if (this.m_folderItems[0] instanceof IVfsFile) {
                    int i = 0;
                    while (i < this.m_folderItems.length) {
                        this.m_folderItems[i].checkOutForEdit(this.m_activity, this.m_exclusive);
                        ++i;
                    }
                } else if (this.m_folderItems[0] instanceof IVfsFolder) {
                    if (this.m_depth == 0 && this.m_exclusive) {
                        int i = 0;
                        while (i < this.m_folderItems.length) {
                            this.m_folderItems[i].checkOutForEdit(this.m_activity, this.m_exclusive);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < this.m_folderItems.length) {
                            ((IVfsFolder)this.m_folderItems[i]).checkOutForEdit(this.m_activity, this.m_depth, this.m_exclusive);
                            ++i;
                        }
                    }
                }
            } else if (this.m_folder != null) {
                if (this.m_activity == null) {
                    this.m_activity = this.m_folder.getWorkspace().getDefaultActivity();
                }
                if (this.m_depth == 0 && this.m_exclusive) {
                    this.m_folder.checkOutForEdit(this.m_activity, this.m_exclusive);
                } else {
                    this.m_folder.checkOutForEdit(this.m_activity, this.m_depth, this.m_exclusive);
                }
            }
        }
        catch (VfsException ignoreAlreadyLogged) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
            throwable = ignoreAlreadyLogged;
            alreadyLoggedInActionLog = true;
        }
        catch (Exception x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            throwable = x;
        }
        VfsActionRecorder.getRecorder().finish();
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onFinish(throwable, alreadyLoggedInActionLog);
        }
        this.m_hasFinished = true;
    }

    public boolean hasFinished() {
        return this.m_hasFinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

