/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.BaseAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;

public class DeleteAction
extends BaseAction {
    IVfsActivityRecordedFolderItem m_folderItem;
    IVfsActivityRecordedFolderItem[] m_folderItems;
    IVfsActivity m_activity;
    IVfsProgressMonitor m_progressMonitor;
    volatile boolean m_hasFinished = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$actions$DeleteAction == null ? (class$com$tssap$dtr$client$lib$vfs$actions$DeleteAction = DeleteAction.class$("com.tssap.dtr.client.lib.vfs.actions.DeleteAction")) : class$com$tssap$dtr$client$lib$vfs$actions$DeleteAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$actions$DeleteAction;

    public DeleteAction(IVfsActivityRecordedFolderItem folderItem, IVfsActivity activity) {
        this(folderItem, activity, null);
    }

    public DeleteAction(IVfsActivityRecordedFolderItem folderItem, IVfsActivity activity, IVfsProgressMonitor progressMonitor) {
        super(folderItem.getVersionedFileSystemManager());
        this.m_folderItem = folderItem;
        this.m_activity = activity;
        this.m_progressMonitor = progressMonitor;
    }

    public DeleteAction(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity) {
        this(folderItems, activity, null);
    }

    public DeleteAction(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity, IVfsProgressMonitor progressMonitor) {
        super(folderItems[0].getVersionedFileSystemManager());
        this.m_folderItems = folderItems;
        this.m_activity = activity;
        this.m_progressMonitor = progressMonitor;
    }

    public void execute() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onStart();
        }
        VfsActionRecorder.getRecorder().start();
        Exception throwable = null;
        try {
            if (this.m_folderItem != null) {
                if (this.m_activity == null) {
                    this.m_activity = this.m_folderItem.getWorkspace().getDefaultActivity();
                }
                this.m_folderItem.checkOutAndDelete(this.m_activity);
            } else if (this.m_folderItems != null) {
                if (this.m_activity == null) {
                    this.m_activity = this.m_folderItems[0].getWorkspace().getDefaultActivity();
                }
                this.m_folderItems[0].getWorkspace().checkoutAndDelete(this.m_folderItems, this.m_activity);
            }
        }
        catch (VfsException ignoreAlreadyLogged) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
            throwable = ignoreAlreadyLogged;
        }
        catch (Exception x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            throwable = x;
        }
        VfsActionRecorder.getRecorder().finish();
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onFinish(throwable);
        }
        this.m_hasFinished = true;
    }

    public boolean hasFinished() {
        return this.m_hasFinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

