/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.BaseAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;

public class CheckoutLockAction
extends BaseAction {
    private IVfsFolder m_folder;
    private IVfsActivityRecordedFolderItem[] m_folderItems;
    private int m_depth;
    private boolean m_setLock = false;
    public static final boolean SET_LOCK = true;
    public static final boolean RESET_LOCK = false;
    private IVfsProgressMonitor m_progressMonitor;
    private volatile boolean m_hasFinished = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$actions$EditAction == null ? (class$com$tssap$dtr$client$lib$vfs$actions$EditAction = CheckoutLockAction.class$("com.tssap.dtr.client.lib.vfs.actions.EditAction")) : class$com$tssap$dtr$client$lib$vfs$actions$EditAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$actions$EditAction;

    public CheckoutLockAction(IVfsActivityRecordedFolderItem[] folderItems, int depth, boolean setLock, IVfsProgressMonitor progressMonitor) {
        super(folderItems[0].getVersionedFileSystemManager());
        this.m_folderItems = folderItems;
        this.m_depth = depth;
        this.m_setLock = setLock;
        this.m_progressMonitor = progressMonitor;
    }

    public CheckoutLockAction(IVfsFolder folder, int depth, boolean setLock, IVfsProgressMonitor progressMonitor) {
        super(folder.getVersionedFileSystemManager());
        this.m_folder = folder;
        this.m_depth = depth;
        this.m_setLock = setLock;
        this.m_progressMonitor = progressMonitor;
    }

    public void execute() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onStart();
        }
        VfsActionRecorder.getRecorder().start();
        Exception throwable = null;
        try {
            if (this.m_folderItems != null && this.m_folderItems[0] != null) {
                int i;
                if (this.m_folderItems[0] instanceof IVfsFile) {
                    i = 0;
                    while (i < this.m_folderItems.length) {
                        if (!this.m_setLock) {
                            ((IVfsFile)this.m_folderItems[i]).resetExclusiveCheckoutLock();
                        } else {
                            ((IVfsFile)this.m_folderItems[i]).setExclusiveCheckoutLock();
                        }
                        ++i;
                    }
                }
                if (this.m_folderItems[0] instanceof IVfsFolder) {
                    i = 0;
                    while (i < this.m_folderItems.length) {
                        if (!this.m_setLock) {
                            ((IVfsFolder)this.m_folderItems[i]).resetExclusiveCheckoutLock(this.m_depth);
                        } else {
                            ((IVfsFolder)this.m_folderItems[i]).setExclusiveCheckoutLock(this.m_depth);
                        }
                        ++i;
                    }
                }
            } else if (this.m_folder != null) {
                if (!this.m_setLock) {
                    this.m_folder.resetExclusiveCheckoutLock(this.m_depth);
                } else {
                    this.m_folder.setExclusiveCheckoutLock(this.m_depth);
                }
            }
        }
        catch (VfsException ignoreAlreadyLogged) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
            throwable = ignoreAlreadyLogged;
        }
        catch (Exception x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            throwable = x;
        }
        VfsActionRecorder.getRecorder().finish();
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onFinish(throwable);
        }
        this.m_hasFinished = true;
    }

    public boolean hasFinished() {
        return this.m_hasFinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

