/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.BaseAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;

public class AddAction
extends BaseAction {
    IVfsFolder m_folder;
    IVfsActivityRecordedFolderItem[] m_folderItems;
    IVfsActivity m_activity;
    int m_depth;
    IVfsProgressMonitor m_progressMonitor;
    volatile boolean m_hasFinished = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$actions$AddAction == null ? (class$com$tssap$dtr$client$lib$vfs$actions$AddAction = AddAction.class$("com.tssap.dtr.client.lib.vfs.actions.AddAction")) : class$com$tssap$dtr$client$lib$vfs$actions$AddAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$actions$AddAction;

    public AddAction(IVfsFolder folder, IVfsActivity activity, int depth) {
        this(folder, activity, depth, null);
    }

    public AddAction(IVfsFolder folder, IVfsActivity activity, int depth, IVfsProgressMonitor progressMonitor) {
        super(folder.getVersionedFileSystemManager());
        this.m_folder = folder;
        this.m_activity = activity;
        this.m_depth = depth;
        this.m_progressMonitor = progressMonitor;
    }

    public AddAction(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity, int depth) {
        this(folderItems, activity, depth, null);
    }

    public AddAction(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity, int depth, IVfsProgressMonitor progressMonitor) {
        super(folderItems[0].getVersionedFileSystemManager());
        this.m_folderItems = folderItems;
        this.m_activity = activity;
        this.m_depth = depth;
        this.m_progressMonitor = progressMonitor;
    }

    public void execute() {
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onStart();
        }
        VfsActionRecorder.getRecorder().start();
        Exception throwable = null;
        try {
            if (this.m_folder != null) {
                if (this.m_activity == null) {
                    this.m_activity = this.m_folder.getWorkspace().getDefaultActivity();
                }
                this.m_folder.createAndCheckout(this.m_activity, this.m_depth);
            } else if (this.m_folderItems != null) {
                if (this.m_activity == null) {
                    this.m_activity = this.m_folderItems[0].getWorkspace().getDefaultActivity();
                }
                this.m_folderItems[0].getWorkspace().createAndCheckout(this.m_folderItems, this.m_activity, this.m_depth);
            }
        }
        catch (VfsException x) {
            throwable = x;
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
        catch (Exception x) {
            throwable = x;
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
        VfsActionRecorder.getRecorder().finish();
        if (this.m_progressMonitor != null) {
            this.m_progressMonitor.onFinish(throwable);
        }
        this.m_hasFinished = true;
    }

    public boolean hasFinished() {
        return this.m_hasFinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

