/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs;

import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.PropertiesFeature;
import java.util.Arrays;
import java.util.Comparator;

public class VfsUtil {
    private VfsUtil() {
    }

    public static Object[] sortItems(Object[] folderItems) {
        if (folderItems == null) {
            Logbook.getWarnChapter().println("Items in VfsUtil.sortItems is <null>.");
            Logbook.getWarnChapter().flush();
            return folderItems;
        }
        if (folderItems.length < 2) {
            return folderItems;
        }
        Arrays.sort(folderItems, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof IVfsFolderItem) {
                    IVfsFolderItem first = (IVfsFolderItem)o1;
                    IVfsFolderItem second = (IVfsFolderItem)o2;
                    if (second == null) {
                        Logbook.getWarnChapter().println("Second argument in VfsUtil.sortItems.compare is <null>.");
                        Logbook.getWarnChapter().flush();
                        return 1;
                    }
                    if (first.asGenericFolder() != null && second.asGenericFolder() == null) {
                        return -1;
                    }
                    if (first.asGenericFolder() == null && second.asGenericFolder() != null) {
                        return 1;
                    }
                }
                if (o1 == null || o2 == null) {
                    Logbook.getWarnChapter().println("Argument in VfsUtil.sortItems.compare is <null>.");
                    Logbook.getWarnChapter().flush();
                    throw new IllegalStateException("Can't compare <null> arguments.");
                }
                String s1 = o1.toString();
                String s2 = o2.toString();
                if (s1 == null || s2 == null) {
                    Logbook.getWarnChapter().println("Argument's toString in VfsUtil.sortItems.compare is <null>.");
                    Logbook.getWarnChapter().flush();
                    throw new IllegalStateException("Can't compare <null> toString'ed arguments.");
                }
                return s1.compareToIgnoreCase(s2);
            }
        });
        return folderItems;
    }

    public static void printVfsLocalAndRemoteVersionInfo(IVfsContext context) {
        new PropertiesFeature().printInfoProperties(context);
    }
}

