/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util.persistence;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.util.persistence.IDepersistFactory;
import com.tssap.dtr.client.lib.util.persistence.IPersistable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;

public abstract class PersistableContainer
implements IPersistable {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$util$persistence$PersistableContainer == null ? (class$com$tssap$dtr$client$lib$util$persistence$PersistableContainer = PersistableContainer.class$("com.tssap.dtr.client.lib.util.persistence.PersistableContainer")) : class$com$tssap$dtr$client$lib$util$persistence$PersistableContainer));
    static final int LF = 10;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$util$persistence$PersistableContainer;

    protected void persistChild(DataOutputStream dataOutputStream, IPersistable child) throws IOException {
        dataOutputStream.writeByte(10);
        dataOutputStream.writeUTF(child.getId());
        child.persist(dataOutputStream);
    }

    protected void persistNoMoreChildren(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(10);
        dataOutputStream.writeUTF("/" + this.getId());
    }

    private String readId(DataInputStream dataInputStream) throws IOException {
        byte b = dataInputStream.readByte();
        if (b != 10) {
            throw new StreamCorruptedException();
        }
        return dataInputStream.readUTF();
    }

    public IPersistable depersist(DataInputStream dataInputStream, IDepersistFactory childrenFactory) throws IOException {
        PersistableContainer persistableContainer;
        String METHOD = "depersist";
        LOCATION.entering("depersist");
        try {
            String id = this.readId(dataInputStream);
            while (!id.startsWith("/")) {
                IPersistable child;
                if (childrenFactory != null) {
                    LOCATION.debugT("depersist", "instantiating {0} ...", new Object[]{id});
                    child = childrenFactory.newInstance(id);
                    if (child == null) {
                        String msg = "No child created by factory for '" + id + "'.";
                        LOCATION.errorT("depersist", msg);
                        throw new IllegalStateException(msg);
                    }
                } else {
                    String msg = "No children factory.";
                    LOCATION.errorT("depersist", msg);
                    throw new IllegalStateException(msg);
                }
                LOCATION.debugT("depersist", "depersisting {0} ...", new Object[]{child});
                child.depersist(dataInputStream, childrenFactory);
                this.onNextChild(child);
                id = this.readId(dataInputStream);
            }
            LOCATION.debugT("depersist", "Terminator ''{0}'' found", new Object[]{id});
            persistableContainer = this;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
        return persistableContainer;
    }

    protected void onNextChild(IPersistable child) {
        String METHOD = "onNextChild";
        String msg = "Unexpected child";
        LOCATION.errorT("onNextChild", msg);
        throw new IllegalStateException(msg);
    }

    public abstract void persist(DataOutputStream var1) throws IOException;

    public abstract String getId();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

