/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util.ipc;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.exceptions.ClientLibraryRuntimeException;
import com.tssap.dtr.client.lib.util.GenericIpc;
import com.tssap.dtr.client.lib.util.GenericIpcListener;
import com.tssap.dtr.client.lib.util.IFileLock;
import com.tssap.dtr.client.lib.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import java.io.IOException;
import java.io.Serializable;

public class IpcSecuredFileLock
implements IFileLock {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$util$ipc$IpcSecuredFileLock == null ? (class$com$tssap$dtr$client$lib$util$ipc$IpcSecuredFileLock = IpcSecuredFileLock.class$("com.tssap.dtr.client.lib.util.ipc.IpcSecuredFileLock")) : class$com$tssap$dtr$client$lib$util$ipc$IpcSecuredFileLock));
    public static final boolean DEMO_MODE = Boolean.getBoolean("vfs.demo_mode");
    private static final String ACQUIRE = "haben will";
    private static final String REJECT = "verzieh dich";
    private boolean _released;
    private volatile boolean _rejected;
    private IVirtualFile _lockFile;
    private String _channel;
    private GenericIpcListener _listener = new MyListener();
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$util$ipc$IpcSecuredFileLock;

    public IpcSecuredFileLock(IVirtualFile lockFile) throws ClientLibraryRuntimeException {
        this._lockFile = lockFile;
        this.joinGroup();
        if (!this.acquireLock()) {
            this.leaveGroup();
            throw new ClientLibraryRuntimeException("Lockfile \"" + this._lockFile + "\" is already in use by another process.");
        }
    }

    public boolean release() {
        if (!this._released) {
            String METHOD = "release";
            LOCATION.infoT("release", "Releasing lock, deleting lockfile \"{0}\" ...", new Object[]{this._lockFile});
            if (this._lockFile.delete()) {
                this.leaveGroup();
                this._released = true;
            }
        }
        return this._released;
    }

    private boolean acquireLock() {
        if (DEMO_MODE) {
            return true;
        }
        String METHOD = "acquireLock";
        try {
            if (this._lockFile.createNewFile()) {
                LOCATION.infoT("acquireLock", "Created lockfile \"{0}\".", new Object[]{this._lockFile});
                return true;
            }
            this._rejected = false;
            int i = 0;
            while (i < 10) {
                LOCATION.infoT("acquireLock", "Sending AQUIRE message to other processes ...");
                GenericIpc.getInstance().send((Serializable)((Object)this._channel), (Serializable)((Object)ACQUIRE));
                try {
                    int millisToWait = 500;
                    LOCATION.infoT("acquireLock", "Waiting for possible REJECT message from other (foreign) process for {0} ms ...", new Object[]{new Integer(500)});
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this._rejected) {
                    LOCATION.infoT("acquireLock", "Lock is already in use by other (foreign) process. Aquiring failed.");
                    return false;
                }
                ++i;
            }
            LOCATION.infoT("acquireLock", "Lock seems to be orphaned. Taking over responsibility for lockfile \"{0}\".", new Object[]{this._lockFile});
            return true;
        }
        catch (IOException e) {
            LogUtil.logException(LOCATION, e);
            return false;
        }
    }

    private void joinGroup() {
        if (DEMO_MODE) {
            return;
        }
        String METHOD = "joinGroup";
        try {
            this._channel = this._lockFile.getCanonicalPath();
        }
        catch (IOException e) {
            LogUtil.logException(LOCATION, e);
        }
        try {
            LOCATION.infoT("joinGroup", "Joining channel \"{0}\" ...", new Object[]{this._channel});
            GenericIpc.getInstance().joinChannel((Serializable)((Object)this._channel), this._listener);
        }
        catch (IOException e) {
            LogUtil.logException(LOCATION, e);
        }
    }

    private void leaveGroup() {
        if (DEMO_MODE) {
            return;
        }
        if (this._channel != null) {
            try {
                String METHOD = "leaveGroup";
                LOCATION.infoT("leaveGroup", "Leaving channel \"{0}\" ...", new Object[]{this._channel});
                GenericIpc.getInstance().leaveChannel((Serializable)((Object)this._channel), this._listener);
            }
            catch (IOException e) {
                LogUtil.logException(LOCATION, e);
            }
            this._channel = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyListener
    implements GenericIpcListener {
        private MyListener() {
        }

        public void foreignMessage(Object message) {
            if (DEMO_MODE) {
                return;
            }
            String METHOD = "foreignMessage";
            if (IpcSecuredFileLock.REJECT.equals(message)) {
                LOCATION.infoT("foreignMessage", "Received REJECT message from other (foreign) process.");
                IpcSecuredFileLock.this._rejected = true;
            } else {
                try {
                    if (IpcSecuredFileLock.this._channel != null) {
                        LOCATION.infoT("foreignMessage", "Received AQUIRE message from other (foreign) process, sending REJECT ...");
                        GenericIpc.getInstance().send((Serializable)((Object)IpcSecuredFileLock.this._channel), (Serializable)((Object)IpcSecuredFileLock.REJECT));
                    }
                }
                catch (IOException e) {
                    LogUtil.logException(LOCATION, e);
                }
            }
        }
    }
}

