/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.EnvironmentVariables;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.StringUtilities;
import com.tssap.dtr.client.lib.util.impl.PlatformBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class Win32
extends PlatformBase {
    static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$util$impl$Win32 == null ? (class$com$tssap$dtr$client$lib$util$impl$Win32 = Win32.class$("com.tssap.dtr.client.lib.util.impl.Win32")) : class$com$tssap$dtr$client$lib$util$impl$Win32));
    static final String NATIVE_FILENAME = "Win32Native.class";
    static final String TEMPDIR_PROPERTY = "java.io.tmpdir";
    static final String OS_NAME_PROPERTY = "os.name";
    static final String PLATFORM_NAME = "Windows";
    boolean m_useNative = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$util$impl$Win32;

    Win32() {
        if (EnvironmentVariables.IGNORE_READONLY_FLAG) {
            return;
        }
        String tempDir = System.getProperty(TEMPDIR_PROPERTY, null);
        if (tempDir == null) {
            LOCATION.warningT("Win32 Platform: No temporary directory for storing native library, using fallback ...");
        } else {
            File outFile = new File(tempDir, NATIVE_FILENAME);
            InputStream inputStream = this.getClass().getResourceAsStream(NATIVE_FILENAME);
            if (inputStream == null) {
                LOCATION.warningT("Win32 Platform: Could not find native library in classes.");
            } else if (!this.copyLibrary(inputStream, outFile)) {
                LOCATION.warningT("Win32 Platform: Could not copy native library.");
            }
            if (!this.loadLibrary(outFile)) {
                Logbook.getWarnChapter().println("Win32 Platform: Could not load native library, using fallback...");
            } else {
                this.m_useNative = true;
            }
        }
    }

    private boolean copyLibrary(InputStream inputStream, File outFile) {
        try {
            int bytesRead;
            FileOutputStream outputStream = new FileOutputStream(outFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
            return true;
        }
        catch (IOException x) {
            LogUtil.infoLogException((Location)LOCATION, (Throwable)x, (boolean)false);
            return false;
        }
    }

    private boolean loadLibrary(File outFile) {
        try {
            System.load(outFile.getAbsolutePath());
            return true;
        }
        catch (Throwable x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            return false;
        }
    }

    public String getPlatformName() {
        return PLATFORM_NAME;
    }

    public String getOperatingSystemName() {
        return System.getProperty(OS_NAME_PROPERTY, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setWritable(File file) {
        boolean bl;
        block6: {
            boolean bl2;
            block5: {
                boolean bl3;
                block4: {
                    try {
                        if (this.m_useNative) {
                            String statusMessage = this._setWritable(file.getAbsolutePath());
                            if (statusMessage != null) {
                                Logbook.getWarnChapter(2).println("native setWritable failed (" + statusMessage + "), trying fallback.");
                                bl3 = this._fallbackSetWritable(file);
                                Object var5_6 = null;
                                String METHOD = "setWritable";
                                break block4;
                            }
                            bl2 = true;
                            break block5;
                        }
                        bl = this._fallbackSetWritable(file);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        String METHOD = "setWritable";
                        LOCATION.debugT("setWritable", "{0} canWrite: {1}", new Object[]{file.getName(), new Boolean(file.canWrite())});
                        throw throwable;
                    }
                }
                LOCATION.debugT("setWritable", "{0} canWrite: {1}", new Object[]{file.getName(), new Boolean(file.canWrite())});
                return bl3;
            }
            Object var5_7 = null;
            String METHOD = "setWritable";
            LOCATION.debugT("setWritable", "{0} canWrite: {1}", new Object[]{file.getName(), new Boolean(file.canWrite())});
            return bl2;
        }
        Object var5_8 = null;
        String METHOD = "setWritable";
        LOCATION.debugT("setWritable", "{0} canWrite: {1}", new Object[]{file.getName(), new Boolean(file.canWrite())});
        return bl;
    }

    private boolean _fallbackSetWritable(File file) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"attrib", "-r", file.getAbsolutePath()});
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return process.exitValue() == 0;
        }
        catch (IOException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            return false;
        }
    }

    public String createGuid() {
        if (this.m_useNative) {
            return this._createGuid();
        }
        return super.createGuid();
    }

    native String _setWritable(String var1);

    native String _createGuid();

    public int openWithDefaultApplication(String absoluteLocalPath) {
        if (StringUtilities.isEmpty(absoluteLocalPath)) {
            return -1;
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", absoluteLocalPath});
            return 0;
        }
        catch (IOException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            return -3;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

