/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util.impl;

import com.tssap.dtr.client.lib.util.IPlatform;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.impl.GenericUnix;
import com.tssap.dtr.client.lib.util.impl.LinuxIntel;
import com.tssap.dtr.client.lib.util.impl.Win32;

public class PlatformFactory {
    public static IPlatform createPlatform() {
        String platform = PlatformFactory.whatOs().toLowerCase();
        if (platform.indexOf("windows") >= 0) {
            return new Win32();
        }
        if (platform.indexOf("sunos") >= 0) {
            Logbook.getWarnChapter().println("Using generic UNIX platform support.");
            return new GenericUnix();
        }
        if (platform.indexOf("hp-ux") >= 0) {
            Logbook.getWarnChapter().println("Using generic UNIX platform support.");
            return new GenericUnix();
        }
        if (platform.indexOf("os/400") >= 0) {
            Logbook.getWarnChapter().println("Using generic UNIX platform support.");
            return new GenericUnix();
        }
        if (platform.indexOf("z/os") >= 0) {
            Logbook.getWarnChapter().println("Using generic UNIX platform support.");
            return new GenericUnix();
        }
        if (platform.indexOf("osf1") >= 0) {
            Logbook.getWarnChapter().println("Using generic UNIX platform support.");
            return new GenericUnix();
        }
        if (platform.indexOf("linux") >= 0) {
            if (PlatformFactory.whatArch().indexOf("86") >= 0) {
                return new LinuxIntel();
            }
            Logbook.getWarnChapter().println("Using generic UNIX platform support.");
            return new GenericUnix();
        }
        Logbook.getErrorChapter().println("Unknown platform detected (OperatingSystem=\"" + PlatformFactory.whatOs() + "\", Architecture=\"" + PlatformFactory.whatArch() + "\").");
        return null;
    }

    static String whatOs() {
        return System.getProperty("os.name", "");
    }

    static String whatArch() {
        return System.getProperty("os.arch", "");
    }
}

