/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util.impl;

import com.tssap.dtr.client.lib.util.IPlatform;
import com.tssap.dtr.client.lib.util.PlatformType;
import com.tssap.dtr.client.lib.util.Timer;
import com.tssap.dtr.client.lib.util.impl.GUID;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Date;

abstract class PlatformBase
implements IPlatform {
    String m_defaultEncoding = null;
    static final int JAVA_1_3 = 13;
    static final int JAVA_1_4 = 14;
    int m_javaVersion = 0;

    PlatformBase() {
    }

    public PlatformType getPlatformType() {
        if (this.getPlatformName().equalsIgnoreCase("Windows")) {
            return PlatformType.WINDOWS;
        }
        return PlatformType.UNKNOWN;
    }

    public boolean setReadOnly(File file) {
        return file.setReadOnly();
    }

    public boolean touch(File file, Date date) {
        return file.setLastModified(date.getTime());
    }

    public String createGuid() {
        return new GUID().toString();
    }

    public String getDefaultCharacterEncoding() {
        if (this.m_defaultEncoding == null) {
            this.m_defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
            if (this.m_defaultEncoding == null) {
                this.m_defaultEncoding = "";
            }
        }
        return this.m_defaultEncoding;
    }

    long getCurrentNanos() {
        return System.currentTimeMillis() * 1000000L;
    }

    public Timer createTimer() {
        Timer timer = new Timer(){
            long m_startNanos;
            {
                this.m_startNanos = PlatformBase.this.getCurrentNanos();
            }

            public void start() {
                this.m_startNanos = PlatformBase.this.getCurrentNanos();
            }

            public long elapsedNanos() {
                return PlatformBase.this.getCurrentNanos() - this.m_startNanos;
            }

            public long elapsedMicros() {
                return this.elapsedNanos() / 1000L;
            }

            public long elapsedMillis() {
                return this.elapsedNanos() / 1000000L;
            }

            public String getElapsedTime() {
                long nanos = this.elapsedNanos();
                StringBuffer elapsedTime = new StringBuffer(30);
                if (nanos > 1000000000L) {
                    long secs = nanos / 1000000000L;
                    if (secs > 60L) {
                        elapsedTime.append(secs / 60L);
                        elapsedTime.append("min ");
                        secs %= 60L;
                    }
                    elapsedTime.append(secs);
                    elapsedTime.append("s");
                } else if (nanos > 1000000L) {
                    elapsedTime.append(nanos / 1000000L);
                    elapsedTime.append("ms");
                } else if (nanos > 1000L) {
                    elapsedTime.append(nanos / 1000L);
                    elapsedTime.append("us");
                } else {
                    elapsedTime.append(nanos);
                    elapsedTime.append("ns");
                }
                return elapsedTime.toString();
            }
        };
        return timer;
    }

    int getJavaVersion() {
        if (this.m_javaVersion == 0) {
            String version = System.getProperty("java.specification.version", "");
            this.m_javaVersion = version.startsWith("1.3") ? 13 : (version.startsWith("1.4") ? 14 : 13);
        }
        return this.m_javaVersion;
    }

    public int openWithDefaultApplication(String absoluteLocalPath) {
        throw new UnsupportedOperationException("Opening with default application is not supported.");
    }

    public abstract boolean setWritable(File var1);

    public abstract String getOperatingSystemName();

    public abstract String getPlatformName();
}

