/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util.impl;

import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.impl.GenericUnix;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class LinuxIntel
extends GenericUnix {
    static final String NATIVE_FILENAME = "LinuxIntelNative.class";
    static final String TEMPDIR_PROPERTY = "java.io.tmpdir";
    static final String OS_NAME_PROPERTY = "os.name";
    static final String PLATFORM_NAME = "Linux-Intel";
    boolean m_useNative = false;

    LinuxIntel() {
        String tempDir = System.getProperty(TEMPDIR_PROPERTY, null);
        if (tempDir == null) {
            Logbook.getWarnChapter(2).println("Linux-Intel Platform: No temporary directory for storing native library, using fallback ...");
        } else {
            File outFile = new File(tempDir, NATIVE_FILENAME);
            if (this.loadLibrary(outFile)) {
                this.m_useNative = true;
            } else {
                InputStream inputStream = this.getClass().getResourceAsStream(NATIVE_FILENAME);
                if (inputStream == null) {
                    Logbook.getWarnChapter(2).println("Linux-Intel Platform: Could not find native library in classes.");
                } else if (!this.copyLibrary(inputStream, outFile)) {
                    Logbook.getWarnChapter(2).println("Linux-Intel Platform: Could not copy native library.");
                }
                if (!this.loadLibrary(outFile)) {
                    Logbook.getInfoChapter(3).println("Linux-Intel Platform: Could not load native library, using fallback...");
                } else {
                    this.m_useNative = true;
                }
            }
        }
    }

    private boolean copyLibrary(InputStream inputStream, File outFile) {
        try {
            int bytesRead;
            FileOutputStream outputStream = new FileOutputStream(outFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
            return true;
        }
        catch (IOException x) {
            return false;
        }
    }

    private boolean loadLibrary(File outFile) {
        try {
            System.load(outFile.getAbsolutePath());
            return true;
        }
        catch (Throwable x) {
            return false;
        }
    }

    public String getPlatformName() {
        return PLATFORM_NAME;
    }

    public String getOperatingSystemName() {
        return System.getProperty(OS_NAME_PROPERTY, "");
    }

    public boolean setWritable(File file) {
        if (this.m_useNative) {
            return this._setWritable(file.getAbsolutePath());
        }
        return super.setWritable(file);
    }

    public native boolean _setWritable(String var1);
}

