/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util.impl;

import com.tssap.dtr.client.lib.util.impl.GUIDFormatException;
import com.tssap.dtr.client.lib.util.impl.GUIDVersionException;
import com.tssap.dtr.client.lib.util.impl.IGUID;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class GUID
implements IGUID,
Serializable {
    private long replow;
    private long rephigh;
    private static long nodeaddress;
    private static long ltime;
    private static short lcount;
    private static Random rand;
    private static Object classLock;
    private static final char[] hexDigits;

    GUID() {
        this.genguidbytime();
    }

    GUID(String value) {
        this.genguidbyname(value);
    }

    GUID(int version) throws GUIDVersionException {
        switch (version) {
            case 0: {
                break;
            }
            case 1: {
                this.genguidbytime();
                break;
            }
            case 4: {
                this.genguidbyrandom();
                break;
            }
            default: {
                throw new GUIDVersionException("Invalid GUID version: " + version);
            }
        }
    }

    GUID(byte[] g) throws GUIDFormatException {
        if (g.length < 16) {
            throw new GUIDFormatException("GUID to short", g);
        }
        try {
            this.replow = ((long)g[15] & 0xFFL) + (((long)g[14] & 0xFFL) << 8) + (((long)g[13] & 0xFFL) << 16) + (((long)g[12] & 0xFFL) << 24) + (((long)g[11] & 0xFFL) << 32) + (((long)g[10] & 0xFFL) << 40) + (((long)g[9] & 0xFFL) << 48) + (((long)g[8] & 0xFFL) << 56);
            this.rephigh = ((long)g[7] & 0xFFL) + (((long)g[6] & 0xFFL) << 8) + (((long)g[5] & 0xFFL) << 16) + (((long)g[4] & 0xFFL) << 24) + (((long)g[3] & 0xFFL) << 32) + (((long)g[2] & 0xFFL) << 40) + (((long)g[1] & 0xFFL) << 48) + (((long)g[0] & 0xFFL) << 56);
        }
        catch (Exception e) {
            throw new GUIDFormatException(e.getMessage(), g);
        }
    }

    GUID(GUID originalGUID, byte[] variantDescriptor) {
        int len = variantDescriptor.length;
        byte[] buffer = new byte[16 + len];
        System.arraycopy(originalGUID.toBytes(), 0, buffer, 0, 16);
        System.arraycopy(variantDescriptor, 0, buffer, 16, len);
        this.genguidbyname(buffer);
    }

    public String toString() {
        char[] buf = new char[36];
        int n = (int)(this.replow & 0xFFFFFFFFFFFFFFFFL);
        buf[35] = hexDigits[n & 0xF];
        buf[34] = hexDigits[n >>> 4 & 0xF];
        buf[33] = hexDigits[n >>> 8 & 0xF];
        buf[32] = hexDigits[n >>> 12 & 0xF];
        buf[31] = hexDigits[n >>> 16 & 0xF];
        buf[30] = hexDigits[n >>> 20 & 0xF];
        buf[29] = hexDigits[n >>> 24 & 0xF];
        buf[28] = hexDigits[n >>> 28 & 0xF];
        n = (int)(this.replow >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        buf[27] = hexDigits[n & 0xF];
        buf[26] = hexDigits[n >>> 4 & 0xF];
        buf[25] = hexDigits[n >>> 8 & 0xF];
        buf[24] = hexDigits[n >>> 12 & 0xF];
        buf[23] = 45;
        buf[22] = hexDigits[n >>> 16 & 0xF];
        buf[21] = hexDigits[n >>> 20 & 0xF];
        buf[20] = hexDigits[n >>> 24 & 0xF];
        buf[19] = hexDigits[n >>> 28 & 0xF];
        buf[18] = 45;
        n = (int)(this.rephigh & 0xFFFFFFFFFFFFFFFFL);
        buf[17] = hexDigits[n & 0xF];
        buf[16] = hexDigits[n >>> 4 & 0xF];
        buf[15] = hexDigits[n >>> 8 & 0xF];
        buf[14] = hexDigits[n >>> 12 & 0xF];
        buf[13] = 45;
        buf[12] = hexDigits[n >>> 16 & 0xF];
        buf[11] = hexDigits[n >>> 20 & 0xF];
        buf[10] = hexDigits[n >>> 24 & 0xF];
        buf[9] = hexDigits[n >>> 28 & 0xF];
        buf[8] = 45;
        n = (int)(this.rephigh >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        buf[7] = hexDigits[n & 0xF];
        buf[6] = hexDigits[n >>> 4 & 0xF];
        buf[5] = hexDigits[n >>> 8 & 0xF];
        buf[4] = hexDigits[n >>> 12 & 0xF];
        buf[3] = hexDigits[n >>> 16 & 0xF];
        buf[2] = hexDigits[n >>> 20 & 0xF];
        buf[1] = hexDigits[n >>> 24 & 0xF];
        buf[0] = hexDigits[n >>> 28 & 0xF];
        return new String(buf);
    }

    public String toHexString() {
        char[] buf = new char[32];
        int n = (int)(this.replow & 0xFFFFFFFFFFFFFFFFL);
        buf[31] = hexDigits[n & 0xF];
        buf[30] = hexDigits[n >>> 4 & 0xF];
        buf[29] = hexDigits[n >>> 8 & 0xF];
        buf[28] = hexDigits[n >>> 12 & 0xF];
        buf[27] = hexDigits[n >>> 16 & 0xF];
        buf[26] = hexDigits[n >>> 20 & 0xF];
        buf[25] = hexDigits[n >>> 24 & 0xF];
        buf[24] = hexDigits[n >>> 28 & 0xF];
        n = (int)(this.replow >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        buf[23] = hexDigits[n & 0xF];
        buf[22] = hexDigits[n >>> 4 & 0xF];
        buf[21] = hexDigits[n >>> 8 & 0xF];
        buf[20] = hexDigits[n >>> 12 & 0xF];
        buf[19] = hexDigits[n >>> 16 & 0xF];
        buf[18] = hexDigits[n >>> 20 & 0xF];
        buf[17] = hexDigits[n >>> 24 & 0xF];
        buf[16] = hexDigits[n >>> 28 & 0xF];
        n = (int)(this.rephigh & 0xFFFFFFFFFFFFFFFFL);
        buf[15] = hexDigits[n & 0xF];
        buf[14] = hexDigits[n >>> 4 & 0xF];
        buf[13] = hexDigits[n >>> 8 & 0xF];
        buf[12] = hexDigits[n >>> 12 & 0xF];
        buf[11] = hexDigits[n >>> 16 & 0xF];
        buf[10] = hexDigits[n >>> 20 & 0xF];
        buf[9] = hexDigits[n >>> 24 & 0xF];
        buf[8] = hexDigits[n >>> 28 & 0xF];
        n = (int)(this.rephigh >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        buf[7] = hexDigits[n & 0xF];
        buf[6] = hexDigits[n >>> 4 & 0xF];
        buf[5] = hexDigits[n >>> 8 & 0xF];
        buf[4] = hexDigits[n >>> 12 & 0xF];
        buf[3] = hexDigits[n >>> 16 & 0xF];
        buf[2] = hexDigits[n >>> 20 & 0xF];
        buf[1] = hexDigits[n >>> 24 & 0xF];
        buf[0] = hexDigits[n >>> 28 & 0xF];
        return new String(buf);
    }

    public byte[] toBytes() {
        byte[] b = new byte[16];
        b[15] = (byte)this.replow;
        b[14] = (byte)(this.replow >>> 8);
        b[13] = (byte)(this.replow >>> 16);
        b[12] = (byte)(this.replow >>> 24);
        b[11] = (byte)(this.replow >>> 32);
        b[10] = (byte)(this.replow >>> 40);
        b[9] = (byte)(this.replow >>> 48);
        b[8] = (byte)(this.replow >>> 56);
        b[7] = (byte)this.rephigh;
        b[6] = (byte)(this.rephigh >>> 8);
        b[5] = (byte)(this.rephigh >>> 16);
        b[4] = (byte)(this.rephigh >>> 24);
        b[3] = (byte)(this.rephigh >>> 32);
        b[2] = (byte)(this.rephigh >>> 40);
        b[1] = (byte)(this.rephigh >>> 48);
        b[0] = (byte)(this.rephigh >>> 56);
        return b;
    }

    private static int byteToInt(byte b) {
        return b < 0 ? 256 + b : b;
    }

    public static GUID fromBytes(byte[] b) throws GUIDFormatException {
        if (b.length != 16) {
            throw new GUIDFormatException();
        }
        try {
            return new GUID(b);
        }
        catch (Exception e) {
            throw new GUIDFormatException(e.getMessage(), b);
        }
    }

    public boolean equals(GUID guid) {
        if (guid == null) {
            return false;
        }
        if (this == guid) {
            return true;
        }
        return this.rephigh == guid.rephigh && this.replow == guid.replow;
    }

    public boolean equals(Object obj) {
        return obj instanceof GUID && this.equals((GUID)obj);
    }

    public int hashCode() {
        return (int)(this.rephigh ^ this.rephigh >> 32 ^ this.replow ^ this.replow >> 32);
    }

    public int getVersion() {
        return (int)(this.rephigh >> 12) & 0xF;
    }

    public int getVariant() {
        return 2;
    }

    public boolean isNil() {
        return this.rephigh == 0L && this.replow == 0L;
    }

    private void genguidbytime() {
        long ts = this.gettimestamp();
        this.rephigh |= 0x1000L | (ts & 0xFFFFFFFFL) << 32 | (ts & 0xFFFF00000000L) >> 16 | (ts & 0xFFF000000000000L) >> 48;
        this.replow |= Long.MIN_VALUE | (long)rand.nextInt(20479) << 48 | nodeaddress;
    }

    private void genguidbyname(String value) {
        this.genguidbyname(value.getBytes());
    }

    private void genguidbyname(byte[] value) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] digest = md5.digest(value);
            this.rephigh |= (long)(0xFF & digest[0]) << 56 | (long)(0xFF & digest[1]) << 48 | (long)(0xFF & digest[2]) << 40 | (long)(0xFF & digest[3]) << 32 | (long)(0xFF & digest[4]) << 24 | (long)(0xFF & digest[5]) << 16 | (long)(0xFF & digest[6]) << 8 | (long)(0xFF & digest[7]);
            this.replow |= (long)(0xFF & digest[8]) << 56 | (long)(0xFF & digest[9]) << 48 | (long)(0xFF & digest[10]) << 40 | (long)(0xFF & digest[11]) << 32 | (long)(0xFF & digest[12]) << 24 | (long)(0xFF & digest[13]) << 16 | (long)(0xFF & digest[14]) << 8 | (long)(0xFF & digest[15]);
            this.replow &= 0x3FFFFFFFFFFFFFFFL;
            this.replow |= Long.MIN_VALUE;
            this.rephigh &= 0xFFFFFFFFFFFF0FFFL;
            this.rephigh |= 0x3000L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    private void genguidbyrandom() {
        this.rephigh |= 0x4000L;
        this.rephigh |= rand.nextLong() & 0xFFFFFFFFFFFF0FFFL;
        this.replow |= rand.nextLong() & 0x3FFFFFFFFFFFFFFFL;
        this.replow |= 0x800000000000L;
    }

    private static long getnodeaddress() {
        try {
            String nodestr = System.getProperty("ieee802.address");
            if (nodestr != null && nodestr.length() == 17) {
                return Long.parseLong(nodestr.substring(0, 2), 16) << 40 | Long.parseLong(nodestr.substring(3, 5), 16) << 32 | Long.parseLong(nodestr.substring(6, 8), 16) << 24 | Long.parseLong(nodestr.substring(9, 11), 16) << 16 | Long.parseLong(nodestr.substring(12, 14), 16) << 8 | Long.parseLong(nodestr.substring(15, 17), 16);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            byte[] ipaddr = InetAddress.getLocalHost().getAddress();
            return 0x800000000000L | (long)rand.nextInt(Short.MAX_VALUE) << 32 | (long)(0xFF & ipaddr[0]) << 24 | (long)(0xFF & ipaddr[1]) << 16 | (long)(0xFF & ipaddr[2]) << 8 | (long)(0xFF & ipaddr[3]);
        }
        catch (Exception exception) {
            return 0x800000000000L | rand.nextLong() & 0x7FFFFFFFFFFFL;
        }
    }

    private long gettimestamp() {
        long mycount;
        long t = System.currentTimeMillis();
        Object object = classLock;
        synchronized (object) {
            if (t != ltime) {
                ltime = t;
                lcount = 0;
                mycount = 0L;
            } else {
                lcount = (short)(lcount + 1);
                mycount = lcount;
            }
        }
        return (t + 12219292800000L) * 10000L + mycount & 0xFFFFFFFFFFFFFFFL;
    }

    public long getTimestamp() {
        if (this.getVersion() != 1) {
            return 0L;
        }
        long t = this.rephigh >> 32 & 0xFFFFFFFFL | this.rephigh << 16 & 0xFFFF00000000L | this.rephigh << 48 & 0xFFF000000000000L;
        return t / 10000L - 12219292800000L;
    }

    public int getClockSeq() {
        return (int)((this.replow & 0x3FFF000000000000L) >> 48);
    }

    public static GUID parseGUID(String guid) throws GUIDFormatException {
        if (guid.length() != 36) {
            throw new GUIDFormatException("GUID too short", guid);
        }
        try {
            GUID g = new GUID(0);
            g.rephigh |= Long.parseLong(guid.substring(0, 8), 16) << 32 | Long.parseLong(guid.substring(9, 13), 16) << 16 | Long.parseLong(guid.substring(14, 18), 16);
            g.replow |= Long.parseLong(guid.substring(19, 23), 16) << 48 | Long.parseLong(guid.substring(24, 36), 16);
            return g;
        }
        catch (Exception e) {
            throw new GUIDFormatException(e.getMessage(), guid);
        }
    }

    public static GUID parseHexGUID(String guid) throws GUIDFormatException {
        if (guid.length() != 32) {
            throw new GUIDFormatException("GUID too short", guid);
        }
        try {
            GUID g = new GUID(0);
            g.rephigh |= Long.parseLong(guid.substring(0, 8), 16) << 32 | Long.parseLong(guid.substring(8, 16), 16);
            g.replow |= Long.parseLong(guid.substring(16, 24), 16) << 32 | Long.parseLong(guid.substring(24, 32), 16);
            return g;
        }
        catch (Exception e) {
            throw new GUIDFormatException(e.getMessage(), guid);
        }
    }

    static {
        ltime = System.currentTimeMillis();
        rand = new Random(System.currentTimeMillis());
        classLock = new Object();
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        nodeaddress = GUID.getnodeaddress();
    }
}

