/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util.impl;

import com.tssap.dtr.client.lib.util.IFileLock;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStreamSecuredFileLock
implements IFileLock {
    private IVirtualFile _lockFile;
    private OutputStream _outputStream;

    public FileOutputStreamSecuredFileLock(IVirtualFile lockFile) throws VfsRuntimeException {
        this._lockFile = lockFile;
        if (this._lockFile.exists() && !this._lockFile.delete()) {
            String errorMessage = "Lockfile \"" + this._lockFile.getAbsolutePath() + "\" is already in use by another process. ";
            Logbook.getErrorChapter().println(errorMessage);
            throw new VfsRuntimeException(errorMessage);
        }
        try {
            this._outputStream = this._lockFile.getFileService().constructFileOutputStream(this._lockFile);
        }
        catch (FileNotFoundException e) {
            throw new VfsRuntimeException("Lockfile \"" + this._lockFile + "\" could not be created.");
        }
        this._lockFile.deleteOnExit();
    }

    public boolean release() {
        try {
            this._outputStream.close();
        }
        catch (IOException e) {
            return false;
        }
        return this._lockFile.delete();
    }
}

