/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class TimeUtilities {
    private static final DateFormat GMT_DATE_FORMAT_WITH_MILLIS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");

    private TimeUtilities() {
    }

    public static String toUrlTimeString(Date date) {
        String mayContainTrailingZeros = GMT_DATE_FORMAT_WITH_MILLIS.format(date);
        while (mayContainTrailingZeros.endsWith("0")) {
            mayContainTrailingZeros = mayContainTrailingZeros.substring(0, mayContainTrailingZeros.length() - 1);
        }
        if (mayContainTrailingZeros.endsWith(".")) {
            return mayContainTrailingZeros.concat("0");
        }
        return mayContainTrailingZeros;
    }

    public static String toTimeString(Date date) {
        String withMills = TimeUtilities.toUrlTimeString(date);
        int lastDot = withMills.lastIndexOf(46);
        return withMills.substring(0, lastDot);
    }

    static {
        GMT_DATE_FORMAT_WITH_MILLIS.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

