/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util;

import com.tssap.dtr.client.lib.util.StringUtilities;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public final class PathUtilities {
    public static final char LOCAL_SEPARATOR_CHAR = File.separatorChar;
    public static final String REMOTE_SEPARATOR = "/";
    public static final String LOCAL_SEPARATOR = File.separator;
    public static final boolean LOCAL_PATH = true;
    public static final boolean NO_LOCAL_PATH = false;
    public static final boolean RELATIVE_PATH = true;
    public static final boolean NO_RELATIVE_PATH = false;
    public static final IFileService REMOTE_FILESERVICE = new IFileService(){

        public IVirtualFile constructFile(IVirtualFile parent, String child) {
            throw new UnsupportedOperationException();
        }

        public IVirtualFile constructFile(String parent, String child) {
            throw new UnsupportedOperationException();
        }

        public IVirtualFile constructFile(String pathname) {
            throw new UnsupportedOperationException();
        }

        public InputStream constructFileInputStream(IVirtualFile file) {
            throw new UnsupportedOperationException();
        }

        public OutputStream constructFileOutputStream(IVirtualFile file) {
            throw new UnsupportedOperationException();
        }

        public IVirtualFile createTempFile(String prefix, String suffix) {
            throw new UnsupportedOperationException();
        }

        public IVirtualFile createTempFile(String prefix, String suffix, IVirtualFile directory) {
            throw new UnsupportedOperationException();
        }

        public String getSeparator() {
            return PathUtilities.REMOTE_SEPARATOR;
        }

        public char getSeparatorChar() {
            return '/';
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getParentPath(String path, boolean isLocalPath, boolean isRelative) {
        int lastSeparatorPos;
        char separator;
        if (path == null || path.length() == 0) {
            return null;
        }
        char c = separator = isLocalPath ? LOCAL_SEPARATOR_CHAR : REMOTE_FILESERVICE.getSeparatorChar();
        if (StringUtilities.endsWith(path, separator)) {
            if (path.length() <= 1) return null;
            lastSeparatorPos = path.lastIndexOf(separator, path.length() - 2);
        } else {
            lastSeparatorPos = path.lastIndexOf(separator);
        }
        if (lastSeparatorPos >= 0) {
            return path.substring(0, lastSeparatorPos + 1);
        }
        if (!isRelative) return null;
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getParentPath(String path, IFileService fileService, boolean isRelative) {
        int lastSeparatorPos;
        if (path == null || path.length() == 0) {
            return null;
        }
        char separator = fileService.getSeparatorChar();
        if (StringUtilities.endsWith(path, separator)) {
            if (path.length() <= 1) return null;
            lastSeparatorPos = path.lastIndexOf(separator, path.length() - 2);
        } else {
            lastSeparatorPos = path.lastIndexOf(separator);
        }
        if (lastSeparatorPos >= 0) {
            return path.substring(0, lastSeparatorPos + 1);
        }
        if (!isRelative) return null;
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getName(String path, IFileService fileService) {
        int lastSeparatorPos;
        if (path == null || path.length() == 0) {
            return null;
        }
        char separator = fileService.getSeparatorChar();
        if (StringUtilities.endsWith(path, separator)) {
            if (path.length() <= 1) return null;
            lastSeparatorPos = path.lastIndexOf(separator, path.length() - 2);
        } else {
            lastSeparatorPos = path.lastIndexOf(separator);
        }
        if (lastSeparatorPos < 0) return path;
        return path.substring(lastSeparatorPos + 1);
    }

    public static String preventTrailingSeparator(String path, boolean isLocalPath) {
        char separator;
        if (path == null || path.length() == 0) {
            return path;
        }
        char c = separator = isLocalPath ? LOCAL_SEPARATOR_CHAR : REMOTE_FILESERVICE.getSeparatorChar();
        if (StringUtilities.endsWith(path, separator)) {
            return StringUtilities.stripLastCharacter(path);
        }
        return path;
    }

    public static String preventTrailingSeparator(String path, IFileService fileService) {
        if (path == null || path.length() == 0) {
            return path;
        }
        char separator = fileService.getSeparatorChar();
        if (StringUtilities.endsWith(path, separator)) {
            return StringUtilities.stripLastCharacter(path);
        }
        return path;
    }

    public static String assureTrailingSeparator(String path, boolean isLocalPath) {
        String separator;
        if (path == null || path.length() == 0) {
            return path;
        }
        String string = separator = isLocalPath ? LOCAL_SEPARATOR : REMOTE_FILESERVICE.getSeparator();
        if (!path.endsWith(separator)) {
            return path.concat(separator);
        }
        return path;
    }

    public static String assureTrailingSeparator(String path, IFileService fileService) {
        if (path == null || path.length() == 0) {
            return path;
        }
        String separator = fileService.getSeparator();
        if (!path.endsWith(separator)) {
            return path.concat(separator);
        }
        return path;
    }

    public static String[] chopPath(String path, boolean isLocalPath) {
        if (path == null || path.length() == 0) {
            return null;
        }
        String separator = isLocalPath ? LOCAL_SEPARATOR : REMOTE_FILESERVICE.getSeparator();
        StringTokenizer tokenizer = new StringTokenizer(path, separator);
        String[] array = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            array[i++] = tokenizer.nextToken();
        }
        return array;
    }

    public static PathRelations comparePaths(String firstPath, String secondPath, IFileService fileService) {
        String firstPathWork = firstPath;
        String secondPathWork = secondPath;
        String separator = fileService.getSeparator();
        if (firstPathWork.endsWith(separator)) {
            firstPathWork = firstPathWork.substring(0, firstPathWork.length() - separator.length());
        }
        if (secondPathWork.endsWith(separator)) {
            secondPathWork = secondPathWork.substring(0, secondPathWork.length() - separator.length());
        }
        if (firstPathWork.equals(secondPathWork)) {
            return PathRelations.IDENTICAL;
        }
        if (firstPathWork.startsWith(secondPathWork)) {
            return PathRelations.FIRST_UNDER_SECOND;
        }
        if (secondPathWork.startsWith(firstPathWork)) {
            return PathRelations.SECOND_UNDER_FIRST;
        }
        return PathRelations.DIFFERENT;
    }

    public static class PathRelations {
        public static final PathRelations IDENTICAL = new PathRelations("IDENTICAL");
        public static final PathRelations FIRST_UNDER_SECOND = new PathRelations("FIRST_UNDER_SECOND");
        public static final PathRelations SECOND_UNDER_FIRST = new PathRelations("SECOND_UNDER_FIRST");
        public static final PathRelations DIFFERENT = new PathRelations("DIFFERENT");
        public final String name;

        private PathRelations(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

