/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util;

import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogUtil {
    public static Location TIME_LOCATION = Location.getLocation((String)"com.tssap.dtr.client.lib.util.TimeLog");

    public static void logElapsedTime(long elapsedMillis, String message) {
        TIME_LOCATION.debugT("[{0} ms]: {1}", new Object[]{new Long(elapsedMillis), message});
    }

    public static void logException(Location location, Throwable throwable) {
        if (location.beError()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println();
            throwable.printStackTrace(printWriter);
            location.errorT(stringWriter.toString());
        }
    }

    public static void debugLogException(Location location, Throwable throwable) {
        if (location.beDebug()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println();
            throwable.printStackTrace(printWriter);
            location.debugT(stringWriter.toString());
        }
    }

    public static void logCaughtException(Location location, Throwable throwable) {
        if (location.beError()) {
            location.errorT("Caught " + throwable.getClass().getName() + ":" + throwable.getMessage());
        }
    }

    public static void infoLogException(Location location, Throwable throwable, boolean doDebugLogException) {
        if (doDebugLogException && location.beDebug()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println();
            throwable.printStackTrace(printWriter);
            location.debugT(stringWriter.toString());
        } else if (location.beInfo()) {
            location.infoT("Info exception " + throwable.getClass().getName() + ": " + throwable.getMessage());
        }
    }

    public static void traceCaughtException(Location location, Throwable throwable, int severity) {
        if (severity == 100) {
            if (location.beDebug()) {
                location.debugT("Caught " + throwable.getClass().getName() + ":" + throwable.getMessage());
            }
        } else if (severity == 300) {
            if (location.beInfo()) {
                location.infoT("Caught " + throwable.getClass().getName() + ":" + throwable.getMessage());
            }
        } else if (severity == 400) {
            if (location.beWarning()) {
                location.warningT("Caught " + throwable.getClass().getName() + ":" + throwable.getMessage());
            }
        } else if (severity == 500) {
            if (location.beError()) {
                location.errorT("Caught " + throwable.getClass().getName() + ":" + throwable.getMessage());
            }
        } else {
            location.errorT("Caught " + throwable.getClass().getName() + ":" + throwable.getMessage());
        }
    }

    public static void traceCaughtExceptionWithStackTrace(Location location, Throwable throwable, int severity) {
        if (severity == 500) {
            if (location.beError()) {
                StringWriter stringWriter = new StringWriter();
                LogUtil.writeStackTrace(stringWriter, throwable, "Caught " + throwable.getClass().getName() + ":" + throwable.getMessage());
                location.errorT(stringWriter.toString());
            }
        } else if (severity == 400) {
            if (location.beWarning()) {
                StringWriter stringWriter = new StringWriter();
                LogUtil.writeStackTrace(stringWriter, throwable, "Caught " + throwable.getClass().getName() + ":" + throwable.getMessage());
                location.warningT(stringWriter.toString());
            }
        } else if (severity == 300) {
            if (location.beInfo()) {
                StringWriter stringWriter = new StringWriter();
                LogUtil.writeStackTrace(stringWriter, throwable, "Caught " + throwable.getClass().getName() + ":" + throwable.getMessage());
                location.infoT(stringWriter.toString());
            }
        } else if (severity == 100) {
            if (location.beDebug()) {
                StringWriter stringWriter = new StringWriter();
                LogUtil.writeStackTrace(stringWriter, throwable, "Caught " + throwable.getClass().getName() + ":" + throwable.getMessage());
                location.debugT(stringWriter.toString());
            }
        } else {
            StringWriter stringWriter = new StringWriter();
            LogUtil.writeStackTrace(stringWriter, throwable, "Caught " + throwable.getClass().getName() + ":" + throwable.getMessage());
            location.errorT(stringWriter.toString());
        }
    }

    private static void writeStackTrace(StringWriter stringWriter, Throwable throwable, String title) {
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (title != null) {
            printWriter.print(title);
        }
        printWriter.println();
        throwable.printStackTrace(printWriter);
    }
}

