/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.util.GenericIpcListener;
import com.tssap.dtr.client.lib.util.LogUtil;
import com.tssap.dtr.client.lib.util.MultiMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

public class GenericIpc {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$util$GenericIpc == null ? (class$com$tssap$dtr$client$lib$util$GenericIpc = GenericIpc.class$("com.tssap.dtr.client.lib.util.GenericIpc")) : class$com$tssap$dtr$client$lib$util$GenericIpc));
    private static final String MULTICAST_GROUP = "228.19.27.31";
    private static final int MULTICAST_PORT = 6612;
    private static final byte LOCALHOST_TTL = 0;
    private static final long MILLIS_PER_100_YEARS = 1094004736L;
    private final long _processId = System.currentTimeMillis() + 1094004736L * (long)(new Random().nextInt(32768) + 1);
    private final MultiMap _localUsersByChannel = new MultiMap();
    private final MultiMap _foreignUsersByChannel = new MultiMap();
    private Receiver _receiver;
    private Sender _sender;
    private final InetAddress _multicastGroup;
    private static final String JOIN_LEAVE_CHANNEL = "join-leave-channel";
    private static GenericIpc __instance;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$util$GenericIpc;

    private GenericIpc() {
        try {
            this._multicastGroup = InetAddress.getByName(MULTICAST_GROUP);
        }
        catch (IOException e) {
            LogUtil.traceCaughtExceptionWithStackTrace(LOCATION, e, 500);
            throw new IllegalStateException("Failed to initialize multicast communication.");
        }
        try {
            this._receiver = new Receiver();
            this._sender = new Sender();
        }
        catch (IOException e) {
            LogUtil.traceCaughtExceptionWithStackTrace(LOCATION, e, 500);
        }
    }

    public static GenericIpc getInstance() {
        if (__instance == null) {
            __instance = new GenericIpc();
        }
        if (GenericIpc.__instance._receiver == null) {
            throw new IllegalStateException("Receiver not initialized.");
        }
        if (GenericIpc.__instance._sender == null) {
            throw new IllegalStateException("Sender not initialized.");
        }
        return __instance;
    }

    public void joinChannel(Serializable channel, GenericIpcListener listener) throws IOException {
        LOCATION.debugT("Local listener ({0}) joining channel <#{1}>", new Object[]{listener, channel});
        MultiMap multiMap = this._localUsersByChannel;
        synchronized (multiMap) {
            boolean alreadyLocallyUsed = this._localUsersByChannel.get(channel) != null;
            this._localUsersByChannel.put(channel, listener);
            if (alreadyLocallyUsed) {
                return;
            }
        }
        this._sender.send((Serializable)((Object)JOIN_LEAVE_CHANNEL), new ChannelUserChange(true, channel));
    }

    public void leaveChannel(Serializable channel, GenericIpcListener listener) throws IOException {
        LOCATION.debugT("Local listener ({0}) leaving channel <#{1}>", new Object[]{listener, channel});
        MultiMap multiMap = this._localUsersByChannel;
        synchronized (multiMap) {
            Collection collection = this._localUsersByChannel.getAll(channel);
            if (collection.size() == 0 || !collection.remove(listener) || collection.size() > 0) {
                return;
            }
        }
        this._sender.send((Serializable)((Object)JOIN_LEAVE_CHANNEL), new ChannelUserChange(false, channel));
    }

    public void send(Serializable channel, Serializable message) throws IOException {
        LOCATION.debugT("Sending message \"{0}\" to channel <#{1}>", new Object[]{message, channel});
        MultiMap multiMap = this._foreignUsersByChannel;
        synchronized (multiMap) {
            if (this._foreignUsersByChannel.get(channel) == null) {
                return;
            }
        }
        this._sender.send(channel, message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Receiver
    implements Runnable {
        final MulticastSocket _receiveSocket = new MulticastSocket(6612);

        Receiver() throws IOException {
            this._receiveSocket.joinGroup(GenericIpc.this._multicastGroup);
            Thread receiverThread = new Thread(this);
            receiverThread.setName("Generic interprocess communication receiver thread");
            receiverThread.setDaemon(true);
            receiverThread.start();
        }

        public void run() {
            try {
                byte[] buf = new byte[Math.max(1400, this._receiveSocket.getReceiveBufferSize())];
                while (!Thread.interrupted()) {
                    try {
                        ObjectInputStream objectInputStream;
                        block21: {
                            ArrayList localUsers;
                            Object message;
                            Object channel;
                            block22: {
                                ChannelUserChange change;
                                long foreignProcessId;
                                block23: {
                                    boolean channelHasLocalUsers;
                                    boolean handshake;
                                    DatagramPacket datagram = new DatagramPacket(buf, buf.length);
                                    this._receiveSocket.receive(datagram);
                                    objectInputStream = new ObjectInputStream(new ByteArrayInputStream(buf));
                                    foreignProcessId = objectInputStream.readLong();
                                    if (GenericIpc.this._processId == foreignProcessId) break block21;
                                    channel = objectInputStream.readObject();
                                    message = objectInputStream.readObject();
                                    LOCATION.debugT("Received message \"{0}\" from channel <#{1}>", new Object[]{message, channel});
                                    if (!channel.equals(GenericIpc.JOIN_LEAVE_CHANNEL)) break block22;
                                    if (!(message instanceof ChannelUserChange)) break block21;
                                    change = (ChannelUserChange)message;
                                    if (!change.joined) break block23;
                                    MultiMap multiMap = GenericIpc.this._foreignUsersByChannel;
                                    synchronized (multiMap) {
                                        boolean bl = handshake = !GenericIpc.this._foreignUsersByChannel.containsKeyValue(change.channel, new Long(foreignProcessId));
                                        if (handshake) {
                                            GenericIpc.this._foreignUsersByChannel.put(change.channel, new Long(foreignProcessId));
                                        }
                                    }
                                    if (!handshake) break block21;
                                    MultiMap multiMap2 = GenericIpc.this._localUsersByChannel;
                                    synchronized (multiMap2) {
                                        channelHasLocalUsers = GenericIpc.this._localUsersByChannel.get(change.channel) != null;
                                    }
                                    if (!channelHasLocalUsers) break block21;
                                    GenericIpc.this._sender.send((Serializable)((Object)GenericIpc.JOIN_LEAVE_CHANNEL), new ChannelUserChange(true, change.channel));
                                    break block21;
                                }
                                MultiMap multiMap = GenericIpc.this._foreignUsersByChannel;
                                synchronized (multiMap) {
                                    GenericIpc.this._foreignUsersByChannel.remove(change.channel, new Long(foreignProcessId));
                                }
                            }
                            MultiMap multiMap = GenericIpc.this._localUsersByChannel;
                            synchronized (multiMap) {
                                localUsers = new ArrayList(GenericIpc.this._localUsersByChannel.getAll(channel));
                            }
                            int i = 0;
                            while (i < localUsers.size()) {
                                GenericIpcListener listener = (GenericIpcListener)localUsers.get(i);
                                try {
                                    listener.foreignMessage(message);
                                }
                                catch (Exception e) {
                                    LogUtil.traceCaughtExceptionWithStackTrace(LOCATION, e, 300);
                                }
                                ++i;
                            }
                        }
                        objectInputStream.close();
                    }
                    catch (Exception e) {
                        LogUtil.traceCaughtExceptionWithStackTrace(LOCATION, e, 500);
                    }
                }
            }
            catch (Exception e) {
                LogUtil.traceCaughtExceptionWithStackTrace(LOCATION, e, 500);
            }
        }
    }

    private class Sender {
        final MulticastSocket _sendSocket = new MulticastSocket(6612);

        Sender() throws IOException {
            this._sendSocket.setTimeToLive(0);
            this._sendSocket.joinGroup(GenericIpc.this._multicastGroup);
        }

        void send(Serializable channel, Serializable message) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeLong(GenericIpc.this._processId);
            objectOutputStream.writeObject(channel);
            objectOutputStream.writeObject(message);
            objectOutputStream.flush();
            DatagramPacket datagram = new DatagramPacket(byteArrayOutputStream.toByteArray(), byteArrayOutputStream.size(), GenericIpc.this._multicastGroup, 6612);
            this._sendSocket.send(datagram, (byte)0);
            LOCATION.debugT("Sent message \"{0}\" to channel <#{1}>", new Object[]{message, channel});
        }
    }

    private static class ChannelUserChange
    implements Serializable {
        final boolean joined;
        final Serializable channel;

        ChannelUserChange(boolean joined, Serializable channel) {
            this.joined = joined;
            this.channel = channel;
        }

        public String toString() {
            return "[" + (this.joined ? "joining" : "leaving") + " channel <#" + this.channel + ">]";
        }
    }
}

