/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.util;

public final class Assert {
    private Assert() {
    }

    public static final void isNull(Object reference) throws IllegalStateException {
        if (reference != null) {
            throw new IllegalStateException("Object must be <null>.");
        }
    }

    public static final void isNotNull(Object reference) throws NullPointerException {
        if (reference == null) {
            throw new NullPointerException("Object must not be <null>.");
        }
    }

    public static final void isTrue(boolean expression) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException("Expression must be true (but is false).");
        }
    }

    public static final void isFalse(boolean expression) throws IllegalStateException {
        if (expression) {
            throw new IllegalStateException("Expression must be false (but is true).");
        }
    }

    public static final void isStringNotEmpty(String s) throws IllegalStateException {
        if (s == null || s.length() == 0) {
            throw new IllegalStateException("String must contain characters.");
        }
    }

    public static final void isStringNotBlank(String s) throws IllegalStateException {
        Assert.isStringNotEmpty(s);
        if (s.trim().length() == 0) {
            throw new IllegalStateException("String must contain non-whitespace characters.");
        }
    }
}

