/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.um.impl;

import com.tssap.dtr.client.lib.um.IGroup;
import com.tssap.dtr.client.lib.um.IPrincipal;
import com.tssap.dtr.client.lib.um.IPrincipalManager;
import com.tssap.dtr.client.lib.um.IUser;
import com.tssap.dtr.client.lib.um.PrincipalException;
import com.tssap.dtr.client.lib.um.impl.Group;
import com.tssap.dtr.client.lib.um.impl.Principal;
import com.tssap.dtr.client.lib.um.impl.User;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.util.URLUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.IServer;
import java.util.HashMap;
import java.util.Iterator;

public class PrincipalManager
implements IPrincipalManager {
    private static final String PRINCIPAL_BASE_PATH_PROPERTY = "XCM:principals-base-path";
    private static final String BASE_PATH_LOCATION_RESOURCE = "/";
    private static final String USERS_RELATIVE_PATH_NAME = "users";
    private static final String GROUPS_RELATIVE_PATH_NAME = "groups";
    private String principalsBasePath = "/principals";
    private static HashMap _principalManagers = new HashMap();
    private IVersionedFileSystemManager vfsManager;
    private boolean _invalid;
    private HashMap principalsByName;

    private PrincipalManager(IVersionedFileSystemManager vfsManager) throws PrincipalException {
        this.vfsManager = vfsManager;
        this.readBasePaths();
    }

    public static IPrincipalManager getPrincipalManager(IVersionedFileSystemManager vfsManager) throws PrincipalException {
        if (vfsManager == null) {
            return null;
        }
        if (_principalManagers.containsKey(vfsManager)) {
            return (IPrincipalManager)_principalManagers.get(vfsManager);
        }
        PrincipalManager principalManager = new PrincipalManager(vfsManager);
        _principalManagers.put(vfsManager, principalManager);
        return principalManager;
    }

    public static void releasePrincipalManager(IPrincipalManager principalManager) {
        PrincipalManager manager = (PrincipalManager)principalManager;
        IVersionedFileSystemManager vfsManager = manager.getVfsManager();
        _principalManagers.remove(vfsManager);
        manager.setVfsManager(null);
        manager.setInvalid();
    }

    public IVersionedFileSystemManager getVfsManager() {
        this.checkState();
        return this.vfsManager;
    }

    private void checkState() {
        if (this._invalid) {
            throw new IllegalStateException("ACL manager was released");
        }
    }

    public boolean isReleased() {
        return this._invalid;
    }

    private void setInvalid() {
        this._invalid = true;
    }

    private void setVfsManager(IVersionedFileSystemManager vfsManager) {
        this.vfsManager = vfsManager;
    }

    public IGroup getGroup(String name) {
        this.checkState();
        Group group = new Group(this, name);
        return group;
    }

    public IPrincipal getPrincipal(short type) {
        this.checkState();
        return new Principal(this, null, type);
    }

    public IUser getUser(String name) {
        this.checkState();
        User user = new User(this, name);
        return user;
    }

    public IPrincipal getPrincipal(String url) {
        this.checkState();
        return new Principal(this, this.getPrincipalNameFromURL(url), this.getPrincipalTypeFromURL(url));
    }

    private String getPrincipalNameFromURL(String url) {
        String[] choppedUrl = URLUtilities.chopURL(url);
        if (choppedUrl != null && choppedUrl.length == 4) {
            String[] choppedPath = PathUtilities.chopPath(URLUtilities.chopURL(url)[3], false);
            if (choppedPath != null && choppedPath.length > 1) {
                return choppedPath[choppedPath.length - 1];
            }
            return null;
        }
        return null;
    }

    private short getPrincipalTypeFromURL(String url) {
        String[] choppedUrl = URLUtilities.chopURL(url);
        if (choppedUrl != null && choppedUrl.length == 4) {
            String[] choppedPath = PathUtilities.chopPath(URLUtilities.chopURL(url)[3], false);
            if (choppedPath != null && choppedPath.length > 1) {
                if (choppedPath[choppedPath.length - 2].equals(USERS_RELATIVE_PATH_NAME)) {
                    return 1;
                }
                if (choppedPath[choppedPath.length - 2].equals(GROUPS_RELATIVE_PATH_NAME)) {
                    return 2;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    private void readBasePaths() throws PrincipalException {
    }

    String getURLForPrincipal(String name, short type) throws PrincipalException {
        if (name == null) {
            return null;
        }
        if (type == 1 || type == 2) {
            IConfiguration config = Configuration.getConfiguration();
            IVfsContext context = this.vfsManager.getCurrentContext();
            IClient client = config.getClient(context.getClientName());
            ILogicalSystem logicalSystem = client.getLogicalSystem();
            Iterator it = logicalSystem.repositoryServers();
            IServer server = null;
            while (it.hasNext()) {
                if (server == null) {
                    server = (IRepositoryServer)it.next();
                    continue;
                }
                throw new PrincipalException("Only one repository server in configuration supported.");
            }
            String serverURL = server.getUrl();
            if (type == 1) {
                return PathUtilities.preventTrailingSeparator(server.getUrl(), false) + PathUtilities.assureTrailingSeparator(this.principalsBasePath, false) + PathUtilities.assureTrailingSeparator(USERS_RELATIVE_PATH_NAME, false) + name;
            }
            if (type == 2) {
                return PathUtilities.preventTrailingSeparator(server.getUrl(), false) + PathUtilities.assureTrailingSeparator(this.principalsBasePath, false) + PathUtilities.assureTrailingSeparator(GROUPS_RELATIVE_PATH_NAME, false) + name;
            }
            return null;
        }
        return null;
    }

    public IPrincipal getPrincipalForName(String name, short type) {
        this.checkState();
        return new Principal(this, name, type);
    }
}

