/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.um.impl;

import com.tssap.dtr.client.lib.um.IGroup;
import com.tssap.dtr.client.lib.um.IPrincipal;
import com.tssap.dtr.client.lib.um.IPrincipalManager;
import com.tssap.dtr.client.lib.um.IUser;
import com.tssap.dtr.client.lib.um.PrincipalException;
import com.tssap.dtr.client.lib.um.PrincipalTypes;
import com.tssap.dtr.client.lib.um.impl.Group;
import com.tssap.dtr.client.lib.um.impl.PrincipalManager;
import com.tssap.dtr.client.lib.um.impl.User;

public class Principal
implements IPrincipal {
    private String name = "";
    private short status = 0;
    private short type;
    private PrincipalManager principalManager;

    Principal(PrincipalManager principalManager, String name, short type) {
        this.principalManager = principalManager;
        this.name = name == null ? "" : name;
        if (!PrincipalTypes.isAllowedType(type)) {
            throw new IllegalArgumentException("PrincipalType is not valid");
        }
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public IPrincipalManager getPrincipalManager() {
        return this.principalManager;
    }

    public short getStatus() {
        return this.status;
    }

    public short getType() {
        return this.type;
    }

    public String getURL() throws PrincipalException {
        return this.principalManager.getURLForPrincipal(this.name, this.type);
    }

    public IGroup asGroup() {
        if (this instanceof Group) {
            return (IGroup)((Object)this);
        }
        return null;
    }

    public IUser asUser() {
        if (this instanceof User) {
            return (IUser)((Object)this);
        }
        return null;
    }

    public boolean equals(Object arg0) {
        boolean result = true;
        if (arg0 instanceof Principal) {
            result &= this.name.equals(((Principal)arg0).name);
            result &= this.principalManager == ((Principal)arg0).principalManager;
            result &= this.status == ((Principal)arg0).status;
            return result &= this.type == ((Principal)arg0).type;
        }
        return false;
    }
}

