/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.um;

public class PrincipalTypes {
    public static final short NONE = 0;
    public static final short USER = 1;
    public static final short GROUP = 2;
    public static final short ALL = 3;
    public static final short AUTHENTICATED = 4;
    public static final short UNAUTHENTICATED = 5;

    private PrincipalTypes() {
    }

    public static short getPrincipalTypeByName(String name) {
        if (name.compareTo("none") == 0) {
            return 0;
        }
        if (name.compareTo("user") == 0) {
            return 1;
        }
        if (name.compareTo("group") == 0) {
            return 2;
        }
        if (name.compareTo("all") == 0) {
            return 3;
        }
        if (name.compareTo("authenticated") == 0) {
            return 4;
        }
        if (name.compareTo("unauthenticated") == 0) {
            return 5;
        }
        return -1;
    }

    public static String getPrincipalTypeByShort(short principalType) {
        switch (principalType) {
            case 0: {
                return "none";
            }
            case 1: {
                return "user";
            }
            case 2: {
                return "group";
            }
            case 3: {
                return "all";
            }
            case 4: {
                return "authenticated";
            }
            case 5: {
                return "unauthenticated";
            }
        }
        return null;
    }

    public static boolean isAllowedType(short principalType) {
        return 0 <= principalType && principalType <= 5;
    }
}

