/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.propagation;

import com.tssap.dtr.client.lib.propagation.PropagatableBlobStream;
import com.tssap.dtr.client.lib.propagation.clientapi.IExportable;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatableBlob;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatableBlobSegment;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagator;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import java.io.IOException;
import java.io.InputStream;

class SegmentedExportStream
extends PropagatableBlobStream
implements IExportable {
    private IPropagator propagator;
    private IPropagatableBlob blob;
    private IPropagatableBlobSegment[] segments;
    private int currentSegmentNo;

    public SegmentedExportStream(IPropagator propagator, String propagatableBlobID) throws PropagationException {
        super(null, null);
        this.propagator = propagator;
        this.blob = propagator.getPropagatableBlobUsingID(propagatableBlobID);
        this.segments = this.blob.getSegments();
        this.currentSegmentNo = -1;
        this.loadNextPropagatableSegment();
    }

    private boolean loadNextPropagatableSegment() throws PropagationException {
        if (this.currentSegmentNo < this.segments.length - 1) {
            this.contentStream = this.segments[++this.currentSegmentNo].getSegmentBlob();
            return true;
        }
        return false;
    }

    public InputStream getContents() throws PropagationException {
        return this;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead == -1) {
            try {
                if (this.loadNextPropagatableSegment()) {
                    bytesRead = this.read(b, off, len);
                }
            }
            catch (PropagationException e) {
                throw new IOException(e.toString());
            }
        }
        return bytesRead;
    }
}

