/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.propagation;

import com.tssap.dtr.client.lib.propagation.DtrConnection;
import com.tssap.dtr.client.lib.propagation.ExportContentValidationStream;
import com.tssap.dtr.client.lib.propagation.Importable;
import com.tssap.dtr.client.lib.propagation.PropagatableBlob;
import com.tssap.dtr.client.lib.propagation.PropagatableBlobSegment;
import com.tssap.dtr.client.lib.propagation.PropagatableBlobStream;
import com.tssap.dtr.client.lib.propagation.PropagatableHeaderInfo;
import com.tssap.dtr.client.lib.propagation.PropagationUtil;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatableBlob;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatableBlobSegment;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatableHeaderInfo;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagator;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.ErrorEntity;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StreamEntity;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.ProppatchRequest;
import com.tssap.dtr.client.lib.protocol.requests.http.GetRequest;
import com.tssap.dtr.client.lib.protocol.requests.http.OptionsRequest;
import com.tssap.dtr.client.lib.protocol.requests.http.PutRequest;
import com.tssap.dtr.client.lib.protocol.requests.xcm.ActivityIntersectionReport;
import com.tssap.dtr.client.lib.protocol.requests.xcm.AdminOperationRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

abstract class Requestor {
    protected static final String PROPAGATION_REQUEST_ID = "propagation-request-id";
    protected static final int PROPAGATION_REQUEST_ID_MAX_LENGTH = 80;
    protected static final String OID = "oid";
    protected static final String VERSION_SET_STATE = "version-set-state";
    protected static final String CLOSED = "closed";
    protected static final String VERSION_SET_STATE_OPEN = "open";
    protected static final String VERSION_SET_STATE_CLOSED = "closed";
    protected static final String MAX_REQUEST_CONTENT_LENGTH = "max-request-content-length";
    protected static final String SUPPORTS_SEGMENTED_PROPAGATION = "supports-segmented-propagation";
    protected static final String WORKSPACE_OWNERREP_ID = "workspace-owner-repositoryid";
    protected static final String REPOSITORY_ID = "repositoryid";
    public static final String XCM_NAMESPACE = XCM.NAMESPACE;
    public static final String XCM_PREFIX = "XCM:";
    public static final String DAV_NAMESPACE = "DAV:";
    public static final String DAV_PREFIX = "D:";
    public static final String REMOTE_SEPARATOR = "/";
    protected static final String GUID_QUALIFIER = "nonvresbyid";
    protected static final String ACT_URL = "/act/";
    protected static final String PROP_URL = "/prop/";
    protected static final String WORKING_PROPS = "wp/";
    protected static final String XCM_RESOURCE_PATH = "path";
    public static final String XCM_NON_IMPORTED_VERSIONS_COUNT = "nonimported-versions-count";
    protected static final String PROP_BLOB_SEGMENT_NUMBER = "propagatable-blob-segment-number";
    protected static final String PROP_BLOB_SEGMENTS_COUNT = "propagatable-segments-count";
    protected static final String PROP_BLOB_SEGMENT_LENGTH = "propagatable-blob-length";
    protected static final String PROP_ADMIN_OPERATIONS = "admin-operations";
    protected static final String PROP_ADMIN_OPERATION_WSP_REOPEN = "force-reopen-workspace";
    private DtrConnection dtrConnection;

    Requestor() {
    }

    protected IResponse performRequest(IRequest request, String errorMessage) throws PropagationException {
        IResponse response = null;
        try {
            Connection connection = this.dtrConnection.openConnection();
            response = request.perform((IConnection)connection, true);
        }
        catch (HTTPException ex) {
            throw new PropagationException(ex.getMessage());
        }
        catch (Exception ex) {
            throw new PropagationException(errorMessage + ": " + ex.getMessage());
        }
        return response;
    }

    protected void setDtrConnection(DtrConnection dtrConnection) {
        this.dtrConnection = dtrConnection;
    }

    protected DtrConnection getDtrConnection() {
        return this.dtrConnection;
    }

    protected String quote(String s) {
        return "\"" + s + "\"";
    }

    protected String getCombinedErrorMessage(String errorBase, IResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("Cannot access status of " + this.quote(null) + " response!");
        }
        return errorBase + ". Response status = " + response.getStatus() + " (" + response.getStatusDescription() + ")";
    }

    public String getProperty(String resourceUrl, String property, String errorBase) throws PropagationException {
        return this.getProperty(resourceUrl, property);
    }

    protected boolean getBooleanProperty(String resourceUrl, String property) throws PropagationException {
        String value = this.getProperty(resourceUrl, property);
        return value != null && value.equalsIgnoreCase("T");
    }

    public int setProperty(String resourceUrl, String property, String value) throws PropagationException {
        return this.setProperty(resourceUrl, XCM_PREFIX, property, value, XCM_NAMESPACE);
    }

    public int setProperty(String resourceUrl, String prefix, String property, String value, String namespace) throws PropagationException {
        PropertyElement propertyElement;
        ProppatchRequest proppatchRequest = new ProppatchRequest(resourceUrl);
        proppatchRequest.addPropertySet(prefix + property, value, namespace);
        IResponse response = this.performRequest((IRequest)proppatchRequest, "");
        int status = response.getStatus();
        if (status != 200 && (propertyElement = PropagationUtil.getFirstPropertyElement(prefix, property, namespace, response, proppatchRequest)).getStatusCode() != 200) {
            throw PropagationUtil.getNewPreconditionException(propertyElement);
        }
        return status;
    }

    public String getProperty(String url, String property) throws PropagationException {
        return this.getProperty(url, XCM_PREFIX, property, XCM_NAMESPACE);
    }

    public String getProperty(String url, String prefix, String property, String namespace) throws PropagationException {
        PropfindRequest request = new PropfindRequest(url);
        request.addPropertyGet(prefix + property, namespace);
        request.setDepth(Depth.DEPTH_0);
        IResponse response = this.performRequest((IRequest)request, "");
        if (response.getStatus() == 404) {
            throw new PropagationPreconditionException(REMOTE_SEPARATOR + url, response.getStatusDescription(), 404);
        }
        PropertyElement propertyElement = PropagationUtil.getFirstPropertyElement(prefix, property, namespace, response, request);
        if (propertyElement.getStatusCode() != 200) {
            throw PropagationUtil.getNewPreconditionException(propertyElement);
        }
        return propertyElement.getValue();
    }

    protected PropertyElement getFirstPropertyElement(String property, IResponse response, ProppatchRequest request, String errorBase) throws PropagationException {
        return PropagationUtil.getFirstPropertyElement(XCM_PREFIX, property, XCM_NAMESPACE, response, request);
    }

    protected boolean isEmptyString(String str) {
        return str == null || str.trim().length() == 0;
    }

    protected String[] getPredecessorSet(String sourceWSPath, String targetWSPath, String[] absoluteRemotePaths, int level, boolean forPropagation) throws PropagationException {
        String[] predecessors = new String[]{};
        if (this.isEmptyString(sourceWSPath)) {
            throw new PropagationPreconditionException("Must specify source workspace");
        }
        if (!forPropagation && this.isEmptyString(targetWSPath)) {
            throw new PropagationPreconditionException("Must specify target workspace");
        }
        try {
            ActivityIntersectionReport report = new ActivityIntersectionReport(sourceWSPath);
            report.setMaximumLevel(level);
            if (forPropagation) {
                report.applyToPropagation(sourceWSPath);
            } else {
                report.applyToIntegration(sourceWSPath, targetWSPath);
            }
            int pathCount = 0;
            int index = 0;
            while (index < absoluteRemotePaths.length) {
                if (absoluteRemotePaths[index] != null && absoluteRemotePaths[index].trim().length() != 0) {
                    report.addActivity(absoluteRemotePaths[index]);
                    ++pathCount;
                }
                ++index;
            }
            if (pathCount == 0) {
                throw new PropagationPreconditionException("Must specify atleast one activity / propagationlist");
            }
            IResponse response = this.performRequest((IRequest)report, "");
            if (response.getStatus() != 207) {
                throw new PropagationException(response.getStatusDescription());
            }
            ResourceElement elem = report.getResource(0);
            if (elem != null) {
                Iterator paths = elem.getPaths();
                predecessors = new String[elem.countPaths()];
                int index2 = 0;
                while (paths.hasNext()) {
                    String withOutContext = (String)paths.next();
                    int baseIndex = withOutContext.indexOf(ACT_URL);
                    if (baseIndex > 0) {
                        withOutContext = withOutContext.substring(baseIndex);
                    } else {
                        baseIndex = withOutContext.indexOf(PROP_URL);
                        if (baseIndex > 0) {
                            withOutContext = withOutContext.substring(baseIndex);
                        }
                    }
                    predecessors[index2++] = withOutContext;
                }
            }
        }
        catch (PropagationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PropagationException(ex.toString());
        }
        return predecessors;
    }

    protected IPropagatableBlob getPropagatableBlob(IPropagator propagator, String propagatableBlobURL) throws PropagationException {
        PropagatableBlob blob = null;
        PropfindRequest request = new PropfindRequest(propagatableBlobURL);
        request.addPropertyGet("XCM:propagatable-segments-count", XCM_NAMESPACE);
        request.addPropertyGet("XCM:propagatable-blob-length", XCM_NAMESPACE);
        request.setDepth(Depth.DEPTH_0);
        IResponse response = this.performRequest((IRequest)request, "");
        if (response.getStatus() == 404) {
            throw new PropagationPreconditionException(REMOTE_SEPARATOR + propagatableBlobURL, response.getStatusDescription(), 404);
        }
        PropertyElement segmentCount = PropagationUtil.getFirstPropertyElement(XCM_PREFIX, PROP_BLOB_SEGMENTS_COUNT, XCM_NAMESPACE, response, request);
        PropertyElement segmentLength = PropagationUtil.getFirstPropertyElement(XCM_PREFIX, PROP_BLOB_SEGMENT_LENGTH, XCM_NAMESPACE, response, request);
        if (segmentCount.getStatusCode() != 200 && segmentLength.getStatusCode() != 200) {
            if (segmentCount.getStatusCode() == 200) {
                throw PropagationUtil.getNewPreconditionException(segmentCount);
            }
            throw PropagationUtil.getNewPreconditionException(segmentLength);
        }
        blob = new PropagatableBlob(propagator, propagatableBlobURL, Integer.parseInt(segmentCount.getValue()), Long.parseLong(segmentLength.getValue()));
        return blob;
    }

    protected IPropagatableBlobSegment getPropagatableBlobSegment(IPropagator propagator, String propagatableBlobSegmentURL) throws PropagationException {
        PropagatableBlobSegment blob = null;
        PropfindRequest request = new PropfindRequest(propagatableBlobSegmentURL);
        request.addPropertyGet("XCM:propagatable-blob-segment-number", XCM_NAMESPACE);
        request.addPropertyGet("XCM:propagatable-blob-length", XCM_NAMESPACE);
        request.setDepth(Depth.DEPTH_0);
        IResponse response = this.performRequest((IRequest)request, "");
        if (response.getStatus() == 404) {
            throw new PropagationPreconditionException(REMOTE_SEPARATOR + propagatableBlobSegmentURL, response.getStatusDescription(), 404);
        }
        PropertyElement segmentNumber = PropagationUtil.getFirstPropertyElement(XCM_PREFIX, PROP_BLOB_SEGMENT_NUMBER, XCM_NAMESPACE, response, request);
        PropertyElement segmentLength = PropagationUtil.getFirstPropertyElement(XCM_PREFIX, PROP_BLOB_SEGMENT_LENGTH, XCM_NAMESPACE, response, request);
        if (segmentNumber.getStatusCode() != 200 && segmentLength.getStatusCode() != 200) {
            if (segmentNumber.getStatusCode() == 200) {
                throw PropagationUtil.getNewPreconditionException(segmentNumber);
            }
            throw PropagationUtil.getNewPreconditionException(segmentLength);
        }
        blob = new PropagatableBlobSegment(propagator, propagatableBlobSegmentURL, Integer.parseInt(segmentNumber.getValue()), Integer.parseInt(segmentLength.getValue()));
        return blob;
    }

    protected IPropagatableBlobSegment[] getPropagatableBlobSegments(IPropagator propagator, String propagatableBlobURL) throws PropagationException {
        PropfindRequest request = new PropfindRequest(propagatableBlobURL);
        request.addPropertyGet("XCM:propagatable-blob-segment-number", XCM_NAMESPACE);
        request.addPropertyGet("XCM:propagatable-blob-length", XCM_NAMESPACE);
        request.addPropertyGet("XCM:path", XCM_NAMESPACE);
        request.setDepth(Depth.DEPTH_1);
        IResponse response = this.performRequest((IRequest)request, "");
        if (response.getStatus() == 404) {
            throw new PropagationPreconditionException(REMOTE_SEPARATOR + propagatableBlobURL, response.getStatusDescription(), 404);
        }
        int segmentCount = request.countResources();
        IResponseEntity entity = response.getEntity();
        IPropagatableBlobSegment[] blobSegments = new IPropagatableBlobSegment[segmentCount - 1];
        int index = 1;
        while (index < segmentCount) {
            PropertyElement segmentNumber = PropagationUtil.getPropertyElement(XCM_PREFIX, PROP_BLOB_SEGMENT_NUMBER, XCM_NAMESPACE, response, entity, index);
            PropertyElement segmentLength = PropagationUtil.getPropertyElement(XCM_PREFIX, PROP_BLOB_SEGMENT_LENGTH, XCM_NAMESPACE, response, entity, index);
            PropertyElement segmentPath = PropagationUtil.getPropertyElement(XCM_PREFIX, XCM_RESOURCE_PATH, XCM_NAMESPACE, response, entity, index);
            if (segmentNumber.getStatusCode() != 200 && segmentLength.getStatusCode() != 200) {
                if (segmentNumber.getStatusCode() != 200) {
                    throw PropagationUtil.getNewPreconditionException(segmentNumber);
                }
                throw PropagationUtil.getNewPreconditionException(segmentLength);
            }
            int segNo = Integer.parseInt(segmentNumber.getValue());
            blobSegments[segNo] = new PropagatableBlobSegment(propagator, PropagationUtil.removeLeadingSlash(segmentPath.getValue()), segNo, Integer.parseInt(segmentLength.getValue()));
            ++index;
        }
        return blobSegments;
    }

    protected void setPropagatableBlobSegment(String propagatbleBlobSegmentURL, InputStream contents, int contentLength) throws PropagationException {
        StreamEntity entity = new StreamEntity(contents, "application/octet-stream");
        entity.setContentLength((long)contentLength);
        PutRequest request = new PutRequest(propagatbleBlobSegmentURL, (IRequestEntity)entity);
        IResponse response = this.performRequest((IRequest)request, "");
        if (response.getStatus() != 201) {
            throw new PropagationPreconditionException(REMOTE_SEPARATOR + propagatbleBlobSegmentURL, response.getStatusDescription());
        }
    }

    protected String getWorkingPropagatablePath(String guid) throws PropagationException {
        return WORKING_PROPS + guid;
    }

    public InputStream _getPropagatableBlobSegmentContents(String propagatbleBlobURL) throws PropagationException {
        GetRequest request = new GetRequest(propagatbleBlobURL);
        Connection connection = null;
        IResponse response = null;
        try {
            connection = this.getDtrConnection().openConnection();
            response = connection.send((IRequest)request, false);
            if (response.getStatus() != 200) {
                throw new PropagationException(this.getCombinedErrorMessage("Unable to GET propagatable blob segment", response));
            }
            return new PropagatableBlobStream(connection, response.getStream());
        }
        catch (IOException e) {
            throw new PropagationException(e);
        }
        catch (HTTPException e) {
            throw new PropagationException(e);
        }
    }

    public List getFunctionality(String functionalityName) throws PropagationException {
        ArrayList<String> functionalityList = new ArrayList<String>();
        functionalityList.add(functionalityName);
        OptionsRequest optionsRequest = new OptionsRequest("", functionalityList, false);
        IResponse response = this.performRequest((IRequest)optionsRequest, "");
        if (response.getStatus() == 200) {
            return optionsRequest.getFunctionality(functionalityName);
        }
        return null;
    }

    public boolean supportsForceWorkspaceReopen() throws PropagationException {
        boolean supportsForceWorkspaceReopen = false;
        List options = this.getFunctionality(PROP_ADMIN_OPERATIONS);
        if (options != null) {
            supportsForceWorkspaceReopen = options.contains(PROP_ADMIN_OPERATION_WSP_REOPEN);
        }
        return supportsForceWorkspaceReopen;
    }

    public void closeWorkspace(String workspaceRemotePath, String description) throws PropagationException {
        if (this.supportsForceWorkspaceReopen()) {
            IResponse response;
            AdminOperationRequest request = new AdminOperationRequest();
            request.closeWorkspace(workspaceRemotePath);
            if (description != null && description.trim().length() > 0) {
                request.setComments(description.trim());
            }
            if ((response = this.performRequest((IRequest)request, "")).getStatus() != 200) {
                if (response.getEntity() instanceof ErrorEntity) {
                    throw PropagationUtil.getNewPreconditionException((ErrorEntity)response.getEntity(), response.getStatusDescription() + ":");
                }
                if (response.getStatus() == 404) {
                    throw new PropagationPreconditionException(workspaceRemotePath, "Not Found", 404);
                }
                throw new PropagationException(this.getCombinedErrorMessage("", response));
            }
        } else {
            this.setProperty(workspaceRemotePath, VERSION_SET_STATE, "closed");
        }
    }

    public void reopenWorkspace(String workspaceRemotePath, boolean forceReopenWorkspace, String description) throws PropagationException {
        if (this.supportsForceWorkspaceReopen()) {
            IResponse response;
            AdminOperationRequest request = new AdminOperationRequest();
            request.reOpenWorkspace(workspaceRemotePath, forceReopenWorkspace);
            if (description != null && description.trim().length() > 0) {
                request.setComments(description.trim());
            }
            if ((response = this.performRequest((IRequest)request, "")).getStatus() != 200) {
                if (response.getEntity() instanceof ErrorEntity) {
                    throw PropagationUtil.getNewPreconditionException((ErrorEntity)response.getEntity(), response.getStatusDescription() + ":");
                }
                if (response.getStatus() == 404) {
                    throw new PropagationPreconditionException(workspaceRemotePath, "Not Found", 404);
                }
                throw new PropagationException(this.getCombinedErrorMessage("", response));
            }
        } else {
            if (forceReopenWorkspace) {
                throw new PropagationPreconditionException("DTR Server does not support force re-open of workspace.");
            }
            this.setProperty(workspaceRemotePath, VERSION_SET_STATE, VERSION_SET_STATE_OPEN);
        }
    }

    public boolean isPropagatableKnownInRepository(String propagatable) throws PropagationException {
        boolean existsInRepository = true;
        try {
            String count = this.getProperty("nonvresbyid/" + propagatable, XCM_NON_IMPORTED_VERSIONS_COUNT);
            existsInRepository = count.equalsIgnoreCase("0");
        }
        catch (PropagationPreconditionException ex) {
            if (ex.getErrorCode() == 404) {
                existsInRepository = false;
            }
            throw ex;
        }
        return existsInRepository;
    }

    public IPropagatableHeaderInfo extractHeaderInformation(InputStream blobContents) throws PropagationException {
        Importable.WrappedInputStream stream = new Importable.WrappedInputStream(blobContents, -1L);
        try {
            byte[] headerXMLBytes = stream.extractHeaderXMLBytes();
            int controlBytesLen = 54;
            return new PropagatableHeaderInfo(new ByteArrayInputStream(headerXMLBytes, controlBytesLen, headerXMLBytes.length - controlBytesLen));
        }
        catch (IOException e) {
            throw new PropagationException(e);
        }
    }

    public void validatePropagatableBlob(InputStream blobContents) throws PropagationException {
        ExportContentValidationStream stream = new ExportContentValidationStream(blobContents);
        int bytesRead = 0;
        byte[] bytes = new byte[4096];
        try {
            while (bytesRead != -1) {
                bytesRead = stream.read(bytes);
            }
        }
        catch (IOException e) {
            throw new PropagationException(e);
        }
    }
}

