/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.propagation;

import com.tssap.dtr.client.lib.propagation.clientapi.PropagationErrorCode;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.entities.ErrorEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.ProppatchRequest;

public class PropagationUtil {
    public static final int MAX_BYTE_VALUE = 255;
    public static final int SIZEOF_LONG = 8;
    public static final String CHARACTER_ENCODING = "UTF-8";

    public static PropertyElement getFirstPropertyElement(String prefix, String property, String namespace, IResponse response, ProppatchRequest request) throws PropagationException {
        PropertyElement propertyElement = PropagationUtil.getPropertyElement(prefix, property, namespace, response, response.getEntity(), 0);
        if (propertyElement == null) {
            throw new PropagationPreconditionException(prefix + property, "Not Found", 404);
        }
        return propertyElement;
    }

    public static PropertyElement getFirstPropertyElement(String prefix, String property, String namespace, IResponse response, PropfindRequest request) throws PropagationException {
        PropertyElement propertyElement = PropagationUtil.getPropertyElement(prefix, property, namespace, response, response.getEntity(), 0);
        if (propertyElement == null) {
            throw new PropagationPreconditionException(prefix + property, "Not Found", 404);
        }
        return propertyElement;
    }

    public static PropertyElement getPropertyElement(String prefix, String property, String namespace, IResponse response, IResponseEntity entity, int elementIndex) throws PropagationException {
        if (response.isMultiStatus() && ((MultiStatusEntity)entity).countResources() > elementIndex) {
            return ((MultiStatusEntity)entity).getResource(elementIndex).getProperty(prefix + property, namespace);
        }
        throw new PropagationException(response.getStatusDescription());
    }

    public static PropagationPreconditionException getNewPreconditionException(String precondition, String info) {
        int index;
        int errorCode = 0;
        if (precondition != null && (index = precondition.indexOf(":")) > 0) {
            precondition = precondition.substring(index + 1);
            errorCode = PropagationErrorCode.lookupErrorCodeForPrecondition(precondition);
        }
        return new PropagationPreconditionException(precondition, info, errorCode);
    }

    public static PropagationPreconditionException getNewPreconditionException(PropertyElement propertyElement) {
        String precondition = propertyElement.getErrorCondition();
        if (precondition == null) {
            precondition = propertyElement.getExtendedCondition();
        }
        return PropagationUtil.getNewPreconditionException(precondition, propertyElement.getStatusDescription());
    }

    public static PropagationPreconditionException getNewPreconditionException(ErrorEntity entity, String info) {
        String precondition = entity.getErrorCondition();
        if (precondition == null) {
            precondition = entity.getExtendedCondition();
        }
        return PropagationUtil.getNewPreconditionException(precondition, info);
    }

    public static long byteToLong(byte[] b, int off) {
        long value = 0L;
        int index = 7;
        while (index >= 0) {
            value += (long)(b[off + index] & 0xFF) << (8 - index - 1) * 8;
            --index;
        }
        return value;
    }

    public static String removeLeadingSlash(String path) {
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

